/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.util;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.host.FileSystemVolume;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.vm.api.DatastoreMirrorsInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StretchedStorageResolver {
    private static final Log LOGGER = LogFactory.getLog(StretchedStorageResolver.class);
    private static final String DATASTORES_RELATION = "datastore";
    private static final String DATASTORE_URL_PROPERTY = "summary.url";
    private static final String DATASTORE_TYPE_PROPERTY = "summary.type";
    private static final String PMEM = FileSystemVolume.FileSystemType.PMEM.name();
    private static final PropertyValue[] dummy = new PropertyValue[0];
    private static final ManagedObjectReference[] EMPTY_MORS = new ManagedObjectReference[0];
    private final DataService _dataService;

    public StretchedStorageResolver(DataService dataService) {
        if (dataService == null) {
            throw new IllegalArgumentException("Unable to instantiate " + StretchedStorageResolver.class.getName());
        }
        this._dataService = dataService;
    }

    public DatastoreMirrorsInfo[] getDatastoresInfoByVm(ManagedObjectReference vmRef) throws Exception {
        ArrayList<DatastoreMirrorsInfo> datastoresInfo = new ArrayList<DatastoreMirrorsInfo>();
        PropertyValue[] values = this.getVmDatastoreUrls(vmRef);
        if (values == null) {
            LOGGER.warn((Object)("Received no datastore urls for '" + vmRef.getValue() + "'."));
            return new DatastoreMirrorsInfo[0];
        }
        for (PropertyValue pv : values) {
            if (!(pv.value instanceof String) || !(pv.resourceObject instanceof ManagedObjectReference)) {
                LOGGER.warn((Object)("Bad data results - " + pv.value + ", " + pv.resourceObject));
                continue;
            }
            DatastoreMirrorsInfo datastoreInfo = new DatastoreMirrorsInfo();
            datastoreInfo.ref = (ManagedObjectReference)pv.resourceObject;
            datastoreInfo.url = (String)pv.value;
            datastoresInfo.add(datastoreInfo);
        }
        this.updateDatastoreMirrors(datastoresInfo);
        return (DatastoreMirrorsInfo[])ArrayUtil.toArray(datastoresInfo, DatastoreMirrorsInfo.class);
    }

    void updateDatastoreMirrors(List<DatastoreMirrorsInfo> datastoreInfos) throws Exception {
        ResultItem[] datastores = this.getAllDatastores();
        for (DatastoreMirrorsInfo datastore : datastoreInfos) {
            Object[] mirrors = StretchedStorageResolver.extractMirrors(datastore, datastores);
            if (ArrayUtil.isNullOrEmpty((Object[])mirrors)) continue;
            datastore.mirrors = mirrors;
        }
    }

    ResultItem[] getAllDatastores() throws Exception {
        Constraint constraint = new Constraint();
        constraint.targetType = Datastore.class.getSimpleName();
        QuerySpec query = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{DATASTORE_URL_PROPERTY});
        query.name = "retrieveAllDatastoresGlobally";
        ResultItem[] datastores = QueryUtil.getData((DataService)this._dataService, (QuerySpec)query).items;
        return datastores;
    }

    PropertyValue[] getVmDatastoreUrls(ManagedObjectReference vmRef) throws Exception {
        String[] props = new String[]{DATASTORE_TYPE_PROPERTY, DATASTORE_URL_PROPERTY};
        PropertyValue[] result = QueryUtil.getPropertiesForRelatedObjects((DataService)this._dataService, (Object)vmRef, (String)DATASTORES_RELATION, (String)Datastore.class.getSimpleName(), (String[])props);
        result = this.skipPMemDatastores(result);
        return result;
    }

    PropertyValue[] skipPMemDatastores(PropertyValue[] input) throws Exception {
        HashSet<Object> pmemList = new HashSet<Object>();
        for (PropertyValue pv : input) {
            Object value;
            String name = pv.propertyName;
            if (!DATASTORE_TYPE_PROPERTY.equals(name) || !PMEM.equals(value = pv.value)) continue;
            Object store = pv.resourceObject;
            pmemList.add(store);
        }
        ArrayList<PropertyValue> output = new ArrayList<PropertyValue>();
        for (PropertyValue pv : input) {
            Object store = pv.resourceObject;
            if (pmemList.contains(store)) continue;
            output.add(pv);
        }
        PropertyValue[] retVal = output.toArray(dummy);
        return retVal;
    }

    static ManagedObjectReference[] extractMirrors(DatastoreMirrorsInfo datastore, ResultItem[] candidateMirrors) {
        Object[] mirrors = EMPTY_MORS;
        if (datastore == null || datastore.ref == null) {
            LOGGER.warn((Object)"DatastoreRef is null! Return an empty array.");
            return mirrors;
        }
        if (ArrayUtil.isNullOrEmpty((Object[])candidateMirrors)) {
            LOGGER.warn((Object)"No candidate mirrors provided! Return an empty array.");
            return mirrors;
        }
        for (ResultItem datastoreData : candidateMirrors) {
            if (ArrayUtil.isNullOrEmpty((Object[])datastoreData.properties)) {
                LOGGER.warn((Object)("Empty datastore props array - " + datastoreData.properties));
                continue;
            }
            PropertyValue pv = datastoreData.properties[0];
            if (!(pv.resourceObject instanceof ManagedObjectReference) || !(pv.value instanceof String)) {
                LOGGER.warn((Object)("Bad datastore data - " + pv.value + ", " + pv.resourceObject));
                continue;
            }
            ManagedObjectReference mirrorRef = (ManagedObjectReference)pv.resourceObject;
            String mirrorUrl = (String)pv.value;
            if (!datastore.url.equals(mirrorUrl) || ManagedObjectUtil.areEqual((ManagedObjectReference)datastore.ref, (ManagedObjectReference)mirrorRef).booleanValue()) continue;
            mirrors = (ManagedObjectReference[])ArrayUtil.append((Object[])mirrors, (Object)mirrorRef);
        }
        return mirrors;
    }
}

