/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.data.mutation.impl;

import com.vmware.vise.core.model.EntitySpecPair;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.common.MappingUtil;
import com.vmware.vise.data.common.PropertyReference;
import com.vmware.vise.data.common.PropertyValidationNode;
import com.vmware.vise.data.mutation.MutationMapping;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.data.mutation.PropertyMutationData;
import com.vmware.vise.data.mutation.exception.MutationMappingNotFoundException;
import com.vmware.vise.data.mutation.impl.MutationListenerInvoker;
import com.vmware.vise.data.provider.DelegatingServiceBase;
import com.vmware.vise.data.provider.ProviderMethodNotFoundException;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.service.ServiceRegistry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MutationServiceImpl
implements MutationService {
    private static final Log _logger = LogFactory.getLog(MutationServiceImpl.class);
    private static final String ADD = "add";
    private static final String APPLY = "apply";
    private static final String REMOVE = "remove";
    private final ServiceRegistry _serviceRegistry;
    private DelegatingServiceBase _delegatingService;
    private MutationListenerInvoker _mutationListenerInvoker;

    public MutationServiceImpl(ServiceRegistry serviceRegistry) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{serviceRegistry});
        this._serviceRegistry = serviceRegistry;
        this._delegatingService = new DelegatingServiceBase(MutationProvider.class, this._serviceRegistry);
        this._mutationListenerInvoker = new MutationListenerInvoker(this._serviceRegistry);
    }

    @Override
    public OperationResult add(Object object) {
        try {
            MutationServiceImpl.checkValidSpec(object);
            OperationResult operationResult = (OperationResult)this._delegatingService.delegate(ADD, object);
            this._mutationListenerInvoker.addOperationCompleted(new OperationResult[]{operationResult});
            return operationResult;
        }
        catch (Exception exception) {
            _logger.error((Object)"MutationServiceImpl.add failed:", (Throwable)exception);
            return MutationServiceImpl.getOperationError(exception);
        }
    }

    @Override
    public OperationResult[] addMulti(Object[] objectArray) {
        try {
            MutationServiceImpl.checkValidSpecs(objectArray);
            Object object = ArrayUtil.getTypedArray((Object[])objectArray);
            OperationResult[] operationResultArray = (OperationResult[])this._delegatingService.delegate("addMulti", object);
            this._mutationListenerInvoker.addOperationCompleted(operationResultArray);
            return operationResultArray;
        }
        catch (Exception exception) {
            if (exception instanceof ProviderMethodNotFoundException) {
                OperationResult[] operationResultArray = new OperationResult[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    operationResultArray[i] = this.add(objectArray[i]);
                }
                return operationResultArray;
            }
            _logger.error((Object)"MutationServiceImpl.addMulti failed:", (Throwable)exception);
            return new OperationResult[]{MutationServiceImpl.getOperationError(exception)};
        }
    }

    @Override
    public OperationResult[] addData(ResourceSpec resourceSpec) {
        return this.doResourceSpecOperation(resourceSpec, ADD);
    }

    @Override
    public OperationResult apply(Object object, Object object2) {
        try {
            MutationServiceImpl.checkValidEntity(object);
            MutationServiceImpl.checkValidSpec(object2);
            OperationResult operationResult = (OperationResult)this._delegatingService.delegate(APPLY, object, object2);
            this._mutationListenerInvoker.applyOperationCompleted(new OperationResult[]{operationResult});
            return operationResult;
        }
        catch (Exception exception) {
            _logger.error((Object)"MutationServiceImpl.apply failed:", (Throwable)exception);
            return MutationServiceImpl.getOperationError(exception);
        }
    }

    @Override
    public OperationResult[] applyMulti(EntitySpecPair[] entitySpecPairArray) {
        OperationResult[] operationResultArray = new OperationResult[entitySpecPairArray.length];
        int n = 0;
        for (EntitySpecPair entitySpecPair : entitySpecPairArray) {
            operationResultArray[n] = this.apply(entitySpecPair.entity, entitySpecPair.spec);
            ++n;
        }
        return operationResultArray;
    }

    @Override
    public OperationResult applyMultiSpec(Object object, Object[] objectArray) {
        try {
            MutationServiceImpl.checkValidEntity(object);
            MutationServiceImpl.checkValidSpecs(objectArray);
            Object object2 = ArrayUtil.getTypedArray((Object[])objectArray);
            OperationResult operationResult = (OperationResult)this._delegatingService.delegate("applyMultiSpec", object, object2);
            this._mutationListenerInvoker.applyOperationCompleted(new OperationResult[]{operationResult});
            return operationResult;
        }
        catch (Exception exception) {
            _logger.error((Object)"MutationServiceImpl.applyMultiSpec failed:", (Throwable)exception);
            return MutationServiceImpl.getOperationError(exception);
        }
    }

    @Override
    public OperationResult[] applyOnMultiEntity(Object[] objectArray, Object object) {
        try {
            MutationServiceImpl.checkValidEntities(objectArray);
            MutationServiceImpl.checkValidSpec(object);
            Object object2 = ArrayUtil.getTypedArray((Object[])objectArray);
            OperationResult[] operationResultArray = (OperationResult[])this._delegatingService.delegate("applyOnMultiEntity", object2, object);
            this._mutationListenerInvoker.applyOperationCompleted(operationResultArray);
            return operationResultArray;
        }
        catch (Exception exception) {
            if (exception instanceof ProviderMethodNotFoundException) {
                OperationResult[] operationResultArray = new OperationResult[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    operationResultArray[i] = this.apply(objectArray[i], object);
                }
                return operationResultArray;
            }
            _logger.error((Object)"MutationServiceImpl.applyOnMultiEntity failed:", (Throwable)exception);
            return new OperationResult[]{MutationServiceImpl.getOperationError(exception)};
        }
    }

    @Override
    public OperationResult[] applyData(ResourceSpec resourceSpec) {
        return this.doResourceSpecOperation(resourceSpec, APPLY);
    }

    @Override
    public OperationResult remove(Object object, Object object2) {
        try {
            MutationServiceImpl.checkValidEntity(object);
            OperationResult operationResult = null;
            operationResult = object2 != null ? (OperationResult)this._delegatingService.delegate(REMOVE, object, object2) : (OperationResult)this._delegatingService.delegate(REMOVE, object);
            this._mutationListenerInvoker.removeOperationCompleted(new OperationResult[]{operationResult});
            return operationResult;
        }
        catch (Exception exception) {
            _logger.error((Object)"MutationServiceImpl.remove failed:", (Throwable)exception);
            return MutationServiceImpl.getOperationError(exception);
        }
    }

    @Override
    public OperationResult[] removeOnMultiEntity(Object[] objectArray, Object object) {
        try {
            MutationServiceImpl.checkValidEntities(objectArray);
            OperationResult[] operationResultArray = null;
            Object object2 = ArrayUtil.getTypedArray((Object[])objectArray);
            operationResultArray = object != null ? (OperationResult[])this._delegatingService.delegate("removeOnMultiEntity", object2, object) : (OperationResult[])this._delegatingService.delegate("removeOnMultiEntity", object2);
            this._mutationListenerInvoker.removeOperationCompleted(operationResultArray);
            return operationResultArray;
        }
        catch (Exception exception) {
            if (exception instanceof ProviderMethodNotFoundException) {
                OperationResult[] operationResultArray = new OperationResult[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    operationResultArray[i] = this.remove(objectArray[i], object);
                }
                return operationResultArray;
            }
            _logger.error((Object)"MutationServiceImpl.removeOnMultiEntity failed:", (Throwable)exception);
            return new OperationResult[]{MutationServiceImpl.getOperationError(exception)};
        }
    }

    @Override
    public OperationResult[] removeMulti(EntitySpecPair[] entitySpecPairArray) {
        OperationResult[] operationResultArray = new OperationResult[entitySpecPairArray.length];
        int n = 0;
        for (EntitySpecPair entitySpecPair : entitySpecPairArray) {
            operationResultArray[n] = this.remove(entitySpecPair.entity, entitySpecPair.spec);
            ++n;
        }
        return operationResultArray;
    }

    @Override
    public OperationResult[] removeData(ResourceSpec resourceSpec) {
        return this.doResourceSpecOperation(resourceSpec, REMOVE);
    }

    @Override
    public ValidationResult validate(Object object, Object object2) {
        try {
            MutationServiceImpl.checkValidSpec(object2);
            ValidationResult validationResult = null;
            validationResult = object != null ? (ValidationResult)this._delegatingService.delegate("validate", object, object2) : (ValidationResult)this._delegatingService.delegate("validate", object2);
            return validationResult;
        }
        catch (Exception exception) {
            _logger.error((Object)"MutationServiceImpl.validate failed:", (Throwable)exception);
            return MutationServiceImpl.getValidationError(exception);
        }
    }

    @Override
    public ValidationResult[] validateMulti(EntitySpecPair[] entitySpecPairArray) {
        ValidationResult[] validationResultArray = new ValidationResult[entitySpecPairArray.length];
        int n = 0;
        for (EntitySpecPair entitySpecPair : entitySpecPairArray) {
            validationResultArray[n] = this.validate(entitySpecPair.entity, entitySpecPair.spec);
            ++n;
        }
        return validationResultArray;
    }

    @Override
    public ValidationResult[] validateMultiSpec(Object object, Object[] objectArray) {
        try {
            MutationServiceImpl.checkValidSpecs(objectArray);
            ValidationResult[] validationResultArray = null;
            Object object2 = ArrayUtil.getTypedArray((Object[])objectArray);
            validationResultArray = object != null ? (ValidationResult[])this._delegatingService.delegate("validateMultiSpec", object, object2) : (ValidationResult[])this._delegatingService.delegate("validateMultiSpec", object2);
            return validationResultArray;
        }
        catch (Exception exception) {
            if (exception instanceof ProviderMethodNotFoundException) {
                ValidationResult[] validationResultArray = new ValidationResult[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    validationResultArray[i] = this.validate(object, objectArray[i]);
                }
                return validationResultArray;
            }
            _logger.error((Object)"MutationServiceImpl.validateMultiSpec failed:", (Throwable)exception);
            return new ValidationResult[]{MutationServiceImpl.getValidationError(exception)};
        }
    }

    @Override
    public ValidationResult[] validateOnMultiEntity(Object[] objectArray, Object object) {
        try {
            MutationServiceImpl.checkValidSpec(object);
            Object object2 = ArrayUtil.getTypedArray((Object[])objectArray);
            ValidationResult[] validationResultArray = (ValidationResult[])this._delegatingService.delegate("validateOnMultiEntity", object2, object);
            return validationResultArray;
        }
        catch (Exception exception) {
            if (exception instanceof ProviderMethodNotFoundException) {
                if (objectArray != null && objectArray.length != 0) {
                    ValidationResult[] validationResultArray = new ValidationResult[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        validationResultArray[i] = this.validate(objectArray[i], object);
                    }
                    return validationResultArray;
                }
                return new ValidationResult[]{this.validate(null, object)};
            }
            _logger.error((Object)"MutationServiceImpl.validateOnMultiEntity failed:", (Throwable)exception);
            return new ValidationResult[]{MutationServiceImpl.getValidationError(exception)};
        }
    }

    @Override
    public ValidationResult[] validateData(ResourceSpec resourceSpec) {
        return this.doResourceSpecValidation(resourceSpec, "validate");
    }

    private OperationResult[] doResourceSpecOperation(ResourceSpec resourceSpec, String string) {
        ResourceMutationData[] resourceMutationDataArray;
        LinkedList linkedList = new LinkedList();
        try {
            MutationServiceImpl.checkValidSpec(resourceSpec);
            resourceMutationDataArray = MutationServiceImpl.resolveResources(resourceSpec);
        }
        catch (Exception exception) {
            _logger.error((Object)("Mutation operation '" + string + "' failed"), (Throwable)exception);
            OperationResult operationResult = MutationServiceImpl.getOperationError(exception);
            return new OperationResult[]{operationResult};
        }
        for (ResourceMutationData resourceMutationData : resourceMutationDataArray) {
            OperationResult[] operationResultArray = this.invokeOperationProvider(resourceMutationData, string);
            Collections.addAll(linkedList, operationResultArray);
        }
        ResourceMutationData[] resourceMutationDataArray2 = linkedList.toArray(new OperationResult[linkedList.size()]);
        if (string.equals(ADD)) {
            this._mutationListenerInvoker.addOperationCompleted((OperationResult[])resourceMutationDataArray2);
        } else if (string.equals(APPLY)) {
            this._mutationListenerInvoker.applyOperationCompleted((OperationResult[])resourceMutationDataArray2);
        } else if (string.equals(REMOVE)) {
            this._mutationListenerInvoker.removeOperationCompleted((OperationResult[])resourceMutationDataArray2);
        }
        return resourceMutationDataArray2;
    }

    private ValidationResult[] doResourceSpecValidation(ResourceSpec resourceSpec, String string) {
        ResourceMutationData[] resourceMutationDataArray;
        LinkedList<ValidationResult> linkedList = new LinkedList<ValidationResult>();
        try {
            MutationServiceImpl.checkValidSpec(resourceSpec);
            resourceMutationDataArray = MutationServiceImpl.resolveResources(resourceSpec);
        }
        catch (Exception exception) {
            _logger.error((Object)"Validation failed", (Throwable)exception);
            ValidationResult validationResult = MutationServiceImpl.getValidationError(exception);
            return new ValidationResult[]{validationResult};
        }
        for (ResourceMutationData resourceMutationData : resourceMutationDataArray) {
            ValidationResult validationResult = this.invokeValidationProvider(resourceMutationData, string);
            linkedList.add(validationResult);
        }
        return linkedList.toArray(new ValidationResult[linkedList.size()]);
    }

    private static ResourceMutationData[] resolveResources(ResourceSpec resourceSpec) {
        LinkedList<ResourceMutationData> linkedList = new LinkedList<ResourceMutationData>();
        if (!(resourceSpec.constraint instanceof ObjectIdentityConstraint)) {
            throw new UnsupportedOperationException("Mutation requests for constraintsother than ObjectIdentityConstraint not supported yet!");
        }
        Object object = ((ObjectIdentityConstraint)resourceSpec.constraint).target;
        String string = resourceSpec.propertySpecs[0].propertyNames[0];
        Object object2 = resourceSpec.propertySpecs[0].parameters[0].parameter;
        PropertyReference propertyReference = new PropertyReference();
        propertyReference.providerRef = object;
        propertyReference.propertyName = string;
        propertyReference.argument = object2;
        linkedList.add(new ResourceMutationData(propertyReference));
        return linkedList.toArray(new ResourceMutationData[linkedList.size()]);
    }

    private MethodInfo lookupMethodInfo(ResourceMutationData resourceMutationData, String string) {
        String string2 = QueryUtil.getReferenceType((Object)resourceMutationData.getResourceRef().providerRef);
        String string3 = resourceMutationData.getResourceRef().propertyName;
        Map<String, Object> map = resourceMutationData.getDiscoveredArgs();
        List list = this._serviceRegistry.getServices(MutationProvider.class.getName());
        for (MutationProvider mutationProvider : list) {
            Method[] methodArray;
            for (Method method : methodArray = mutationProvider.getClass().getMethods()) {
                MutationMapping mutationMapping = method.getAnnotation(MutationMapping.class);
                if (mutationMapping == null || !method.getName().startsWith(string) || !MappingUtil.matchesMapping((String)mutationMapping.type(), (String)mutationMapping.property(), (String)string2, (String)string3, map)) continue;
                return new MethodInfo(mutationProvider, method);
            }
        }
        return null;
    }

    private OperationResult[] invokeOperationProvider(ResourceMutationData resourceMutationData, String string) {
        OperationResult[] operationResultArray;
        try {
            OperationResult[] operationResultArray2 = this.invokeMethod(resourceMutationData, string);
            if (operationResultArray2 instanceof OperationResult) {
                operationResultArray = new OperationResult[]{(OperationResult)operationResultArray2};
            } else if (operationResultArray2 instanceof OperationResult[]) {
                operationResultArray = operationResultArray2;
            } else {
                Class<?> clazz = operationResultArray2 == null ? null : operationResultArray2.getClass();
                OperationResult operationResult = new OperationResult();
                operationResult.error = new Exception("Unexpected return type: " + clazz);
                operationResultArray = new OperationResult[]{operationResult};
                _logger.error((Object)String.format("Unknown return type %s has been returned when mutation operation %s had been invoked for object %s", clazz, string, resourceMutationData.getResourceRef().providerRef));
            }
        }
        catch (Exception exception) {
            operationResultArray = new OperationResult[]{MutationServiceImpl.getOperationError(exception)};
            _logger.error((Object)("Error when invoking operation '" + string + "' on object " + resourceMutationData.getResourceRef().providerRef), (Throwable)exception);
        }
        for (OperationResult operationResult : operationResultArray) {
            PropertyReference propertyReference = resourceMutationData.getResourceRef();
            if (operationResult.entity != null || operationResult.propertyName != null || operationResult.parameter != null) continue;
            operationResult.entity = propertyReference.providerRef;
            operationResult.propertyName = propertyReference.propertyName;
            operationResult.parameter = propertyReference.argument;
        }
        return operationResultArray;
    }

    private ValidationResult invokeValidationProvider(ResourceMutationData resourceMutationData, String string) {
        ValidationResult validationResult;
        try {
            validationResult = (ValidationResult)this.invokeMethod(resourceMutationData, string);
            if (validationResult == null) {
                validationResult = new ValidationResult();
            }
        }
        catch (Exception exception) {
            validationResult = MutationServiceImpl.getValidationError(exception);
            _logger.error((Object)("Error when invoking operation '" + string + "' on object " + resourceMutationData.getResourceRef().providerRef), (Throwable)exception);
        }
        PropertyReference propertyReference = resourceMutationData.getResourceRef();
        if (validationResult.entity == null && validationResult.propertyName == null && validationResult.parameter == null) {
            validationResult.entity = propertyReference.providerRef;
            validationResult.propertyName = propertyReference.propertyName;
            validationResult.parameter = propertyReference.argument;
        }
        if (validationResult.result == null) {
            PropertyValidationNode propertyValidationNode = new PropertyValidationNode();
            propertyValidationNode.propertyName = resourceMutationData.getResourceRef().propertyName;
            validationResult.result = propertyValidationNode;
        }
        return validationResult;
    }

    private Object invokeMethod(ResourceMutationData resourceMutationData, String string) throws IllegalAccessException, InvocationTargetException {
        Object[] objectArray;
        Object object;
        MethodInfo methodInfo = this.lookupMethodInfo(resourceMutationData, string);
        if (methodInfo == null) {
            throw new MutationMappingNotFoundException(resourceMutationData.getResourceRef(), string);
        }
        if (resourceMutationData.getResourceRef().argument instanceof PropertyMutationData) {
            object = (PropertyMutationData)resourceMutationData.getResourceRef().argument;
            objectArray = new Object[]{resourceMutationData.getResourceRef().providerRef, ((PropertyMutationData)object).propertyParameter, ((PropertyMutationData)object).data};
        } else {
            objectArray = new Object[]{resourceMutationData.getResourceRef().providerRef, resourceMutationData.getResourceRef().argument};
        }
        object = resourceMutationData.getDiscoveredArgs();
        Object[] objectArray2 = MappingUtil.resolveArgs((Method)methodInfo.method, (Object[])objectArray, (Map)object);
        try {
            return methodInfo.method.invoke((Object)methodInfo.provider, objectArray2);
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception, "Failure in provider " + methodInfo.provider + ", method " + methodInfo.method);
        }
    }

    private static OperationResult getOperationError(Exception exception) {
        OperationResult operationResult = new OperationResult();
        operationResult.error = exception;
        return operationResult;
    }

    private static ValidationResult getValidationError(Exception exception) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.error = exception;
        return validationResult;
    }

    private static void checkValidSpec(Object object) throws IllegalArgumentException {
        if (object != null) {
            return;
        }
        throw new IllegalArgumentException("The spec parameter cannot be null");
    }

    private static void checkValidSpecs(Object[] objectArray) throws IllegalArgumentException {
        if (objectArray != null && objectArray.length != 0) {
            return;
        }
        throw new IllegalArgumentException("The spec param cannot be null or empty in the MutationService methods");
    }

    private static void checkValidEntity(Object object) throws IllegalArgumentException {
        if (object != null) {
            return;
        }
        throw new IllegalArgumentException("The entity param cannot be null in the MutationService methods");
    }

    private static void checkValidEntities(Object[] objectArray) throws IllegalArgumentException {
        if (objectArray != null && objectArray.length != 0) {
            return;
        }
        throw new IllegalArgumentException("The entity param cannot be null or empty in the MutationService methods");
    }

    private static class ResourceMutationData {
        private PropertyReference _resourceRef;
        private Map<String, Object> _discoveredArgs;

        public ResourceMutationData(PropertyReference propertyReference) {
            this._resourceRef = propertyReference;
            this._discoveredArgs = new HashMap<String, Object>();
        }

        public PropertyReference getResourceRef() {
            return this._resourceRef;
        }

        public Map<String, Object> getDiscoveredArgs() {
            return this._discoveredArgs;
        }
    }

    private static class MethodInfo {
        public MutationProvider provider;
        public Method method;

        public MethodInfo(MutationProvider mutationProvider, Method method) {
            this.provider = mutationProvider;
            this.method = method;
        }
    }
}

