/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.cm.client;

import com.vmware.cis.cm.client.CisServiceType;
import com.vmware.cis.cm.common.ComponentManagerFaultErrorCode;
import com.vmware.cis.cm.common.EndpointUtil;
import com.vmware.vim.binding.cis.cm.ComponentManager;
import com.vmware.vim.binding.cis.cm.SearchCriteria;
import com.vmware.vim.binding.cis.cm.ServiceInfo;
import com.vmware.vim.binding.cis.cm.ServiceInstanceContent;
import com.vmware.vim.binding.cis.cm.ServiceManager;
import com.vmware.vim.binding.cis.cm.ServiceSpec;
import com.vmware.vim.binding.cis.cm.ServiceType;
import com.vmware.vim.binding.cis.cm.fault.ComponentManagerFault;
import com.vmware.vim.binding.cis.cm.fault.InvalidLoginFault;
import com.vmware.vim.binding.cis.cm.site.Folder;
import com.vmware.vim.binding.impl.cis.cm.SearchCriteriaImpl;
import com.vmware.vim.binding.impl.cis.cm.site.FolderImpl;
import com.vmware.vim.binding.vmodl.LocalizableMessage;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.client.Client;
import com.vmware.vim.vmomi.client.ClientConfiguration;
import com.vmware.vim.vmomi.client.common.UnexpectedStatusCodeException;
import com.vmware.vim.vmomi.client.common.impl.ClientFutureImpl;
import com.vmware.vim.vmomi.client.exception.ConnectionException;
import com.vmware.vim.vmomi.client.exception.TransportProtocolException;
import com.vmware.vim.vmomi.client.http.HttpClientConfiguration;
import com.vmware.vim.vmomi.client.http.ThumbprintVerifier;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.RequestContext;
import com.vmware.vim.vmomi.core.Stub;
import com.vmware.vim.vmomi.core.impl.RequestContextImpl;
import com.vmware.vim.vmomi.core.security.SignInfo;
import com.vmware.vim.vmomi.core.security.impl.SignInfoImpl;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.VmodlTypeMap;
import com.vmware.vim.vmomi.core.types.VmodlVersion;
import com.vmware.vim.vmomi.core.types.VmodlVersionMap;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class ComponentManagerClient {
    private static Log _log = LogFactory.getLog(ComponentManagerClient.class);
    public static final String VMODL_CONTEXT = "com.vmware.vim.binding.cis.cm";
    public static final String VMODL_TYPE = "cis.cm";
    public static final String VMODL_VERSION = "1.0";
    public static final int DEFAULT_PORT = 18090;
    public static final Folder LOCAL_FOLDER = new FolderImpl("", null, "");
    private final Map<String, ServiceInfo> _cache;
    private final ExecutorService _executor;
    private final Client _client;
    private final ComponentManager _componentManager;
    private final ServiceManager _serviceManager;
    private String _clientHostId;
    private static VmodlContext _cmVmodlContext;
    private static AtomicInteger _cmClientThreadNumber;

    private static synchronized VmodlContext getCmVmodlContext() {
        if (_cmVmodlContext == null) {
            _cmVmodlContext = VmodlContext.createContext((String[])new String[]{VMODL_CONTEXT});
        }
        return _cmVmodlContext;
    }

    public ComponentManagerClient(URI address, KeyStore trustStore, ThumbprintVerifier verifier) throws URISyntaxException {
        this(address, trustStore, verifier, null);
    }

    public ComponentManagerClient(URI address, KeyStore trustStore, ThumbprintVerifier verifier, CertStore certStore) throws URISyntaxException {
        this(address, ComponentManagerClient.createConstructorInfo(trustStore, verifier, certStore));
    }

    public ComponentManagerClient(URI address, HttpClientConfiguration clientConfig) throws URISyntaxException {
        this(address, new ConstructorInfo(clientConfig, null));
    }

    private ComponentManagerClient(URI address, ConstructorInfo constructorInfo) throws URISyntaxException {
        if (address == null || address.toString().equals("")) {
            throw new URISyntaxException("", "CM address is empty");
        }
        if (address.getScheme() == null) {
            throw new URISyntaxException(address.toString(), "Invalid CM address");
        }
        this._cache = new ConcurrentHashMap<String, ServiceInfo>();
        this._executor = constructorInfo._executor;
        VmodlContext ctx = ComponentManagerClient.getCmVmodlContext();
        this._client = ComponentManagerClient.createClient(address, ctx, constructorInfo._config);
        VmodlTypeMap typeMap = ctx.getVmodlTypeMap();
        this._componentManager = this.createMoStub(ComponentManager.class, this._client, typeMap.getVmodlType(ComponentManager.class).getWsdlName(), "ComponentManager");
        this._serviceManager = this.createMoStub(ServiceManager.class, this._client, typeMap.getVmodlType(ServiceManager.class).getWsdlName(), "ServiceManager");
        this._clientHostId = ComponentManagerClient.getClientHostId(address);
    }

    public URI getUri() {
        return this._client.getBinding().getEndpointUri();
    }

    private static String getClientHostId(URI address) {
        String query = address.getQuery();
        if (query != null) {
            String[] paramArr;
            for (String paramStr : paramArr = query.split("&")) {
                String[] param = paramStr.split("=", 2);
                if (param.length <= 1) continue;
                try {
                    String key = URLDecoder.decode(param[0], "UTF-8");
                    if (key.equalsIgnoreCase("hostId")) {
                        return URLDecoder.decode(param[1], "UTF-8");
                    }
                }
                catch (UnsupportedEncodingException e) {
                    _log.error((Object)String.format("Failed to decode URI parameter; uri:%s, param:%s", address, paramStr), (Throwable)e);
                }
            }
        }
        return null;
    }

    public void setClientHostId(String hostId) {
        this._clientHostId = hostId;
    }

    private static ConstructorInfo createConstructorInfo(KeyStore trustStore, ThumbprintVerifier verifier, CertStore certStore) {
        ThreadFactory threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName(String.format("CM-client-thread-%d", _cmClientThreadNumber.incrementAndGet()));
                return t;
            }
        };
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        HttpClientConfiguration clientConfig = HttpClientConfiguration.Factory.newInstance();
        clientConfig.setExecutor((Executor)threadPool);
        clientConfig.getHttpConfiguration().setTrustStore(trustStore);
        clientConfig.getHttpConfiguration().setThumbprintVerifier(verifier);
        if (null != certStore) {
            clientConfig.getHttpConfiguration().setCrlCertStore(certStore);
        }
        return new ConstructorInfo(clientConfig, threadPool);
    }

    @Deprecated
    public ComponentManagerClient(String address) throws NumberFormatException, URISyntaxException {
        this(ComponentManagerClient.makeComponentManagerUri(address), null, null);
    }

    @Deprecated
    public ComponentManagerClient(String host, int port) throws URISyntaxException {
        this(ComponentManagerClient.makeComponentManagerUri(host, port), null, null);
    }

    private static URI makeComponentManagerUri(String address) throws URISyntaxException {
        StringTokenizer strtok = new StringTokenizer(address, ":");
        String cmHost = strtok.nextToken();
        int cmPort = 18090;
        if (strtok.hasMoreTokens()) {
            cmPort = Integer.valueOf(strtok.nextToken());
        }
        return ComponentManagerClient.makeComponentManagerUri(cmHost, cmPort);
    }

    private static URI makeComponentManagerUri(String cmHost, int cmPort) throws URISyntaxException {
        return new URI(String.format("http://%s:%s/cm/sdk", cmHost, cmPort));
    }

    private static Client createClient(URI serverUri, VmodlContext ctx, HttpClientConfiguration clientConfig) {
        VmodlVersionMap versionMap = ctx.getVmodlVersionMap();
        VmodlVersion version = versionMap.findVersion(VMODL_TYPE, VMODL_VERSION);
        _log.info((Object)String.format("Creating CM client; uri:%s, VMODL version:%s", serverUri.toASCIIString(), version));
        return Client.Factory.createClient((URI)serverUri, (Class)version.getVersionClass(), (VmodlContext)ctx, (ClientConfiguration)clientConfig);
    }

    protected <T> T createMoStub(Class<T> klass, Client cli, String wsdlType, String moid) {
        return (T)cli.createStub(klass, ComponentManagerClient.createMoRef(wsdlType, moid));
    }

    private static ManagedObjectReference createMoRef(String wsdlType, String moid) {
        ManagedObjectReference ref = new ManagedObjectReference();
        ref.setType(wsdlType);
        ref.setValue(moid);
        return ref;
    }

    public boolean shutdown() throws SecurityException {
        this._client.shutdown();
        if (this._executor == null) {
            return true;
        }
        try {
            this._executor.shutdown();
        }
        catch (Exception e) {
            _log.warn((Object)"Could not shut down thread pool", (Throwable)e);
            return false;
        }
        return true;
    }

    public void waitForStart(int attempts, int intervalBetweenAttemptsSecs) throws ExecutionException, InterruptedException {
        ComponentManagerClient.retry(attempts, intervalBetweenAttemptsSecs, "Waiting for CM to start up", new RetryableAction<ComponentManager>(){

            @Override
            public ComponentManager call(boolean lastTry) throws Exception {
                try {
                    ClientFutureImpl f = new ClientFutureImpl();
                    ComponentManagerClient.this._componentManager.loginByToken((Future)f);
                    f.get();
                    return ComponentManagerClient.this._componentManager;
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof InvalidLoginFault) {
                        return ComponentManagerClient.this._componentManager;
                    }
                    _log.warn((Object)String.format("Failed to connect to CM; uri:%s", ComponentManagerClient.this.getUri()), (Throwable)e);
                    if (lastTry || !ComponentManagerClient.this.isConnectionException(cause)) {
                        throw e;
                    }
                    return null;
                }
            }
        });
    }

    private boolean isConnectionException(Throwable e) {
        if (e instanceof UnexpectedStatusCodeException) {
            return true;
        }
        return e instanceof ConnectionException || e instanceof TransportProtocolException;
    }

    private static <T> T retry(int maxAttempts, int interval, String actionDesc, RetryableAction<T> action) throws ExecutionException, InterruptedException {
        long now;
        int attemptNo = 0;
        ExecutionException resException = null;
        long NANOSEC_IN_SEC = 1000000000L;
        long timeStarted = System.nanoTime() / 1000000000L;
        long retryUntil = timeStarted + (long)(interval * maxAttempts);
        while (true) {
            now = System.nanoTime() / 1000000000L;
            boolean lastTry = ++attemptNo >= maxAttempts || now > retryUntil;
            resException = null;
            try {
                T res = action.call(lastTry);
                if (res != null) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)String.format("%s succeeded", actionDesc));
                    }
                    return res;
                }
            }
            catch (ExecutionException e) {
                resException = e;
            }
            catch (Exception e) {
                resException = new ExecutionException(e);
            }
            if (lastTry || resException != null) break;
            if (_log.isInfoEnabled()) {
                _log.info((Object)String.format("%s; unsuccessful attempt %d of %d (left: %dsec); waiting %d seconds", actionDesc, attemptNo, maxAttempts, retryUntil - now, interval));
            }
            Thread.sleep((long)interval * 1000L);
        }
        if (_log.isInfoEnabled()) {
            now = System.nanoTime() / 1000000000L;
            _log.info((Object)String.format("%s failed after trying %d (of %d) times over %d seconds", actionDesc, attemptNo, maxAttempts, now - timeStarted));
        }
        if (resException != null) {
            throw resException;
        }
        return null;
    }

    public void login(SamlToken token, PrivateKey privateKey) throws ExecutionException, InterruptedException {
        RequestContextImpl ctx = new RequestContextImpl();
        SignInfoImpl authInfo = new SignInfoImpl(privateKey, token);
        ctx.setSignInfo((SignInfo)authInfo);
        ((Stub)this._componentManager)._setRequestContext((RequestContext)ctx);
        ClientFutureImpl f = new ClientFutureImpl();
        this._componentManager.loginByToken((Future)f);
        f.get();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Succesfully logged in to CM using token type: " + (privateKey == null ? "bearer" : "holder-of-key")));
        }
    }

    public boolean isAuthenticated() throws InterruptedException {
        boolean isAuthenticated;
        block4: {
            if (_log.isTraceEnabled()) {
                _log.trace((Object)"isAuthenticated: Entering");
            }
            ClientFutureImpl f = new ClientFutureImpl();
            this._componentManager.loginByToken((Future)f);
            isAuthenticated = false;
            try {
                f.get();
            }
            catch (ExecutionException e) {
                LocalizableMessage msg;
                Throwable cause = e.getCause();
                if (cause == null || !(cause instanceof InvalidLoginFault) || !"cis.exception.invalidLoginFault.alreadyAuthenticated".equals((msg = ((InvalidLoginFault)cause).getErrorMessage()).getKey())) break block4;
                isAuthenticated = true;
            }
        }
        if (_log.isTraceEnabled()) {
            _log.trace((Object)String.format("isAuthenticated: Leaving (%b)", isAuthenticated));
        }
        return isAuthenticated;
    }

    public void logout() throws ExecutionException, InterruptedException {
        ClientFutureImpl f = new ClientFutureImpl();
        this._componentManager.logout((Future)f);
        f.get();
    }

    public boolean status() {
        try {
            this.lookupComponentManager(false);
        }
        catch (Exception e) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Error while trying to check CM status: " + e.getMessage()));
            }
            return false;
        }
        return true;
    }

    public ServiceManager getServiceManager() {
        return this._serviceManager;
    }

    public <S extends ManagedObject> S getSubManager(Class<S> type) throws ExecutionException, InterruptedException, IllegalArgumentException {
        ManagedObjectReference ref;
        block4: {
            ClientFutureImpl f = new ClientFutureImpl();
            this._componentManager.retrieveServiceInstanceContent((Future)f);
            ServiceInstanceContent subs = (ServiceInstanceContent)f.get();
            VmodlContext ctx = ComponentManagerClient.getCmVmodlContext();
            VmodlTypeMap typeMap = ctx.getVmodlTypeMap();
            ref = null;
            try {
                VmodlType vmodlType;
                Method m;
                Method[] arr$ = subs.getClass().getMethods();
                int len$ = arr$.length;
                for (int i$ = 0; !(i$ >= len$ || ManagedObjectReference.class.equals((m = arr$[i$]).getReturnType()) && type.equals((vmodlType = typeMap.getVmodlType((ref = (ManagedObjectReference)m.invoke((Object)subs, new Object[0])).getType())).getTypeClass())); ++i$) {
                }
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug((Object)"Error reflecting for SubManager", (Throwable)e);
            }
        }
        if (ref == null) {
            throw new IllegalArgumentException("Could not fulfill SubManager request of type " + type.getName());
        }
        return (S)this._client.createStub(type, ref);
    }

    public String registerService(String serviceId, ServiceSpec serviceSpec) throws ExecutionException, InterruptedException {
        if (serviceId == null) {
            serviceId = UUID.randomUUID().toString();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Registering service:\n\n" + serviceSpec.toString()));
        }
        ClientFutureImpl f = new ClientFutureImpl();
        this._serviceManager.registerService(serviceId, serviceSpec, (Future)f);
        serviceId = (String)f.get();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Successfully registered service: " + serviceId));
        }
        return serviceId;
    }

    public String registerService(ServiceSpec serviceSpec) throws ExecutionException, InterruptedException {
        return this.registerService(null, serviceSpec);
    }

    public void reregisterService(String serviceId, ServiceSpec serviceSpec) throws ExecutionException, InterruptedException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Reregistering service: " + serviceId));
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Modified service definition is\n\n" + serviceSpec.toString()));
        }
        ClientFutureImpl f = new ClientFutureImpl();
        this._serviceManager.reRegisterService(serviceId, serviceSpec, (Future)f);
        f.get();
        _log.info((Object)"Successfully reregistered the service.\n");
    }

    public void unregisterService(String serviceId) throws ExecutionException, InterruptedException {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Unegistering service: " + serviceId));
        }
        ClientFutureImpl f = new ClientFutureImpl();
        this._serviceManager.unregisterService(serviceId, (Future)f);
        f.get();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Successfully unregistered service: " + serviceId));
        }
    }

    public ServiceInfo retrieveService(String serviceId) throws Exception {
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Retrieving service: " + serviceId));
            }
            ClientFutureImpl f = new ClientFutureImpl();
            this._serviceManager.retrieveService(serviceId, (Future)f);
            ServiceInfo svc = (ServiceInfo)f.get();
            EndpointUtil.applyLocalUrl((ServiceInfo)svc, (String)this._clientHostId);
            return svc;
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Could not retrieve service: " + serviceId), (Throwable)e);
            }
            throw e;
        }
    }

    public ServiceInfo[] lookup(SearchCriteria searchCriteria) throws ExecutionException, InterruptedException {
        ClientFutureImpl f = new ClientFutureImpl();
        this._serviceManager.search(searchCriteria, (Future)f);
        ServiceInfo[] list = (ServiceInfo[])f.get();
        boolean isCriteriaVapi = false;
        if (searchCriteria.getEndPointType() != null) {
            String protocol = searchCriteria.getEndPointType().getEndPointProtocol();
            boolean bl = isCriteriaVapi = protocol != null && protocol.equals("vapi.json.https");
        }
        if (!isCriteriaVapi) {
            EndpointUtil.applyLocalUrl((ServiceInfo[])list, (String)this._clientHostId);
        }
        return list;
    }

    public ServiceInfo cachedLookup(boolean useCache, ServiceType type) throws ExecutionException, InterruptedException {
        return this.cachedLookup(useCache, type, 1, 0);
    }

    public ServiceInfo cachedLookup(boolean useCache, final ServiceType type, int maxAttempts, int interval) throws ExecutionException, InterruptedException {
        if (type == null) {
            throw new IllegalArgumentException("Service type cannot be null");
        }
        if (type.getProductId() == null || type.getTypeId() == null) {
            throw new IllegalArgumentException("Service type fields cannot be null");
        }
        String serviceTypeStr = ComponentManagerClient.serviceTypeToString(type, ':');
        if (useCache && this._cache.get(serviceTypeStr) != null) {
            return this._cache.get(serviceTypeStr);
        }
        String actionDesc = String.format("Looking up service %s", type.getTypeId());
        ServiceInfo ret = ComponentManagerClient.retry(maxAttempts, interval, actionDesc, new RetryableAction<ServiceInfo>(){

            @Override
            public ServiceInfo call(boolean lastTry) throws Exception {
                SearchCriteriaImpl search = new SearchCriteriaImpl();
                search.setServiceType(type);
                search.setFolder(LOCAL_FOLDER);
                ServiceInfo[] infos = ComponentManagerClient.this.lookup((SearchCriteria)search);
                return infos != null && infos.length > 0 ? infos[0] : null;
            }
        });
        if (ret != null) {
            this._cache.put(serviceTypeStr, ret);
        }
        return ret;
    }

    public ServiceInfo lookupSso(boolean useCache, int attempts, int intervalBetweenAttemptsSecs) throws ExecutionException, InterruptedException {
        return this.cachedLookup(useCache, CisServiceType.SSO.getServiceType(), attempts, intervalBetweenAttemptsSecs);
    }

    public ServiceInfo lookupSso(boolean useCache) throws ExecutionException, InterruptedException {
        return this.cachedLookup(useCache, CisServiceType.SSO.getServiceType());
    }

    public ServiceInfo lookupComponentManager(boolean useCache) throws ExecutionException, InterruptedException {
        return this.cachedLookup(useCache, CisServiceType.CM.getServiceType());
    }

    public ServiceInfo lookupInventory(boolean useCache) throws ExecutionException, InterruptedException {
        return this.cachedLookup(useCache, CisServiceType.IS.getServiceType());
    }

    public ServiceInfo lookupLicenseService(boolean useCache) throws ExecutionException, InterruptedException {
        return this.cachedLookup(useCache, CisServiceType.LICENSE.getServiceType());
    }

    public ServiceInfo lookupDataService(boolean useCache) throws ExecutionException, InterruptedException {
        return this.cachedLookup(useCache, CisServiceType.DS.getServiceType());
    }

    public static ComponentManagerFaultErrorCode getComponentManagerFaultType(Exception e) {
        ComponentManagerFaultErrorCode componentManagerFaultErrorCode;
        try {
            componentManagerFaultErrorCode = ComponentManagerFaultErrorCode.values()[ComponentManagerClient.getComponentManagerFaultCode(e)];
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            componentManagerFaultErrorCode = null;
        }
        return componentManagerFaultErrorCode;
    }

    public static int getComponentManagerFaultCode(Throwable e) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ComponentManagerFault)) continue;
            ComponentManagerFault cmf = (ComponentManagerFault)cause;
            return cmf.getErrorCode();
        }
        return -1;
    }

    private static String serviceTypeToString(ServiceType type, char delimiter) {
        String productId = ComponentManagerClient.escape(type.getProductId(), delimiter);
        String typeId = ComponentManagerClient.escape(type.getTypeId(), delimiter);
        return productId + delimiter + typeId;
    }

    private static String escape(String src, char c) {
        String target = String.valueOf(c);
        String replacement = target + target;
        return src.replace(target, replacement);
    }

    static {
        _cmClientThreadNumber = new AtomicInteger(0);
    }

    private static interface RetryableAction<T> {
        public T call(boolean var1) throws Exception;
    }

    private static class ConstructorInfo {
        HttpClientConfiguration _config;
        ExecutorService _executor;

        public ConstructorInfo(HttpClientConfiguration config, ExecutorService executor) {
            if (config == null) {
                throw new IllegalArgumentException("HttpClientConfiguration cannot be null");
            }
            this._config = config;
            this._executor = executor;
        }
    }
}

