/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.adapters;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.ResultItemComparator;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="Folder")
public class VCenterObjectProviderAdapter
implements DataProviderAdapter {
    private static final Log _logger = LogFactory.getLog(VCenterObjectProviderAdapter.class);
    private static final String FOLDER_TYPE = "Folder";
    private static final String LINKED_VC_RELATIONSHIP = "linkedVCenter";
    private static final int ALL_RESULTS = -1;
    private final DataService _dataService;

    public VCenterObjectProviderAdapter(DataService dataService) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{dataService});
        this._dataService = dataService;
    }

    public Response getData(RequestSpec requestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{requestSpec});
        QuerySpec[] querySpecArray = requestSpec.querySpec;
        ResultSet[] resultSetArray = new ResultSet[querySpecArray.length];
        for (int i = 0; i < querySpecArray.length; ++i) {
            resultSetArray[i] = VCenterObjectProviderAdapter.processQuery(querySpecArray[i], this._dataService);
        }
        Response response = new Response();
        response.resultSet = resultSetArray;
        return response;
    }

    private static ResultSet processQuery(QuerySpec querySpec, DataService dataService) {
        ResultSet resultSet = new ResultSet();
        resultSet.queryName = querySpec.name;
        resultSet.totalMatchedObjectCount = 0;
        if (querySpec.resourceSpec == null || !(querySpec.resourceSpec.constraint instanceof RelationalConstraint)) {
            return resultSet;
        }
        RelationalConstraint relationalConstraint = (RelationalConstraint)querySpec.resourceSpec.constraint;
        if (!relationalConstraint.relation.equals(LINKED_VC_RELATIONSHIP)) {
            return resultSet;
        }
        if (!(relationalConstraint.constraintOnRelatedObject instanceof ObjectIdentityConstraint)) {
            _logger.warn((Object)"contraint on related object is not an identity constraint");
            return resultSet;
        }
        ObjectIdentityConstraint objectIdentityConstraint = (ObjectIdentityConstraint)relationalConstraint.constraintOnRelatedObject;
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)objectIdentityConstraint.target;
        if (!managedObjectReference.getType().equals(FOLDER_TYPE)) {
            return resultSet;
        }
        Object[] objectArray = VCenterObjectProviderAdapter.getLinkedVcMoRefsForVc(managedObjectReference);
        if (objectArray.length == 0) {
            return resultSet;
        }
        resultSet.totalMatchedObjectCount = objectArray.length;
        objectArray = VCenterObjectProviderAdapter.pageResults(querySpec.resultSpec, (ManagedObjectReference[])objectArray);
        String[] stringArray = VCenterObjectProviderAdapter.getProperties(querySpec.resourceSpec.propertySpecs);
        try {
            PropertyValue[] propertyValueArray = QueryUtil.getProperties((DataService)dataService, (Object[])objectArray, (String[])stringArray);
            HashMap<ManagedObjectReference, ArrayList<PropertyValue>> hashMap = VCenterObjectProviderAdapter.buildMoRefPropertyValueMap(propertyValueArray);
            resultSet.items = VCenterObjectProviderAdapter.buildResultItems(hashMap);
        }
        catch (Exception exception) {
            resultSet.error = exception;
        }
        if (querySpec.resultSpec != null && querySpec.resultSpec.order != null && !ArrayUtil.isNullOrEmpty((Object[])querySpec.resultSpec.order.orderingProperties)) {
            Arrays.sort(resultSet.items, new ResultItemComparator(querySpec.resultSpec.order));
        }
        return resultSet;
    }

    private static ManagedObjectReference[] getLinkedVcMoRefsForVc(ManagedObjectReference managedObjectReference) {
        ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
        LinkedVcGroup linkedVcGroup = VCenterObjectProviderAdapter.getLinkedVcGroupOfVc(managedObjectReference);
        Collection collection = linkedVcGroup.getVcServices();
        for (VcService vcService : collection) {
            ManagedObjectReference managedObjectReference2 = vcService.getServiceInstanceContent().getRootFolder();
            if (managedObjectReference2.equals((Object)managedObjectReference)) continue;
            arrayList.add(managedObjectReference2);
        }
        return arrayList.toArray(new ManagedObjectReference[arrayList.size()]);
    }

    private static LinkedVcGroup getLinkedVcGroupOfVc(ManagedObjectReference managedObjectReference) {
        LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
        LinkedVcGroup[] linkedVcGroupArray = linkedVcGroupRegistry.getLinkedVcGroups();
        LinkedVcGroup linkedVcGroup = null;
        block0: for (int i = 0; linkedVcGroup == null && i < linkedVcGroupArray.length; ++i) {
            LinkedVcGroup linkedVcGroup2 = linkedVcGroupArray[i];
            Collection collection = linkedVcGroup2.getVcServices();
            for (VcService vcService : collection) {
                if (!vcService.getServiceInstanceContent().getRootFolder().equals((Object)managedObjectReference)) continue;
                linkedVcGroup = linkedVcGroup2;
                continue block0;
            }
        }
        return linkedVcGroup;
    }

    private static ManagedObjectReference[] pageResults(ResultSpec resultSpec, ManagedObjectReference[] managedObjectReferenceArray) {
        int n;
        if (resultSpec == null) {
            return managedObjectReferenceArray;
        }
        if (VCenterObjectProviderAdapter.isOffsetSpecified(resultSpec.offset) && VCenterObjectProviderAdapter.requiresAllResults(resultSpec.maxResultCount)) {
            return managedObjectReferenceArray;
        }
        if (resultSpec.order != null) {
            return managedObjectReferenceArray;
        }
        int n2 = n = resultSpec.offset != null ? resultSpec.offset : 0;
        if (n < 0 || n > managedObjectReferenceArray.length) {
            return managedObjectReferenceArray;
        }
        int n3 = resultSpec.maxResultCount != null ? resultSpec.maxResultCount : -1;
        int n4 = n + n3;
        if (n4 < 0 || n4 > managedObjectReferenceArray.length || n4 < n) {
            n4 = managedObjectReferenceArray.length;
        }
        return Arrays.copyOfRange(managedObjectReferenceArray, n, n4);
    }

    private static String[] getProperties(PropertySpec[] propertySpecArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PropertySpec propertySpec : propertySpecArray) {
            for (String string : propertySpec.propertyNames) {
                arrayList.add(string);
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static HashMap<ManagedObjectReference, ArrayList<PropertyValue>> buildMoRefPropertyValueMap(PropertyValue[] propertyValueArray) {
        HashMap<ManagedObjectReference, ArrayList<PropertyValue>> hashMap = new HashMap<ManagedObjectReference, ArrayList<PropertyValue>>();
        for (PropertyValue propertyValue : propertyValueArray) {
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)propertyValue.resourceObject;
            if (!hashMap.containsKey(managedObjectReference)) {
                hashMap.put(managedObjectReference, new ArrayList());
            }
            hashMap.get(managedObjectReference).add(propertyValue);
        }
        return hashMap;
    }

    private static ResultItem[] buildResultItems(HashMap<ManagedObjectReference, ArrayList<PropertyValue>> hashMap) {
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        for (ManagedObjectReference managedObjectReference : hashMap.keySet()) {
            ArrayList<PropertyValue> arrayList2 = hashMap.get(managedObjectReference);
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = managedObjectReference;
            resultItem.properties = arrayList2.toArray(new PropertyValue[arrayList2.size()]);
            arrayList.add(resultItem);
        }
        return arrayList.toArray(new ResultItem[arrayList.size()]);
    }

    private static boolean isOffsetSpecified(Integer n) {
        return n == null || n == 0;
    }

    private static boolean requiresAllResults(Integer n) {
        return n == null || n == -1;
    }
}

