/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.extension;

import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.scriptPlugin.ScriptPluginService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScriptPluginUtil {
    private static final Log _logger = LogFactory.getLog(ScriptPluginUtil.class);

    public static void createExtensionToUrlMap(ScriptPluginService scriptPluginService, VcService vcService, String string, String string2) {
        String string3 = string + vcService.getServiceGuid();
        scriptPluginService.setProperty(string3, string2);
    }

    public static String generateUrl(String string, VcService vcService) {
        if (string != null && (string.charAt(7) == '*' || string.charAt(8) == '*')) {
            URL uRL;
            String string2 = vcService.getServiceUrl();
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                _logger.error((Object)"The url provided is malformed.");
                return null;
            }
            String[] stringArray = string.split("://\\*");
            return stringArray[0] + "://" + uRL.getHost() + stringArray[1];
        }
        return string;
    }

    public static String replace(String string, String string2, String string3) {
        String string4 = "";
        if (string != null && string2 != null && string3 != null) {
            string4 = string.replace(string2, string3);
        }
        return string4 == null || string4 == "" ? string : string4;
    }

    public static String getNodeFromDoc(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName(string);
        if (nodeList != null && nodeList.getLength() != 0) {
            Element element = (Element)nodeList.item(0);
            NodeList nodeList2 = element.getChildNodes();
            return nodeList2.item(0).getNodeValue();
        }
        return null;
    }

    public static String createUniqueKey(String string, double d, String string2) {
        if (string != null) {
            return string + "." + string2 + "." + d;
        }
        return string2 + "." + d;
    }

    public static String getTitle(Element element) {
        Locale locale = ResourceUtil.getLocale();
        if (locale == null) {
            return ScriptPluginUtil.getEnglishTitle(element);
        }
        NodeList nodeList = element.getElementsByTagName("title");
        if (nodeList != null && nodeList.getLength() != 0) {
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element3 = (Element)nodeList.item(i);
                if (!element3.hasAttribute("locale") || !element3.getAttributeNode("locale").getNodeValue().equals(locale.getLanguage())) continue;
                NodeList nodeList3 = element3.getChildNodes();
                return nodeList3.item(0).getNodeValue();
            }
            return nodeList2.item(0).getNodeValue();
        }
        return ScriptPluginUtil.getEnglishTitle(element);
    }

    public static String getEnglishTitle(Element element) {
        NodeList nodeList = element.getElementsByTagName("title");
        if (nodeList != null && nodeList.getLength() != 0) {
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element3 = (Element)nodeList.item(i);
                if (!element3.hasAttribute("locale") || !element3.getAttributeNode("locale").getNodeValue().equals("en")) continue;
                NodeList nodeList3 = element3.getChildNodes();
                return nodeList3.item(0).getNodeValue();
            }
            return nodeList2.item(0).getNodeValue();
        }
        return null;
    }

    public static String getNodeValue(Element element, String string) {
        if (element == null || string == null) {
            return null;
        }
        Element element2 = XMLUtil.getChildTag((Node)element, (String)string);
        return ScriptPluginUtil.getNodeValue(element2);
    }

    public static String getNodeValue(Element element) {
        if (element == null) {
            return null;
        }
        return XMLUtil.getTagValue((Element)element);
    }

    public static String getNodeAttrValue(Element element, String string, String string2) {
        if (element == null || string == null || string2 == null) {
            return null;
        }
        Element element2 = XMLUtil.getChildTag((Node)element, (String)string);
        if (element2 != null) {
            return XMLUtil.getAttribute((Element)element2, (String)string2);
        }
        return null;
    }

    public static void logInvalidExtension(String string, String string2) {
        _logger.error((Object)("Parent attribute '" + string + "' in script plugin " + string2 + " is not supported by vSphere Web Client!" + "\nThe supported extension points are: HomeView, InventoryMenus " + "and InventoryView.<object> where <object> is Cluster, Host, VirtualMachine, etc." + "\nSee the vSphere Client 4.1 Script Plugins documentation at" + " https://www.vmware.com/support/developer/vc-sdk/vcplugin/vSphere_Plugin_4_1_Technote.pdf"));
    }

    public static class ActionSetInfo {
        public String uid;
        public String display;
        public String url;
        public String label;
        public Element element;
        public Node node;
    }

    public static class InventoryMenuInfo {
        public String key;
        public Element element;
        public Node node;
        public String display;
    }
}

