/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.extension;

import com.vmware.vim.binding.vim.Description;
import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.binding.vim.ExtensionManager;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vim.event.EventManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.extensionfw.ExtensionFilter;
import com.vmware.vise.extensionfw.ExtensionListener;
import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.extensionfw.PluginPackageEvent;
import com.vmware.vise.extensionfw.PluginPackageInfo;
import com.vmware.vise.extensionfw.PluginPackageSource;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.FileUtil;
import com.vmware.vise.util.IdVersionPair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.ZipUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.common.Environment;
import com.vmware.vise.util.concurrent.BlockingUtil;
import com.vmware.vise.util.concurrent.ExecutorUtil;
import com.vmware.vise.util.concurrent.QueuingCachedThreadPool;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.http.HttpClient;
import com.vmware.vise.util.io.StreamUtil;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.LoginSpec;
import com.vmware.vise.vim.commons.vcservice.ServerInfoEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.commons.vcservice.VcServiceCompatibilityChecker;
import com.vmware.vise.vim.commons.vcservice.VcServiceCompatibilityResult;
import com.vmware.vise.vim.commons.vcservice.VcSource;
import com.vmware.vise.vim.commons.vcservice.impl.LinkedVcGroupImpl;
import com.vmware.vise.vim.commons.vcservice.impl.VcServiceImpl;
import com.vmware.vise.vim.extension.util.VcExtensionUtil;
import com.vmware.vise.vim.i18n.VimServicesVsphereUtil;
import com.vmware.vise.vim.security.sso.SsoSolutionUser;
import com.vmware.vise.vim.security.sso.SsoUtil;
import com.vmware.vise.vim.vsphere.internal.Config;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VcExtensionManager
implements UserSessionListener,
ExtensionFilter,
ExtensionListener,
PluginPackageSource {
    private static final Log _logger = LogFactory.getLog(VcExtensionManager.class);
    private static final String POOL_NAME = "vc-extensionmanager-pool";
    private static final ExecutorService EXECUTOR = ThreadPoolFactory.newQueingCachedThreadPool((int)30, (ThreadFactory)new WorkerThreadFactory("vc-extensionmanager-pool"), (long)10L, (TimeUnit)TimeUnit.SECONDS, (long)1L, (TimeUnit)TimeUnit.MINUTES, (QueuingCachedThreadPool.TaskExpirationPolicy)QueuingCachedThreadPool.TaskExpirationPolicy.CALLER_RUNS);
    private static final String SERVER_GUIDS = "vcServerGuids";
    private static final String SESSION_PACKAGES_REFS = "vcPackagesRefs";
    private static final int MIN_DEPLOY_DELAY_MINUTES = 1;
    private static final long DEFAULT_DEPLOYMENT_TIMEOUT_MINUTES = 10L;
    private static final String DEPLOYMENT_TIMEOUT_PROP_NAME = "newPlugins.deployTimeout";
    protected ExtensionService _extensionService;
    protected String _extensionType;
    protected ConfigurationService _configurationService;
    protected VcSource _vcSource;
    @Nullable
    protected VcServiceCompatibilityChecker _vcCompatibilityChecker;
    @Nullable
    protected SSLConfigurationProvider _sslConfigurationProvider;
    private final CopyOnWriteArraySet<IdVersionPair> _packageRefs = new CopyOnWriteArraySet();
    private final CopyOnWriteArraySet<IdVersionPair> _allPackageRefs = new CopyOnWriteArraySet();
    private volatile Calendar _lastDeployTime = null;

    @Deprecated
    public VcExtensionManager(@Nonnull ExtensionService extensionService, @Nonnull String string, @Nonnull ConfigurationService configurationService, @Nonnull VcSource vcSource) {
        this(false, (ExtensionService)ValidationUtil.notNull((Object)extensionService, (String)"extensionService is null"), (String)ValidationUtil.notNull((Object)string, (String)"extensionType is null"), (ConfigurationService)ValidationUtil.notNull((Object)configurationService, (String)"configurationService is null"), (VcSource)ValidationUtil.notNull((Object)vcSource, (String)"vcSource is null"), null, null);
    }

    public VcExtensionManager(@Nonnull ExtensionService extensionService, @Nonnull String string, @Nonnull ConfigurationService configurationService, @Nonnull VcSource vcSource, @Nonnull SSLConfigurationProvider sSLConfigurationProvider, @Nullable VcServiceCompatibilityChecker vcServiceCompatibilityChecker) {
        this(true, (ExtensionService)ValidationUtil.notNull((Object)extensionService, (String)"extensionService is null"), (String)ValidationUtil.notNull((Object)string, (String)"extensionType is null"), (ConfigurationService)ValidationUtil.notNull((Object)configurationService, (String)"configurationService is null"), (VcSource)ValidationUtil.notNull((Object)vcSource, (String)"vcSource is null"), (SSLConfigurationProvider)ValidationUtil.notNull((Object)sSLConfigurationProvider, (String)"sslConfigurationProvider is null"), vcServiceCompatibilityChecker);
    }

    private VcExtensionManager(boolean bl, ExtensionService extensionService, String string, ConfigurationService configurationService, VcSource vcSource, SSLConfigurationProvider sSLConfigurationProvider, VcServiceCompatibilityChecker vcServiceCompatibilityChecker) {
        this._extensionService = extensionService;
        this._extensionType = string;
        this._configurationService = configurationService;
        this._vcSource = vcSource;
        this._vcCompatibilityChecker = vcServiceCompatibilityChecker;
        this._sslConfigurationProvider = sSLConfigurationProvider;
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
        String string;
        HttpSession httpSession = httpSessionEvent.getSession();
        if (_logger.isDebugEnabled()) {
            string = SessionUtil.getHashedSessionId((HttpSession)httpSession);
            _logger.debug((Object)("VC Extensions session init start " + string));
        }
        string = VimSessionUtil.getLinkedVcGroupRegistry((HttpSession)httpSessionEvent.getSession());
        LinkedVcGroup[] linkedVcGroupArray = string.getUtils().getStartupLinkedVcGroups();
        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>();
        for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray) {
            Set<IdVersionPair> set = this.addPackages(linkedVcGroup.getVcServices(), false);
            hashSet.addAll(set);
        }
        if (!hashSet.isEmpty()) {
            SessionUtil.setData((String)this.getSessionKey(), hashSet, (HttpSession)httpSession);
        }
        if (_logger.isDebugEnabled()) {
            String string2 = SessionUtil.getHashedSessionId((HttpSession)httpSession);
            _logger.debug((Object)("VC Extensions session init complete " + string2));
        }
    }

    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
    }

    public void filterPackages(Set<IdVersionPair> set) {
        Set set2 = (Set)SessionUtil.getData((String)this.getSessionKey());
        Iterator<IdVersionPair> iterator = set.iterator();
        while (iterator.hasNext()) {
            IdVersionPair idVersionPair = iterator.next();
            if (!this._packageRefs.contains(idVersionPair) || set2 != null && set2.contains(idVersionPair)) continue;
            iterator.remove();
        }
    }

    public void handleEvent(PluginPackageEvent pluginPackageEvent) throws Exception {
        if (pluginPackageEvent.getType().equals("pluginPackageDeployed")) {
            this._lastDeployTime = Calendar.getInstance();
        }
        if (!pluginPackageEvent.getType().equals("pluginPackageUndeployed")) {
            return;
        }
        for (PluginPackageInfo pluginPackageInfo : pluginPackageEvent.getPluginPackageInfos()) {
            this.packageUndeployed(pluginPackageInfo.getPackageRef());
        }
    }

    public Set<IdVersionPair> deployNewPackages() {
        if (!this.isNewDeploymentAllowed()) {
            return Collections.emptySet();
        }
        Thread.currentThread().setContextClassLoader(VcExtensionManager.class.getClassLoader());
        Thread.currentThread().setPriority(1);
        List<VcServiceImpl> list = this.loginToVcs(this._vcSource.getVcs());
        Set<IdVersionPair> set = this.addPackages(list, true);
        this.logoutFromVcs(list);
        return set;
    }

    protected String getSessionKey() {
        return SESSION_PACKAGES_REFS;
    }

    protected boolean isPackageAlreadyDeployed(IdVersionPair idVersionPair) {
        try {
            return this._packageRefs.contains(idVersionPair) || this._extensionService.getPluginPackageInfo(idVersionPair) != null;
        }
        catch (Exception exception) {
            _logger.error((Object)("Could not get the plugin package info for " + idVersionPair), (Throwable)exception);
            return false;
        }
    }

    protected List<VcPackageInfo> getVcPackages(ExtensionManager extensionManager) {
        ArrayList<VcPackageInfo> arrayList = new ArrayList<VcPackageInfo>();
        Extension[] extensionArray = extensionManager.getExtensionList();
        if (extensionArray == null) {
            return arrayList;
        }
        for (Extension extension : extensionArray) {
            VcPackageInfo vcPackageInfo = this.getVcPackageInfo(extension);
            if (vcPackageInfo == null) continue;
            arrayList.add(vcPackageInfo);
        }
        return arrayList;
    }

    protected boolean isNewDeploymentAllowed() {
        if (this._lastDeployTime == null) {
            return true;
        }
        Calendar calendar = (Calendar)this._lastDeployTime.clone();
        calendar.add(12, 1);
        return Calendar.getInstance().after(calendar);
    }

    private List<VcServiceImpl> loginToVcs(List<ServerInfoEx> list) {
        ArrayList<VcServiceImpl> arrayList = new ArrayList<VcServiceImpl>();
        for (ServerInfoEx serverInfoEx : list) {
            VcServiceImpl vcServiceImpl;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Logging in to VC " + serverInfoEx.serviceUrl));
            }
            if ((vcServiceImpl = this.getVcService(serverInfoEx)) == null) continue;
            arrayList.add(vcServiceImpl);
        }
        return arrayList;
    }

    private VcServiceImpl getVcService(ServerInfoEx serverInfoEx) {
        VcServiceImpl vcServiceImpl = null;
        try {
            VcServiceCompatibilityResult vcServiceCompatibilityResult;
            boolean bl;
            SsoSolutionUser ssoSolutionUser = SsoUtil.getSolutionUser();
            LoginSpec loginSpec = VcServiceUtil.createVcLoginSpec((ServerInfoEx)serverInfoEx);
            loginSpec.token = ssoSolutionUser.getLoggedInToken();
            loginSpec.privateKey = ssoSolutionUser.getPrivateKey();
            vcServiceImpl = LinkedVcGroupImpl.createVcService((LoginSpec)loginSpec, null, null);
            if (this._vcCompatibilityChecker != null && !(bl = (vcServiceCompatibilityResult = this._vcCompatibilityChecker.verify((VcService)vcServiceImpl)).isCompatible())) {
                _logger.warn((Object)("VcService " + vcServiceImpl.getServiceUrl() + " is incompatible: " + vcServiceCompatibilityResult.getFailure().toString()));
                return null;
            }
            vcServiceImpl.login();
        }
        catch (Exception exception) {
            vcServiceImpl = null;
            _logger.error((Object)("Error creating VcService for " + serverInfoEx.serviceUrl), (Throwable)exception);
        }
        return vcServiceImpl;
    }

    private void logoutFromVcs(List<VcServiceImpl> list) {
        for (VcServiceImpl vcServiceImpl : list) {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Logging out from VC " + vcServiceImpl.getServiceUrl()));
            }
            try {
                vcServiceImpl.logout();
            }
            catch (Exception exception) {
                _logger.error((Object)("Could not log out from VC " + vcServiceImpl.getServiceUrl()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Set<IdVersionPair> addPackages(Collection<? extends VcService> collection, boolean bl) {
        void var8_13;
        ExecutorUtil.TaskResult taskResult;
        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>();
        VcService[] vcServiceArray = new VcService[collection.size()];
        ArrayList<1> arrayList = new ArrayList<1>();
        int n = 0;
        for (final VcService vcService : collection) {
            taskResult = new Callable<List<VcPackageInfo>>(){

                @Override
                public List<VcPackageInfo> call() {
                    if (_logger.isDebugEnabled()) {
                        _logger.debug((Object)("Checking for new plugin packages in VC " + vcService.getServiceUrl()));
                    }
                    return VcExtensionManager.this.getVcPackages(vcService);
                }
            };
            vcServiceArray[n++] = vcService;
            arrayList.add(taskResult);
        }
        Object object = null;
        try {
            object = ExecutorUtil.executeTasks(arrayList, (Executor)EXECUTOR, (long)30L, (TimeUnit)TimeUnit.SECONDS, (boolean)true);
        }
        catch (InterruptedException interruptedException) {
            _logger.error((Object)"The thread was interrupted while retrieving extensions", (Throwable)interruptedException);
            Thread.currentThread().interrupt();
            return hashSet;
        }
        catch (TimeoutException timeoutException) {
            _logger.error((Object)"Retrieving all the VC extensions timed out. Proceeding with installing the extensions that were retrieved on time", (Throwable)timeoutException);
        }
        boolean bl2 = false;
        while (var8_13 < vcServiceArray.length) {
            taskResult = (ExecutorUtil.TaskResult)object.get((int)var8_13);
            Exception exception = taskResult.getException();
            if (exception != null) {
                _logger.error((Object)("Retrieving vc packages for VC " + vcServiceArray[var8_13].getServiceUrl() + " failed"), (Throwable)exception);
            } else {
                List list = (List)taskResult.getResult();
                if (list != null) {
                    Set<IdVersionPair> set = this.addPackages(list, vcServiceArray[var8_13], bl);
                    hashSet.addAll(set);
                }
            }
            ++var8_13;
        }
        return hashSet;
    }

    private List<VcPackageInfo> getVcPackages(VcService vcService) {
        List<VcPackageInfo> list = this.getLocalVcPackages(vcService.getServiceGuid());
        if (list != null) {
            return list;
        }
        try {
            ManagedObjectReference managedObjectReference = vcService.getServiceInstanceContent().extensionManager;
            ExtensionManager extensionManager = (ExtensionManager)vcService.getManagedObject(managedObjectReference);
            list = this.getVcPackages(extensionManager);
        }
        catch (Exception exception) {
            list = new ArrayList<VcPackageInfo>();
            _logger.error((Object)"Couldn't retrieve ExtensionManager: ", (Throwable)exception);
        }
        return list;
    }

    private VcPackageInfo getVcPackageInfo(Extension extension) {
        Object object2;
        Extension.ClientInfo[] clientInfoArray = extension.client;
        if (clientInfoArray == null) {
            return null;
        }
        Extension.ClientInfo clientInfo = null;
        for (Object object2 : clientInfoArray) {
            if (!this._extensionType.equals(object2.type)) continue;
            clientInfo = object2;
            break;
        }
        if (clientInfo == null) {
            return null;
        }
        String string2 = extension.getKey();
        string2 = VcExtensionUtil.filterExtensionSpecificContent((String)string2);
        String string3 = clientInfo.getVersion();
        String string4 = clientInfo.getUrl();
        if (StringUtil.isNullOrEmpty((String)string2) || StringUtil.isNullOrEmpty((String)string3) || StringUtil.isNullOrEmpty((String)string4)) {
            _logger.error((Object)("Invalid VC extension data, none of these attributes can be null:\n   Extension.key = " + string2 + "\n   Extension.ClientInfo.version = " + string3 + "\n   Extension.ClientInfo.url = " + string4));
            return null;
        }
        object2 = new VcPackageInfo();
        object2.setId(string2);
        object2.setVersion(string3);
        Description description = clientInfo.getDescription();
        if (description != null) {
            object2.setName(description.getLabel());
            object2.setDescription(description.getSummary());
        }
        object2.setVendor(clientInfo.getCompany());
        object2.url = string4;
        object2.thumbprints = this.getExtensionServerThumbprints(extension);
        return object2;
    }

    private String[] getExtensionServerThumbprints(Extension extension) {
        HashSet<String> hashSet = new HashSet<String>();
        Extension.ServerInfo[] serverInfoArray = extension.server;
        if (serverInfoArray != null) {
            for (Extension.ServerInfo serverInfo : serverInfoArray) {
                String string = serverInfo.getServerThumbprint();
                if (string == null) continue;
                hashSet.add(string);
            }
        }
        return hashSet.toArray(new String[0]);
    }

    private Set<IdVersionPair> addPackages(Collection<VcPackageInfo> collection, VcService vcService, boolean bl) {
        Object object;
        Object object3;
        HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>(collection.size());
        ArrayList<DownloadContext> arrayList = new ArrayList<DownloadContext>();
        final ManagedObjectReference managedObjectReference = vcService.getServiceInstanceContent().eventManager;
        for (final VcPackageInfo vcPackageInfo : collection) {
            object3 = vcPackageInfo.getPackageRef();
            try {
                if (this.isPackageAlreadyDeployed((IdVersionPair)object3)) {
                    if (bl) continue;
                    hashSet.add((IdVersionPair)object3);
                    continue;
                }
                if (!this._allPackageRefs.add((IdVersionPair)object3)) continue;
                final SessionUtil.ThreadContext exception = SessionUtil.getThreadContext((boolean)true);
                Callable<Set<IdVersionPair>> callable = new Callable<Set<IdVersionPair>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Set<IdVersionPair> call() throws Exception {
                        SessionUtil.setThreadContext((SessionUtil.ThreadContext)exception);
                        try {
                            Thread.currentThread().setPriority(1);
                            Thread.currentThread().setContextClassLoader(ExtensionService.class.getClassLoader());
                            File file = VcExtensionManager.this.downloadPackage(vcPackageInfo);
                            if (file == null) {
                                HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>();
                                return hashSet;
                            }
                            vcPackageInfo.setDirectory(file);
                            try {
                                Set set = VcExtensionManager.this._extensionService.addPluginPackages(new PluginPackageInfo[]{vcPackageInfo});
                                return set;
                            }
                            catch (Exception exception2) {
                                _logger.error((Object)("Adding VC extension " + object3 + " failed"), (Throwable)exception2);
                                VcExtensionManager.this.postVcEvent(managedObjectReference, Event.EventSeverity.error, "PluginDeployment.failure", new Object[]{vcPackageInfo.getName(), vcPackageInfo.getVersion(), exception2.getMessage()});
                                HashSet<IdVersionPair> hashSet = new HashSet<IdVersionPair>();
                                SessionUtil.setThreadContext(null);
                                return hashSet;
                            }
                        }
                        finally {
                            SessionUtil.setThreadContext(null);
                        }
                    }
                };
                object = EXECUTOR.submit(callable);
                arrayList.add(new DownloadContext(vcPackageInfo, (Future<Set<IdVersionPair>>)object));
            }
            catch (Exception exception) {
                _logger.error((Object)("Adding VC extension " + object3 + " failed"), (Throwable)exception);
                this.postVcEvent(managedObjectReference, Event.EventSeverity.error, "PluginDeployment.failure", vcPackageInfo.getName(), vcPackageInfo.getVersion(), exception.getMessage());
            }
        }
        long l = this.getPluginDeployTimeout();
        for (DownloadContext downloadContext : arrayList) {
            String string = downloadContext.packageInfo.getName();
            object = downloadContext.packageInfo.getVersion();
            try {
                this.postVcEvent(managedObjectReference, Event.EventSeverity.info, "PluginDeployment.started", string, object);
                Set set = (Set)BlockingUtil.get(downloadContext.future, (long)l, (TimeUnit)TimeUnit.MINUTES);
                this.postVcEvent(managedObjectReference, Event.EventSeverity.info, "PluginDeployment.success", string, object);
                hashSet.addAll(set);
            }
            catch (Exception exception) {
                String string2 = exception instanceof TimeoutException ? String.format("Timeout (%d mns) while downloading or deploying package %s from %s. Check the URL and network if the download could not complete in time, check your initialization code if bundles are too slow to deploy.", l, downloadContext.packageInfo.getId(), downloadContext.packageInfo.url) : String.format("Error while downloading or deploying package %s from %s, check the URL and the root exception.", downloadContext.packageInfo.getId(), downloadContext.packageInfo.url);
                this.postVcEvent(managedObjectReference, Event.EventSeverity.error, "PluginDeployment.failure", string, object, exception.getMessage());
                _logger.error((Object)string2, (Throwable)exception);
            }
        }
        object3 = vcService.getServiceGuid();
        for (IdVersionPair idVersionPair : hashSet) {
            this.updatePackageMetadata(idVersionPair, (String)object3);
        }
        this._packageRefs.addAll(hashSet);
        return hashSet;
    }

    private void postVcEvent(ManagedObjectReference managedObjectReference, Event.EventSeverity eventSeverity, String string, Object ... objectArray) {
        Event event = this.createDynamicEvent(eventSeverity, string, objectArray);
        try {
            EventManager eventManager = (EventManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
            eventManager.postEvent(event, null);
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
    }

    private Event createDynamicEvent(Event.EventSeverity eventSeverity, String string, Object ... objectArray) {
        String string2;
        EventEx eventEx = new EventEx();
        eventEx.chainId = 0;
        eventEx.createdTime = Calendar.getInstance();
        eventEx.key = 0;
        eventEx.userName = VimServicesVsphereUtil.getLocalizedString("System.userName");
        String string3 = VimServicesVsphereUtil.getLocalizedString(string);
        eventEx.eventTypeId = string2 = String.format(string3, objectArray);
        eventEx.fullFormattedMessage = string2;
        eventEx.severity = eventSeverity.name();
        return eventEx;
    }

    private void updatePackageMetadata(IdVersionPair idVersionPair, String string) {
        HashSet<Object> hashSet;
        String[] stringArray;
        PluginPackageInfo pluginPackageInfo;
        try {
            pluginPackageInfo = this._extensionService.getPluginPackageInfo(idVersionPair);
        }
        catch (Exception exception) {
            _logger.error((Object)("ExtensionService.getPluginPackageInfo for " + idVersionPair + " failed"), (Throwable)exception);
            return;
        }
        if (pluginPackageInfo == null) {
            return;
        }
        HashMap<String, String[]> hashMap = pluginPackageInfo.getMetadata();
        if (hashMap == null) {
            hashMap = new HashMap<String, String[]>();
            pluginPackageInfo.setMetadata(hashMap);
        }
        if ((stringArray = (String[])hashMap.get(SERVER_GUIDS)) != null) {
            hashSet = new HashSet<String>(Arrays.asList(stringArray));
            if (hashSet.contains(string)) {
                return;
            }
        } else {
            hashSet = new HashSet<String>();
        }
        hashSet.add(string);
        hashMap.put(SERVER_GUIDS, hashSet.toArray(new String[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File downloadPackage(VcPackageInfo vcPackageInfo) {
        File file = this.getPackageDir(vcPackageInfo.getPackageRef());
        if (file.exists()) {
            return file;
        }
        File file2 = null;
        ZipFile zipFile = null;
        boolean bl = false;
        try {
            file2 = File.createTempFile("vmw-pckg", ".zip");
        }
        catch (IOException iOException) {
            String string = System.getProperty("java.io.tmpdir");
            _logger.error((Object)("Error creating temporay file " + string + "/vmw-pckg.zip, while downloading " + vcPackageInfo.url), (Throwable)iOException);
            return null;
        }
        try {
            _logger.debug((Object)("start writePackageToFile : " + vcPackageInfo.getId()));
            this.writePackageToFile(vcPackageInfo, file2);
            bl = true;
            file.mkdirs();
            zipFile = new ZipFile(file2);
            ZipUtil.unzip((ZipFile)zipFile, (File)file);
        }
        catch (IOException iOException) {
            File file3;
            try {
                String string = "Package " + vcPackageInfo.getId() + " was not installed! ";
                string = !bl ? string + "\nError downloading " + vcPackageInfo.url + ". Make sure that the URL is reachable then logout/login to force another download." : string + "\nError expanding zip file found at " + vcPackageInfo.url + ". Make sure it is a valid zip file then logout/login to force another download.";
                _logger.error((Object)string, (Throwable)iOException);
                FileUtil.deleteDir((File)file);
                file3 = null;
            }
            catch (Throwable throwable) {
                StreamUtil.close(zipFile);
                if (file2 != null) {
                    file2.delete();
                }
                throw throwable;
            }
            StreamUtil.close((ZipFile)zipFile);
            if (file2 != null) {
                file2.delete();
            }
            return file3;
        }
        StreamUtil.close((ZipFile)zipFile);
        if (file2 != null) {
            file2.delete();
        }
        _logger.info((Object)("Done expanding plugin package to " + file.getAbsolutePath()));
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePackageToFile(VcPackageInfo vcPackageInfo, File file) throws IOException {
        InputStream inputStream;
        String[] stringArray = vcPackageInfo.thumbprints;
        URL uRL = new URL(vcPackageInfo.url);
        String string = uRL.getProtocol();
        Proxy proxy = VcExtensionUtil.getHttpProxy((ConfigurationService)this._configurationService);
        String string2 = "Downloading plugin package from " + uRL;
        string2 = proxy == null ? string2 + " (no proxy defined)" : string2 + ", using proxy " + proxy.address().toString();
        _logger.info((Object)string2);
        if ("https".equals(string) && stringArray != null && stringArray.length != 0) {
            SSLBuilder sSLBuilder = new SSLBuilder();
            if (this._sslConfigurationProvider != null) {
                sSLBuilder.sslConfigurationProvider(this._sslConfigurationProvider);
            }
            sSLBuilder.socketReadTimeout(Integer.valueOf(Config.VC_EXTENSION_MANAGER_SOCKET_READ_TIMEOUT.toIntMillis()));
            sSLBuilder.socketConnectionTimeout(Integer.valueOf(Config.VC_EXTENSION_MANAGER_SOCKET_CONNECTION_TIMEOUT.toIntMillis()));
            HttpClient httpClient = sSLBuilder.thumbprints(stringArray).buildHttpClientIgnoreErrors();
            inputStream = httpClient.executeMethodResponseAsStream(vcPackageInfo.url, null, null, proxy);
        } else {
            Boolean bl = VcExtensionUtil.isHttpDownloadAllowed((ConfigurationService)this._configurationService);
            if (!bl.booleanValue()) {
                _logger.error((Object)"The plugin package download was blocked because the URL isnot secure.  To allow http URLs add allowHttp=true to webclient.properties");
                return;
            }
            inputStream = proxy != null ? uRL.openConnection(proxy).getInputStream() : uRL.openStream();
        }
        try {
            FileUtil.writeFile((InputStream)inputStream, (File)file);
        }
        finally {
            StreamUtil.close((Closeable)inputStream);
        }
        _logger.info((Object)("Done downloading plugin package from " + uRL));
    }

    private File getPackageDir(IdVersionPair idVersionPair) {
        String string = idVersionPair.getId() + "-" + idVersionPair.getVersion();
        File file = new File(Environment.clientAppDataFolder());
        File file2 = new File(new File(file, "vc-packages"), this._extensionType);
        File file3 = new File(file2, string);
        return file3;
    }

    protected synchronized void packageUndeployed(IdVersionPair idVersionPair) {
        this._packageRefs.remove(idVersionPair);
        this._allPackageRefs.remove(idVersionPair);
        File file = this.getPackageDir(idVersionPair);
        if (file.exists()) {
            _logger.info((Object)("Delete vc package directory '" + file + "' because the package is undeployed."));
            FileUtil.deleteDir((File)file);
        }
    }

    private List<VcPackageInfo> getLocalVcPackages(String string) {
        String string2 = System.getProperty("localVcPackagesPath");
        if (string2 == null) {
            return null;
        }
        File file = new File(string2, string);
        if (!file.exists()) {
            return null;
        }
        File file2 = null;
        for (File stringArray2 : file.listFiles()) {
            if (!stringArray2.getName().endsWith(".zip")) continue;
            file2 = stringArray2;
            break;
        }
        if (file2 == null) {
            _logger.info((Object)("Package zip file not found in " + file));
            return null;
        }
        ArrayList arrayList = new ArrayList();
        String string3 = file2.getName();
        int n = string3.indexOf(".zip");
        String[] stringArray = (string3 = string3.substring(0, n)).split("-");
        if (stringArray.length != 2) {
            _logger.error((Object)"Invalid package zip file name.");
            return arrayList;
        }
        String string4 = stringArray[0];
        String string5 = stringArray[1];
        VcPackageInfo vcPackageInfo = new VcPackageInfo();
        vcPackageInfo.setId(string4);
        vcPackageInfo.setVersion(string5);
        vcPackageInfo.url = file2.toURI().toString();
        arrayList.add(vcPackageInfo);
        return arrayList;
    }

    private long getPluginDeployTimeout() {
        try {
            long l;
            String string = this._configurationService.getProperty(DEPLOYMENT_TIMEOUT_PROP_NAME);
            if (!StringUtil.isNullOrEmpty((String)string) && (l = Long.parseLong(string)) >= 1L) {
                return l;
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Invalid newPlugins.deployTimeout value in webclient.properties ", (Throwable)exception);
        }
        return 10L;
    }

    private static class DownloadContext {
        public final VcPackageInfo packageInfo;
        public final Future<Set<IdVersionPair>> future;

        public DownloadContext(VcPackageInfo vcPackageInfo, Future<Set<IdVersionPair>> future) {
            this.packageInfo = vcPackageInfo;
            this.future = future;
        }
    }

    public static class VcPackageInfo
    extends PluginPackageInfo {
        public String url;
        public String[] thumbprints;
    }
}

