/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.extension.flex;

import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.vim.extension.flex.ExtensionHandler;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class DefaultExtensionHandler
implements ExtensionHandler {
    private static final Log _logger = LogFactory.getLog(DefaultExtensionHandler.class);
    private static final String ICON_TOKEN_PATTERN_PREFIX = "#\\{";
    private static final String ICON_TOKEN_PATTERN_SUFFIX = "\\}";

    DefaultExtensionHandler() {
    }

    @Override
    public String handle(String string, Element element) {
        if (element == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.transform(element, stringBuffer);
        return stringBuffer.toString();
    }

    protected void transformIconAttrInVarElement(Element element, StringBuffer stringBuffer) {
        String string = element.getAttribute("value");
        string = DefaultExtensionHandler.removeLocalize(string);
        stringBuffer.append("<variable name='icon' value='").append("icon-" + string).append("'/>");
    }

    protected void transformIconElement(Element element, StringBuffer stringBuffer) {
        try {
            String string = element.getChildNodes().item(0).getNodeValue();
            stringBuffer.append("<icon>").append("icon-" + DefaultExtensionHandler.removeLocalize(string)).append("</icon>");
        }
        catch (Exception exception) {
            _logger.error((Object)("Can not get the value of icon element:" + element.getNodeName()), (Throwable)exception);
        }
    }

    private void transform(Element element, StringBuffer stringBuffer) {
        if (element.getNodeName().equals("icon")) {
            this.transformIconElement(element, stringBuffer);
            return;
        }
        DefaultExtensionHandler.appendElementOnly(element, null, stringBuffer);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                this.transform((Element)node, stringBuffer);
                continue;
            }
            DefaultExtensionHandler.appendElement(node, stringBuffer);
        }
        DefaultExtensionHandler.appendCloseElement(element, stringBuffer);
    }

    private static String removeLocalize(String string) {
        if (string == null) {
            return "";
        }
        string = string.replaceAll(ICON_TOKEN_PATTERN_PREFIX, "");
        string = string.replaceAll(ICON_TOKEN_PATTERN_SUFFIX, "");
        return string;
    }

    static void appendElement(Node node, StringBuffer stringBuffer) {
        try {
            stringBuffer.append(XMLUtil.xmlToString((Node)node, (boolean)true));
        }
        catch (IOException iOException) {
            _logger.error((Object)"Error in XMLUtil.xmlToString", (Throwable)iOException);
        }
    }

    static void appendElementOnly(Node node, Map<String, String> map, StringBuffer stringBuffer) {
        stringBuffer.append("<").append(node.getNodeName());
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node object = namedNodeMap.item(i);
            stringBuffer.append(" ");
            stringBuffer.append(object.getNodeName()).append("='");
            stringBuffer.append(object.getNodeValue()).append("'");
        }
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                stringBuffer.append(" ");
                stringBuffer.append(entry.getKey()).append("='");
                stringBuffer.append(entry.getValue()).append("'");
            }
        }
        stringBuffer.append(">");
    }

    static void appendCloseElement(Node node, StringBuffer stringBuffer) {
        stringBuffer.append("</").append(node.getNodeName()).append(">");
    }

    static void appendElement(String string, String string2, StringBuffer stringBuffer) {
        stringBuffer.append("<").append(string).append(">");
        stringBuffer.append(string2);
        stringBuffer.append("</").append(string).append(">");
    }
}

