/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.extension.flex;

import com.vmware.vise.extensionfw.ExtensionService;
import com.vmware.vise.util.FileUtil;
import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.io.StreamUtil;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.vim.commons.vcservice.VcServiceCompatibilityChecker;
import com.vmware.vise.vim.commons.vcservice.VcSource;
import com.vmware.vise.vim.extension.VcExtensionManager;
import com.vmware.vise.vim.extension.flex.AppWarFileGenerator;
import com.vmware.vise.vim.extension.flex.H5VcFlexPluginTransformer;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class H5VcFlexPluginManager
extends VcExtensionManager {
    private static final Log _logger = LogFactory.getLog(H5VcFlexPluginManager.class);
    private static final String PLUGIN = "plugin.xml";
    private static final String SESSION_PACKAGES_REFS = "vcFlexPluginPackagesRefs";
    private static final String FLEX_PLUGINS_DISABLED = "flexPlugin.disabled";

    public H5VcFlexPluginManager(ExtensionService extensionService, ConfigurationService configurationService, String string, VcSource vcSource) {
        super(extensionService, string, configurationService, vcSource);
    }

    public H5VcFlexPluginManager(ExtensionService extensionService, @Nonnull ConfigurationService configurationService, @Nonnull String string, @Nonnull VcSource vcSource, @Nonnull SSLConfigurationProvider sSLConfigurationProvider, @Nullable VcServiceCompatibilityChecker vcServiceCompatibilityChecker) {
        super(extensionService, string, configurationService, vcSource, sSLConfigurationProvider, vcServiceCompatibilityChecker);
    }

    @Override
    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
        String string;
        if (this._configurationService != null && (string = this._configurationService.getProperty(FLEX_PLUGINS_DISABLED)) != null && string.trim().equalsIgnoreCase("true")) {
            return;
        }
        super.sessionStarted(httpSessionEvent, locale);
    }

    @Override
    protected File downloadPackage(VcExtensionManager.VcPackageInfo vcPackageInfo) {
        File file = super.downloadPackage(vcPackageInfo);
        try {
            if (file != null) {
                this.processPlugins(file, file);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Error in processing plugins.");
        }
        return file;
    }

    protected void processPlugins(File file, File file2) throws Exception {
        for (File file3 : file2.listFiles()) {
            String string = file3.getName();
            if (file3.isDirectory()) {
                this.processPlugins(file, file3);
                continue;
            }
            if (!string.endsWith(".war")) continue;
            this.processWarFile(file3);
        }
    }

    protected void transform(Document document, JarFile jarFile, File file) {
        try {
            H5VcFlexPluginTransformer h5VcFlexPluginTransformer = new H5VcFlexPluginTransformer(jarFile);
            h5VcFlexPluginTransformer.processXml(document, file);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error in the flex plugin transformation: " + file.toString()), (Throwable)exception);
        }
    }

    @Override
    protected String getSessionKey() {
        return SESSION_PACKAGES_REFS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWarFile(File file) throws Exception {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException iOException) {
            _logger.error((Object)("Error in opening the jar file: " + file.getPath()), (Throwable)iOException);
            throw iOException;
        }
        Manifest manifest = null;
        try {
            manifest = jarFile.getManifest();
        }
        catch (IOException iOException) {
            _logger.error((Object)("Can not get the manifest of the jar file: " + file.getPath()), (Throwable)iOException);
            throw iOException;
        }
        finally {
            StreamUtil.close((ZipFile)jarFile);
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            _logger.error((Object)("Can not find the jar file: " + file.getPath()), (Throwable)fileNotFoundException);
            throw fileNotFoundException;
        }
        ZipInputStream zipInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            File file2 = null;
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            zipInputStream = new ZipInputStream(bufferedInputStream);
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.getName().equals(PLUGIN)) continue;
                file2 = this.transformPlugin(jarFile.getInputStream(zipEntry), jarFile, file);
                break;
            }
            this.generateUIWarFile(file2, manifest, file);
        }
        catch (Throwable throwable) {
            StreamUtil.close(zipInputStream);
            StreamUtil.close(bufferedInputStream);
            StreamUtil.close((Closeable)fileInputStream);
            throw throwable;
        }
        StreamUtil.close((Closeable)zipInputStream);
        StreamUtil.close((Closeable)bufferedInputStream);
        StreamUtil.close((Closeable)fileInputStream);
    }

    private File transformPlugin(InputStream inputStream, JarFile jarFile, File file) throws Exception {
        Document document = null;
        try {
            document = XMLUtil.loadXmlFile((InputStream)inputStream);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error in loading plugin.xml from jar: " + file.getPath()));
            throw exception;
        }
        File file2 = null;
        if (document != null) {
            String string = file.getName();
            String string2 = string.substring(0, string.length() - 4);
            file2 = new File(file.getParentFile(), string2);
            if (file2.exists()) {
                file2.delete();
            }
            file2.mkdir();
            File file3 = new File(file2, PLUGIN);
            file3.createNewFile();
            this.transform(document, jarFile, file3);
        }
        return file2;
    }

    private void generateUIWarFile(File file, Manifest manifest, File file2) {
        if (file != null) {
            file2.delete();
            String string = file2.getName();
            File file3 = new File(file.getParentFile(), string);
            new AppWarFileGenerator(manifest, file, file3).generate();
            FileUtil.deleteDir((File)file);
        }
    }
}

