/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.extension.flex;

import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.vim.extension.flex.DefaultExtensionHandler;
import com.vmware.vise.vim.extension.flex.ExtensionHandlerFactory;
import com.vmware.vise.vim.extension.flex.ResourcesTransformer;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class H5VcFlexPluginTransformer {
    private static final Log _logger = LogFactory.getLog(H5VcFlexPluginTransformer.class);
    private static final ExtensionHandlerFactory factory = ExtensionHandlerFactory.getInstance();
    private final ResourcesTransformer _resourcesTransformer;
    private static final String pluginType = "flex";

    public H5VcFlexPluginTransformer() {
        this(null);
    }

    public H5VcFlexPluginTransformer(JarFile jarFile) {
        this._resourcesTransformer = new ResourcesTransformer(jarFile);
    }

    public void processXml(Document document, File file) throws Exception {
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.append("<?xml version='1.0' encoding='UTF-8'?>");
        document.getDocumentElement().normalize();
        NodeList nodeList = document.getElementsByTagName("plugin");
        Element element = (Element)nodeList.item(0);
        this.processPluginElement(element, fileWriter);
        NodeList nodeList2 = element.getChildNodes();
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Object object;
            Node node = nodeList2.item(i);
            String string = node.getNodeName();
            if (string.equals("extension")) {
                object = ((Element)node).getElementsByTagName("extendedPoint");
                for (int j = 0; j < object.getLength(); ++j) {
                    Element element2 = (Element)object.item(j);
                    String string2 = element2.getChildNodes().item(0).getNodeValue();
                    String string3 = factory.getExtensionHandler(string2).handle(string2, (Element)node);
                    fileWriter.append(string3);
                }
                continue;
            }
            if (string.equals("resources")) {
                object = element.getAttribute("id");
                String string4 = this._resourcesTransformer.processResources(file, (String)object);
                fileWriter.append(string4);
                continue;
            }
            if (string.equals("templateInstance")) {
                object = factory.getTemplateInstanceHandler().handle("", (Element)node);
                fileWriter.append((CharSequence)object);
                continue;
            }
            fileWriter.append(XMLUtil.xmlToString((Node)node, (boolean)true));
        }
        fileWriter.append("</plugin>");
        fileWriter.close();
        try {
            XMLUtil.prettyFormatXml((File)file);
        }
        catch (Exception exception) {
            _logger.warn((Object)("Error in pretty formatting " + file.getPath()));
        }
    }

    private void processPluginElement(Element element, FileWriter fileWriter) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("type", pluginType);
        StringBuffer stringBuffer = new StringBuffer();
        DefaultExtensionHandler.appendElementOnly(element, hashMap, stringBuffer);
        fileWriter.append(stringBuffer.toString());
    }
}

