/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.extension.flex;

import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.vim.extension.ScriptPluginUtil;
import com.vmware.vise.vim.extension.flex.DefaultExtensionHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObjectNavigatorExtensionHandler
extends DefaultExtensionHandler {
    private static final Log _logger = LogFactory.getLog(ObjectNavigatorExtensionHandler.class);
    private static final ObjectNavigatorExtensionHandler _instance = new ObjectNavigatorExtensionHandler();
    private static Map<String, String> classNameToUrl = new HashMap<String, String>();

    private ObjectNavigatorExtensionHandler() {
    }

    public static ObjectNavigatorExtensionHandler getInstance() {
        return _instance;
    }

    @Override
    public String handle(String string, Element element) {
        String string2 = element.getAttributeNode("id").getNodeValue();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<extension id='").append(string2).append("'>");
        stringBuffer.append("<extendedPoint>").append(string).append("</extendedPoint>");
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string3 = node.getNodeName();
            if (string3.equals("object")) {
                this.handleObjectElement(node, stringBuffer);
                continue;
            }
            if (string3.equals("extendedPoint")) continue;
            try {
                stringBuffer.append(XMLUtil.xmlToString((Node)node, (boolean)true));
                continue;
            }
            catch (IOException iOException) {
                _logger.error((Object)"Error in XMLUtil.xmlToString", (Throwable)iOException);
            }
        }
        stringBuffer.append("</extension>");
        return stringBuffer.toString();
    }

    private void handleObjectElement(Node node, StringBuffer stringBuffer) {
        stringBuffer.append("<object>");
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("countClass")) {
                String string2 = ScriptPluginUtil.getNodeValue((Element)node2, "countFor");
                if (string2 == null) continue;
                stringBuffer.append("<nodeObjectType>").append(string2).append("</nodeObjectType>");
                continue;
            }
            if (string.equals("viewOpenedUponFocus")) {
                this.handleViewOpenedUponFocusElement((Element)node2, stringBuffer);
                continue;
            }
            if (string.equals("icon")) {
                this.transformIconElement((Element)node2, stringBuffer);
                continue;
            }
            DefaultExtensionHandler.appendElement(node2, stringBuffer);
        }
        stringBuffer.append("</object>");
    }

    private void handleViewOpenedUponFocusElement(Element element, StringBuffer stringBuffer) {
        Object object;
        stringBuffer.append("<viewOpenedUponFocus>");
        String string = element.getAttribute("className");
        if (string != null) {
            object = classNameToUrl.get(string.trim());
            if (object == null) {
                _logger.error((Object)("Can not find mapping for " + string));
            } else {
                stringBuffer.append("<url>").append((String)object).append("</url>");
            }
        }
        object = element.getChildNodes();
        for (int i = 0; i < object.getLength(); ++i) {
            Object object2;
            Node node = object.item(i);
            String string2 = node.getNodeName();
            if (string2.equals("className") && string == null) {
                string = node.getNodeValue();
                object2 = classNameToUrl.get(string == null ? "" : string.trim());
                if (object2 == null) {
                    _logger.error((Object)("Can not find mapping for " + string));
                    continue;
                }
                stringBuffer.append("<url>").append((String)object2).append("</url>");
                continue;
            }
            if (string2.equals("object")) {
                object2 = ((Element)node).getElementsByTagName("root");
                if (object2 == null) continue;
                stringBuffer.append("<metadata>");
                Node node2 = object2.item(0);
                NodeList nodeList = node2.getChildNodes();
                for (int j = 0; j < nodeList.getLength(); ++j) {
                    Node node3 = nodeList.item(j);
                    if (node3.getNodeName().equals("numLevels") || node3.getNodeType() != 1) continue;
                    this.handleMetadataEntry(node3, stringBuffer);
                }
                stringBuffer.append("</metadata>");
                continue;
            }
            DefaultExtensionHandler.appendElement(node, stringBuffer);
        }
        stringBuffer.append("</viewOpenedUponFocus>");
    }

    private void handleMetadataEntry(Node node, StringBuffer stringBuffer) {
        try {
            stringBuffer.append("<entry>");
            stringBuffer.append("<key>").append(node.getNodeName()).append("</key>");
            stringBuffer.append("<value>").append(node.getChildNodes().item(0).getNodeValue()).append("</value>");
            stringBuffer.append("</entry>");
        }
        catch (Exception exception) {
            _logger.error((Object)("Error in handling entry: " + node.getNodeName()));
        }
    }

    static {
        classNameToUrl.put("com.vmware.vsphere.client.views.inventory.viInventoryTreeView", "resources/ui/views/viInventoryTreeView.html");
        classNameToUrl.put("com.vmware.ui.objectnavigator.views.CategoryNodeTreeView", "resources/ui/views/objectnavigator/CategoryNodeTreeView.html");
        classNameToUrl.put("com.vmware.ui.objectnavigator.views.CategoryNodeListView", "resources/ui/views/objectnavigator/CategoryNodeListView.html");
        classNameToUrl.put("com.vmware.vsphere.client.views.search.objectnavigator.SavedSearchesNodeView", "resources/ui/views/SavedSearchesNodeView.html");
        classNameToUrl.put("com.vmware.vsphere.client.views.search.objectnavigator.SearchItemsNodeView", "resources/ui/views/SearchItemsNodeView.html");
    }
}

