/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.http;

import com.vmware.vim.binding.vim.ServiceDirectory;
import com.vmware.vise.util.net.ssl.SSLConfigurationProvider;
import com.vmware.vise.util.security.SimpleSSLSocketFactory;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.ssl.KeystoreService;
import com.vmware.vise.vim.commons.ssl.SSLBuilder;
import com.vmware.vise.vim.http.HttpInvokerServiceLocator;
import com.vmware.vise.vim.http.HttpServiceAddressLookupException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.remoting.httpinvoker.CommonsHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;
import org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;

public class HttpInvokerServiceFactory
implements BeanClassLoaderAware {
    private static final Log _logger = LogFactory.getLog(HttpInvokerServiceFactory.class);
    private static final int SOCKET_TIMEOUT_MILLIS = 30000;
    private final Map<String, Object> _serviceMap = new HashMap<String, Object>();
    private final HttpInvokerServiceLocator _serviceLocator = new HttpInvokerServiceLocator();
    private ClassLoader _classLoader;
    private Class<?> _serviceInterface;
    private String _serviceDirectory = null;
    private final KeystoreService _ksService;
    private final SSLConfigurationProvider _sslConfigurationProvider;

    public HttpInvokerServiceFactory(KeystoreService keystoreService, SSLConfigurationProvider sSLConfigurationProvider) {
        this._ksService = keystoreService;
        this._sslConfigurationProvider = sSLConfigurationProvider;
    }

    @Deprecated
    public HttpInvokerServiceFactory(KeystoreService keystoreService) {
        this._ksService = keystoreService;
        this._sslConfigurationProvider = null;
    }

    @Deprecated
    public HttpInvokerServiceFactory() {
        this._ksService = null;
        this._sslConfigurationProvider = null;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    public Class<?> getServiceInterface() {
        return this._serviceInterface;
    }

    public void setServiceInterface(Class<?> clazz) {
        this._serviceInterface = clazz;
    }

    public String getServiceDirectory() {
        return this._serviceDirectory;
    }

    public void setServiceDirectory(String string) {
        this._serviceDirectory = string;
    }

    public synchronized Object getServiceInstance(String string) throws HttpServiceAddressLookupException {
        if (this._serviceInterface == null) {
            throw new RuntimeException("Invalid service interface!");
        }
        if (this._serviceDirectory == null) {
            throw new RuntimeException("The service directory is not set!");
        }
        if (string == null) {
            throw new IllegalArgumentException("Invalid service GUID!");
        }
        if (this._serviceMap.containsKey(string)) {
            return this._serviceMap.get(string);
        }
        URL uRL = this._serviceLocator.getServiceUrl(string, this._serviceDirectory);
        if (uRL == null) {
            throw new HttpServiceAddressLookupException("The address of the HTTP service could not be found!");
        }
        ServiceDirectory.ServiceEndpoint serviceEndpoint = VcServiceUtil.getServiceEndpoint((String)string);
        HttpInvokerProxyFactoryBean httpInvokerProxyFactoryBean = this.getProxyFactory(this._serviceInterface, uRL, serviceEndpoint);
        Object object = httpInvokerProxyFactoryBean.getObject();
        this._serviceMap.put(string, object);
        return object;
    }

    private HttpInvokerProxyFactoryBean getProxyFactory(Class<?> clazz, URL uRL, ServiceDirectory.ServiceEndpoint serviceEndpoint) {
        CommonsHttpInvokerRequestExecutor commonsHttpInvokerRequestExecutor = this.getRequestExecutor(uRL, serviceEndpoint);
        HttpInvokerProxyFactoryBean httpInvokerProxyFactoryBean = new HttpInvokerProxyFactoryBean();
        httpInvokerProxyFactoryBean.setHttpInvokerRequestExecutor((HttpInvokerRequestExecutor)commonsHttpInvokerRequestExecutor);
        httpInvokerProxyFactoryBean.setServiceInterface(clazz);
        httpInvokerProxyFactoryBean.setServiceUrl(uRL.getFile());
        httpInvokerProxyFactoryBean.afterPropertiesSet();
        return httpInvokerProxyFactoryBean;
    }

    private CommonsHttpInvokerRequestExecutor getRequestExecutor(URL uRL, ServiceDirectory.ServiceEndpoint serviceEndpoint) {
        CommonsHttpInvokerRequestExecutor commonsHttpInvokerRequestExecutor = new CommonsHttpInvokerRequestExecutor();
        commonsHttpInvokerRequestExecutor.setBeanClassLoader(this._classLoader);
        String string = uRL.getHost();
        int n = uRL.getPort();
        Protocol protocol = this.getProtocol(uRL, this.getSocketFactory(serviceEndpoint));
        HttpClient httpClient = commonsHttpInvokerRequestExecutor.getHttpClient();
        httpClient.getHostConfiguration().setHost(string, n, protocol);
        commonsHttpInvokerRequestExecutor.setReadTimeout(30000);
        return commonsHttpInvokerRequestExecutor;
    }

    private ProtocolSocketFactory getSocketFactory(ServiceDirectory.ServiceEndpoint serviceEndpoint) {
        SSLContext sSLContext = this.getSecurityContext(serviceEndpoint);
        return new SimpleSSLSocketFactory(sSLContext);
    }

    private Protocol getProtocol(URL uRL, ProtocolSocketFactory protocolSocketFactory) {
        return new Protocol(uRL.getProtocol(), protocolSocketFactory, uRL.getPort());
    }

    private SSLContext getSecurityContext(ServiceDirectory.ServiceEndpoint serviceEndpoint) {
        try {
            SSLBuilder sSLBuilder = new SSLBuilder();
            if (this._sslConfigurationProvider != null) {
                sSLBuilder.sslConfigurationProvider(this._sslConfigurationProvider);
            }
            if (this._ksService != null && VcServiceUtil.is60VcOrLater((String)serviceEndpoint.instanceUuid)) {
                sSLBuilder.addTrustStore(this._ksService.getKeyStore());
            } else {
                sSLBuilder.thumbprint(serviceEndpoint.getSslThumbprint());
            }
            SSLContext sSLContext = sSLBuilder.buildSSLContext();
            return sSLContext;
        }
        catch (Exception exception) {
            _logger.error((Object)"Failure in initializing SecurityContext.", (Throwable)exception);
            throw new IllegalStateException(exception.getMessage());
        }
    }
}

