/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.http;

import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.ServiceEndpointEx;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpInvokerServiceLocator {
    private static final String VIM_WEB_SERVICES = "vimWebServices";
    private static final String WEB_SERVICES_DIR = "/vws";
    private static final Log _logger = LogFactory.getLog(HttpInvokerServiceLocator.class);
    private Map<String, URL> _urlMap = new HashMap<String, URL>();

    public synchronized URL getServiceUrl(String string, String string2) {
        URL uRL = null;
        if (this._urlMap.containsKey(string)) {
            uRL = this._urlMap.get(string);
        } else {
            uRL = this.locateServiceUrl(string, string2);
            if (uRL != null) {
                this._urlMap.put(string, uRL);
            }
        }
        return uRL;
    }

    private URL locateServiceUrl(String string, String string2) {
        ServiceEndpointEx[] serviceEndpointExArray;
        URL uRL = null;
        VcService vcService = VimSessionUtil.getService((String)string);
        for (ServiceEndpointEx serviceEndpointEx : serviceEndpointExArray = vcService.getServiceEndPoints()) {
            String string3;
            if (!serviceEndpointEx.getInstanceUuid().equals(string) || !(string3 = serviceEndpointEx.getProtocol()).equals(VIM_WEB_SERVICES)) continue;
            try {
                URL uRL2 = new URL(serviceEndpointEx.getUrl());
                String string4 = uRL2.getFile();
                if (!string4.equals(WEB_SERVICES_DIR)) continue;
                String string5 = string4.concat(string2);
                uRL = new URL(uRL2.getProtocol(), uRL2.getHost(), uRL2.getPort(), string5);
                break;
            }
            catch (MalformedURLException malformedURLException) {
                _logger.error((Object)"URL parsing failed!", (Throwable)malformedURLException);
            }
        }
        return uRL;
    }
}

