/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.impl;

import com.vmware.vim.binding.vim.AuthorizationManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vim.binding.vmodl.fault.ManagedObjectNotFound;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.vim.data.QueryDataUtil;
import com.vmware.vise.vim.i18n.VimServicesVsphereUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vise.vim.security.accesscontrol.impl.AuthorizationServicePropertyAdapter;
import com.vmware.vise.vim.security.util.VCAuthorizationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class LegacyAuthorizationServiceImpl
implements LegacyAuthorizationService {
    private final DataService _dataService;
    private final ObjectReferenceService _objRefService;
    private final AuthorizationServicePropertyAdapter _authzPropAdapter;
    private static final String EFFECTIVE_ROLE = "effectiveRole";
    private static final Log _logger = LogFactory.getLog(LegacyAuthorizationServiceImpl.class);

    public LegacyAuthorizationServiceImpl(DataService dataService, ObjectReferenceService objectReferenceService, AuthorizationServicePropertyAdapter authorizationServicePropertyAdapter) {
        this._dataService = dataService;
        this._authzPropAdapter = authorizationServicePropertyAdapter;
        this._objRefService = objectReferenceService;
    }

    @Deprecated
    public boolean checkPrivileges(ManagedObjectReference[] managedObjectReferenceArray, String[] stringArray) throws Exception {
        if (managedObjectReferenceArray == null || stringArray == null) {
            return true;
        }
        ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
        ArrayList<ManagedObjectReference> arrayList2 = new ArrayList<ManagedObjectReference>();
        Object[] objectArray = managedObjectReferenceArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            ManagedObjectReference managedObjectReference = objectArray[i];
            if (VCAuthorizationUtil.useLegacyPermissionsCheck(managedObjectReference)) {
                arrayList.add(managedObjectReference);
                continue;
            }
            arrayList2.add(managedObjectReference);
        }
        if (arrayList.size() > 0) {
            for (ManagedObjectReference managedObjectReference : objectArray = this.getPrivileges(arrayList.toArray(new ManagedObjectReference[arrayList.size()]))) {
                String[] stringArray2 = (String[])managedObjectReference.value;
                boolean bl = AuthorizationUtil.isPrivilegeGranted((String[])stringArray, (String[])stringArray2);
                if (bl) continue;
                return false;
            }
        }
        if (arrayList2.size() > 0) {
            for (ManagedObjectReference managedObjectReference : objectArray = this._authzPropAdapter.getHasPrivileges(arrayList2.toArray(), stringArray)) {
                if (managedObjectReference.booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    @Deprecated
    public PropertyValue[] getPrivileges(ManagedObjectReference[] managedObjectReferenceArray) throws Exception {
        Map<String, PropertyValue> map = this.getPrivilegesInternal(managedObjectReferenceArray);
        return map.values().toArray(new PropertyValue[0]);
    }

    private Map<String, PropertyValue> getPrivilegesInternal(Object[] objectArray) throws Exception {
        HashMap<String, PropertyValue> hashMap = new HashMap<String, PropertyValue>();
        if (objectArray == null) {
            return hashMap;
        }
        Map map = null;
        try {
            map = QueryDataUtil.getProperties((DataService)this._dataService, (Object[])objectArray, (String[])new String[]{EFFECTIVE_ROLE});
        }
        catch (ManagedObjectNotFound managedObjectNotFound) {
            _logger.error((Object)String.format("Error while fetching effective role for %s : %s", Arrays.toString(objectArray), managedObjectNotFound.getMessage()));
            throw managedObjectNotFound;
        }
        catch (Exception exception) {
            _logger.error((Object)String.format("Error while fetching effective role for %s : %s", Arrays.toString(objectArray), exception.getMessage()));
            this.throwRuntimeFault(VimServicesVsphereUtil.getLocalizedString("AuthService.computePermissionFailure"), exception);
        }
        for (Object object : objectArray) {
            Object object2;
            String string = this._objRefService.getUid(object);
            if (!VCAuthorizationUtil.useLegacyPermissionsCheck(object)) {
                object2 = this._authzPropAdapter.getGrantedPrivileges(object);
                hashMap.put(string, this.newPropertyValue(object, "grantedPrivileges", object2));
                continue;
            }
            if (map == null || map.get(string) == null) {
                _logger.info((Object)("Effective role missing for: " + string));
                hashMap.put(string, this.newPropertyValue(object, "grantedPrivileges", new String[0]));
                continue;
            }
            object2 = (List)map.get(string);
            ResultItem resultItem = (ResultItem)object2.get(0);
            if (resultItem.properties.length == 0) {
                _logger.info((Object)("Effective role value missing for: " + string));
                hashMap.put(string, this.newPropertyValue(object, "grantedPrivileges", new String[0]));
                continue;
            }
            int[] nArray = (int[])resultItem.properties[0].value;
            String[] stringArray = this.getGrantedPrivileges(nArray, object);
            hashMap.put(string, this.newPropertyValue(object, "grantedPrivileges", stringArray));
        }
        return hashMap;
    }

    private PropertyValue newPropertyValue(Object object, String string, Object object2) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.resourceObject = object;
        propertyValue.propertyName = string;
        propertyValue.value = object2;
        return propertyValue;
    }

    private String[] getGrantedPrivileges(int[] nArray, Object object) throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        String string = this._objRefService.getServerGuid(object);
        for (int n : nArray) {
            AuthorizationManager.Role role = VCAuthorizationUtil.getRole(n, string);
            if (role == null) continue;
            for (String string2 : role.privilege) {
                hashSet.add(string2);
            }
        }
        return hashSet.toArray(new String[0]);
    }

    private void throwRuntimeFault(String string, Exception exception) throws RuntimeFault {
        RuntimeFault runtimeFault = new RuntimeFault(string);
        runtimeFault.initCause((Throwable)exception);
        throw runtimeFault;
    }
}

