/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.vim.security.impl;

import com.vmware.cis.authorization.client.exception.AuthorizationClientException;
import com.vmware.cis.authz.PermissionTypes;
import com.vmware.vapi.std.errors.InvalidArgument;
import com.vmware.vapi.std.errors.NotFound;
import com.vmware.vapi.std.errors.Unauthorized;
import com.vmware.vim.binding.vim.AuthorizationManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.i18n.VimServicesVsphereUtil;
import com.vmware.vise.vim.security.AuthorizationObjectUtil;
import com.vmware.vise.vim.security.accesscontrol.AuthorizationService;
import com.vmware.vise.vim.security.accesscontrol.AuthorizationServiceManager;
import com.vmware.vise.vim.security.data.PermissionData;
import com.vmware.vise.vim.security.data.RemovePermissionSpec;
import com.vmware.vise.vim.security.data.UpdatePermissionsSpec;
import com.vmware.vise.vim.security.util.VCAuthorizationUtil;
import java.net.URI;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PermissionMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(PermissionMutationProvider.class);
    private final AuthorizationServiceManager _authzMgr;

    public PermissionMutationProvider(AuthorizationServiceManager authorizationServiceManager) {
        this._authzMgr = authorizationServiceManager;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Folder,Datacenter,ComputeResource,HostSystem,VirtualMachine,VirtualApp,ClusterComputeResource,ResourcePool,Network,DistributedVirtualPortgroup,Datastore,StoragePod")
    public OperationResult apply(ManagedObjectReference managedObjectReference, RemovePermissionSpec removePermissionSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        if (VCAuthorizationUtil.useLegacyPermissionsCheck(managedObjectReference)) {
            try {
                AuthorizationManager authorizationManager = VCAuthorizationUtil.getAuthorizationManager(managedObjectReference.getServerGuid());
                authorizationManager.removeEntityPermission(managedObjectReference, removePermissionSpec.permission.principal, removePermissionSpec.permission.group);
            }
            catch (Exception exception) {
                operationResult.error = exception;
            }
        } else {
            operationResult = this.apply((Object)managedObjectReference, removePermissionSpec);
        }
        return operationResult;
    }

    public OperationResult apply(Object object, RemovePermissionSpec removePermissionSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = object;
        try {
            AuthorizationService authorizationService = this._authzMgr.getService(object);
            authorizationService.getPermissionManger().delete(removePermissionSpec.permission.id);
        }
        catch (NotFound notFound) {
            _logger.error((Object)("Failed to remove permissions for " + removePermissionSpec.permission.principal + " on " + removePermissionSpec.permission.entity), (Throwable)notFound);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.NotFound.permission", (Exception)((Object)notFound));
        }
        catch (Unauthorized unauthorized) {
            _logger.error((Object)("Failed to remove permissions for " + removePermissionSpec.permission.principal + " on " + removePermissionSpec.permission.entity), (Throwable)unauthorized);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.Unauthorized", (Exception)((Object)unauthorized));
        }
        return operationResult;
    }

    @type(value="VmwareDistributedVirtualSwitch,DistributedVirtualSwitch,Folder,Datacenter,ComputeResource,HostSystem,VirtualMachine,VirtualApp,ClusterComputeResource,ResourcePool,Network,DistributedVirtualPortgroup,Datastore,StoragePod")
    public OperationResult apply(ManagedObjectReference managedObjectReference, UpdatePermissionsSpec updatePermissionsSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        if (VCAuthorizationUtil.useLegacyPermissionsCheck(managedObjectReference)) {
            try {
                AuthorizationManager authorizationManager = VCAuthorizationUtil.getAuthorizationManager(managedObjectReference.getServerGuid());
                AuthorizationManager.Permission[] permissionArray = VCAuthorizationUtil.toPermissions(updatePermissionsSpec.permissions);
                authorizationManager.setEntityPermissions(managedObjectReference, permissionArray);
            }
            catch (Exception exception) {
                operationResult.error = exception;
            }
        } else {
            operationResult = this.apply((Object)managedObjectReference, updatePermissionsSpec);
        }
        return operationResult;
    }

    public OperationResult apply(Object object, UpdatePermissionsSpec updatePermissionsSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = object;
        try {
            AuthorizationService authorizationService = this._authzMgr.getService(object);
            for (PermissionData permissionData : updatePermissionsSpec.permissions) {
                PermissionTypes.CreateSpec createSpec;
                if (permissionData.id == null) {
                    createSpec = new PermissionTypes.CreateSpec();
                    createSpec.setResourceId(authorizationService.getReferenceId(object));
                    createSpec.setPrincipal(VCAuthorizationUtil.getPrincipal(permissionData));
                    createSpec.setRoleId(Arrays.asList(permissionData.roleId));
                    createSpec.setPropagate(permissionData.propagate);
                    authorizationService.getPermissionManger().create(createSpec);
                    continue;
                }
                createSpec = new PermissionTypes.UpdateSpec();
                createSpec.setPropagate(Boolean.valueOf(permissionData.propagate));
                createSpec.setRoleId(Arrays.asList(permissionData.roleId));
                authorizationService.getPermissionManger().update(permissionData.id, (PermissionTypes.UpdateSpec)createSpec);
            }
        }
        catch (NotFound notFound) {
            _logger.error((Object)"Failed to create or modify permissions", (Throwable)notFound);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.NotFound.permission", (Exception)((Object)notFound));
        }
        catch (Unauthorized unauthorized) {
            _logger.error((Object)"Failed to create or modify permissions", (Throwable)unauthorized);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.Unauthorized", (Exception)((Object)unauthorized));
        }
        catch (InvalidArgument invalidArgument) {
            _logger.error((Object)"Failed to create or modify permissions", (Throwable)invalidArgument);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.InvalidArgument", (Exception)((Object)invalidArgument));
        }
        return operationResult;
    }

    @type(value="acl:RootPermissionNode")
    public OperationResult apply(URI uRI, RemovePermissionSpec removePermissionSpec) throws AuthorizationClientException {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = uRI;
        AuthorizationService authorizationService = this._authzMgr.getService(uRI);
        try {
            authorizationService.getPermissionManger().delete(removePermissionSpec.permission.id);
        }
        catch (NotFound notFound) {
            _logger.error((Object)("Failed to remove permissions for " + removePermissionSpec.permission.principal + " on " + removePermissionSpec.permission.entity), (Throwable)notFound);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.NotFound.permission", (Exception)((Object)notFound));
        }
        catch (Unauthorized unauthorized) {
            _logger.error((Object)("Failed to remove permissions for " + removePermissionSpec.permission.principal + " on " + removePermissionSpec.permission.entity), (Throwable)unauthorized);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.Unauthorized", (Exception)((Object)unauthorized));
        }
        return operationResult;
    }

    @type(value="acl:RootPermissionNode")
    public OperationResult apply(URI uRI, UpdatePermissionsSpec updatePermissionsSpec) throws AuthorizationClientException {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = uRI;
        AuthorizationService authorizationService = this._authzMgr.getService(uRI);
        try {
            for (PermissionData permissionData : updatePermissionsSpec.permissions) {
                PermissionTypes.CreateSpec createSpec;
                if (permissionData.id == null) {
                    createSpec = new PermissionTypes.CreateSpec();
                    createSpec.setResourceId(AuthorizationObjectUtil.AUTH_SERVICE_ROOT);
                    createSpec.setPrincipal(VCAuthorizationUtil.getPrincipal(permissionData));
                    createSpec.setRoleId(Arrays.asList(permissionData.roleId));
                    createSpec.setPropagate(permissionData.propagate);
                    authorizationService.getPermissionManger().create(createSpec);
                    continue;
                }
                createSpec = new PermissionTypes.UpdateSpec();
                createSpec.setPropagate(Boolean.valueOf(permissionData.propagate));
                createSpec.setRoleId(Arrays.asList(permissionData.roleId));
                authorizationService.getPermissionManger().update(permissionData.id, (PermissionTypes.UpdateSpec)createSpec);
            }
        }
        catch (NotFound notFound) {
            _logger.error((Object)"Failed to create or modify permissions", (Throwable)notFound);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.NotFound.permission", (Exception)((Object)notFound));
        }
        catch (Unauthorized unauthorized) {
            _logger.error((Object)"Failed to create or modify permissions", (Throwable)unauthorized);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.Unauthorized", (Exception)((Object)unauthorized));
        }
        catch (InvalidArgument invalidArgument) {
            _logger.error((Object)"Failed to create or modify permissions", (Throwable)invalidArgument);
            operationResult.error = VimServicesVsphereUtil.buildError("AuthzService.exception.InvalidArgument", (Exception)((Object)invalidArgument));
        }
        return operationResult;
    }
}

