/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.services.common.perfmon;

import com.vmware.cis.services.common.perfmon.PerfmonAggregator;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class PerfmonInterceptor
implements MethodInterceptor {
    public static final String METHOD_CALL = "/METHOD_CALL/";
    public static final String METHOD_EXCEPTION = "/METHOD_EXCEPTION/";
    public static final String EXCEPTION_CLASS = "/EXCEPTION_CLASS/";
    private static final String EXCEPTION_COUNTER_UNITS = "count";

    public Object invoke(MethodInvocation inv) throws Throwable {
        String name = METHOD_CALL + PerfmonInterceptor.getInvocationTraceName(inv);
        PerfmonAggregator.StopWatch sw = PerfmonAggregator.startStopWatch(name);
        Exception ex = null;
        try {
            Object object = inv.proceed();
            return object;
        }
        catch (Exception e) {
            ex = e;
            throw e;
        }
        finally {
            sw.stop();
            if (ex != null) {
                PerfmonInterceptor.processException(inv, ex);
            }
        }
    }

    private static void processException(MethodInvocation inv, Exception ex) {
        String exClassName = ex.getClass().getName();
        String exPackageName = ex.getClass().getPackage().getName();
        String exShortClassName = exClassName.substring(exPackageName.length() + 1);
        String ctrMethodException = METHOD_EXCEPTION + PerfmonInterceptor.getInvocationTraceName(inv) + ":" + exShortClassName;
        PerfmonAggregator.sample(ctrMethodException, EXCEPTION_COUNTER_UNITS, 1);
        String ctrExceptionClass = EXCEPTION_CLASS + exClassName + ":" + inv.getMethod().getName();
        PerfmonAggregator.sample(ctrExceptionClass, EXCEPTION_COUNTER_UNITS, 1);
    }

    private static String getInvocationTraceName(MethodInvocation inv) {
        Method m = inv.getMethod();
        return PerfmonInterceptor.getInvocationTraceName(m.getDeclaringClass(), m);
    }

    private static String getInvocationTraceName(Class c, Method m) {
        StringBuilder sb = new StringBuilder();
        sb.append(c.getName()).append('#').append(m.getName());
        return sb.toString();
    }
}

