/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.services.common.sso;

import com.vmware.cis.services.common.sso.SsoOverRestHelper;
import com.vmware.cis.services.common.sso.SsoOverRestRequest;
import com.vmware.cis.services.common.sso.StsCertManager;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.sso.http.AuthException;
import com.vmware.vim.sso.http.AuthVerifier;
import com.vmware.vim.sso.http.AuthVerifierFactory;
import com.vmware.vim.sso.http.Request;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SsoOverRestVerifierUtil {
    private static final Log _log = LogFactory.getLog(SsoOverRestVerifierUtil.class);

    private static String[] parseSecurityHeader(HttpServletRequest request) {
        int parts = Integer.parseInt(request.getHeader("TokenParts"));
        String[] authHeaders = new String[parts];
        for (int i = 0; i < parts; ++i) {
            authHeaders[i] = request.getHeader("TokenPart" + i);
        }
        return authHeaders;
    }

    public static SamlToken verifySecurityHeader(HttpServletRequest request, byte[] extractedPayload, List<X509Certificate> certificates, int clockToleranceSecs, int maxRequestAgeSecs) throws SsoAuthException {
        return SsoOverRestVerifierUtil.verifySecurityHeaderImpl(request, extractedPayload, certificates, clockToleranceSecs, maxRequestAgeSecs);
    }

    public static SamlToken verifySecurityHeader(HttpServletRequest request, byte[] extractedPayload, StsCertManager stsCertManager, int clockToleranceSecs, int maxRequestAgeSecs) throws SsoAuthException {
        int attempt = 1;
        while (true) {
            try {
                return SsoOverRestVerifierUtil.verifySecurityHeaderImpl(request, extractedPayload, stsCertManager.getStsCertificates(), clockToleranceSecs, maxRequestAgeSecs);
            }
            catch (SsoAuthException e) {
                Throwable cause = SsoOverRestVerifierUtil.findCause(e, InvalidTokenException.class);
                if (cause == null || attempt > 1) {
                    throw e;
                }
                _log.warn((Object)("verifySecurityHeader: " + cause.getMessage()));
                stsCertManager.refetchStsCertificates();
                ++attempt;
                continue;
            }
            break;
        }
    }

    private static SamlToken verifySecurityHeaderImpl(HttpServletRequest request, byte[] extractedPayload, List<X509Certificate> certificates, int clockToleranceSecs, int maxRequestAgeSecs) throws SsoAuthException {
        try {
            AuthVerifier verifier = AuthVerifierFactory.instance((X509Certificate[])certificates.toArray(new X509Certificate[certificates.size()]), (int)clockToleranceSecs, (int)maxRequestAgeSecs);
            String[] authHeaders = SsoOverRestVerifierUtil.parseSecurityHeader(request);
            SsoOverRestRequest reqParam = SsoOverRestHelper.createSsoOverRestRequest(request, extractedPayload);
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)String.format("Trying to verify request signature using following; host:%s, port: %d, uri:%s", reqParam.hostName(), reqParam.port(), reqParam.requestURI()));
                }
                return verifier.verifyToken((Request)reqParam, authHeaders);
            }
            catch (AuthException e) {
                _log.error((Object)String.format("Failed to verify request signature using following; host:%s, port: %d, uri:%s", reqParam.hostName(), reqParam.port(), reqParam.requestURI()));
                throw e;
            }
        }
        catch (Exception e) {
            throw new SsoAuthException(e);
        }
    }

    private static Throwable findCause(Throwable leaf, Class causeClass) {
        for (Throwable t = leaf; t != null; t = t.getCause()) {
            if (!causeClass.isInstance(t)) continue;
            return t;
        }
        return null;
    }

    public static class SsoAuthException
    extends Exception {
        public static final long serialVersionUID = 1L;

        public SsoAuthException() {
        }

        public SsoAuthException(String message) {
            super(message);
        }

        public SsoAuthException(Throwable cause) {
            super(cause);
        }

        public SsoAuthException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

