/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.services.common.vapi.sessions.impl;

import com.vmware.cis.services.common.vapi.sessions.VapiSessionManager;
import com.vmware.cis.services.common.vapi.sessions.impl.VlsiSamlSessionHelper;
import com.vmware.vapi.bindings.server.AsyncContext;
import com.vmware.vapi.cis.authn.SamlAuthenticationData;
import com.vmware.vapi.cis.authn.SecurityContextFactory;
import com.vmware.vapi.core.AsyncHandle;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.security.AuthenticationHandler;
import com.vmware.vapi.security.PrincipalId;
import com.vmware.vapi.security.SessionSecurityContext;
import com.vmware.vapi.std.errors.Unauthenticated;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.vmomi.core.util.SHA1HashGenerator;
import com.vmware.vim.vmomi.server.session.Session;
import com.vmware.vim.vmomi.server.session.SessionAuthData;
import com.vmware.vim.vmomi.server.session.SessionManager;
import com.vmware.vim.vmomi.server.session.SessionObject;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VlsiBackedSessionManager
implements VapiSessionManager,
AuthenticationHandler {
    private static final Log _log = LogFactory.getLog(VlsiBackedSessionManager.class);
    private static final String VAPI_CALLBACK_KEY = "vapi_callback_key";
    private SessionManager _sessionManager;
    private VlsiSamlSessionHelper _helper;

    public void setSessionManager(SessionManager sessionManager) {
        this._sessionManager = sessionManager;
    }

    public void setVlsiSessionHelper(VlsiSamlSessionHelper helper) {
        this._helper = helper;
    }

    @Override
    public void login(AsyncContext<char[]> asyncContext) {
        ExecutionContext.SecurityContext securityContext = asyncContext.getInvocationContext().getExecutionContext().retrieveSecurityContext();
        SamlAuthenticationData samlAuthenticationData = SecurityContextFactory.parseSamlSecurityContext((ExecutionContext.SecurityContext)securityContext);
        SamlToken token = samlAuthenticationData.getSamlToken();
        if (token == null) {
            String errMsg = "Rejecting login on a session where SAML token wasn't specified";
            if (_log.isDebugEnabled()) {
                _log.debug((Object)errMsg);
            }
            asyncContext.setResult(null);
            return;
        }
        this.loginInt(asyncContext, token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logout(AsyncContext<Void> asyncContext) {
        try {
            String sessionId = this.getVapiSessionId(asyncContext);
            if (sessionId != null) {
                this.closeVlsiSession(sessionId);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Session (hashed): " + SHA1HashGenerator.generate((String)sessionId) + " has been logged out."));
            }
        }
        finally {
            asyncContext.setResult(null);
        }
    }

    private void closeVlsiSession(String sessionId) {
        Session vlsiSession = this._sessionManager.getSession(sessionId);
        if (vlsiSession != null) {
            vlsiSession.closeSession();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Session (hashed): " + SHA1HashGenerator.generate((String)sessionId) + " has been closed."));
        }
    }

    @Override
    public void keepAlive(AsyncContext<Void> asyncContext) {
        String sessionId = this.getVapiSessionId(asyncContext);
        if (sessionId == null) {
            String errMsg = "attemp to call keepAlive on a non-existent vapi session (hased): " + SHA1HashGenerator.generate((String)sessionId);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)errMsg);
            }
            asyncContext.setResult(null);
            return;
        }
        Session vlsiSession = this._sessionManager.getSession(sessionId);
        if (vlsiSession == null) {
            String errMsg = "attempt to call keepAlive on a session which wasn't authenticated";
            if (_log.isDebugEnabled()) {
                _log.debug((Object)errMsg);
            }
            asyncContext.setResult(null);
            return;
        }
        this._sessionManager.returnSession(vlsiSession);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("keepAlive has succeeded on session with id (hashed) " + SHA1HashGenerator.generate((String)sessionId)));
        }
        asyncContext.setResult(null);
    }

    public void loginInt(AsyncContext<char[]> asyncContext, SamlToken token) {
        Session vlsiSession = this.createVlsiSession();
        String sessionIdStr = vlsiSession.getId();
        if (vlsiSession == null) {
            asyncContext.setError(new RuntimeException("Can not login. VLSI session could not be created."));
        }
        if (!this._helper.loginBySamlToken(vlsiSession, token)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Rejecting login on a session where login failed");
            }
            asyncContext.setError(new RuntimeException("Rejecting login on a session where login failed"));
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Created new VAPI session (hashed):  " + SHA1HashGenerator.generate((String)sessionIdStr) + " backed by VLSI session (hashed): " + SHA1HashGenerator.generate((String)vlsiSession.getId())));
        }
        asyncContext.setResult((Object)sessionIdStr.toCharArray());
    }

    private String getVapiSessionId(AsyncContext<Void> asyncContext) {
        ExecutionContext.SecurityContext securityContext = asyncContext.getInvocationContext().getExecutionContext().retrieveSecurityContext();
        SessionSecurityContext ssc = SecurityContextFactory.parseSessionSecurityContext((ExecutionContext.SecurityContext)securityContext);
        if (ssc == null) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)"Could not retrieve SessionSecurityContext from SecurityContext. Session Id can not be obtained");
            }
            return null;
        }
        return new String(ssc.getSessionId());
    }

    public Session getSession(String sessionId) {
        Session session = this._sessionManager.getSession(sessionId);
        this._sessionManager.returnSession(session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(ExecutionContext.SecurityContext ctx, AsyncHandle<AuthenticationHandler.AuthenticationResult> asyncHandle) {
        SessionSecurityContext sessionSecurityContext = SecurityContextFactory.parseSessionSecurityContext((ExecutionContext.SecurityContext)ctx);
        char[] sessionId = sessionSecurityContext.getSessionId();
        if (sessionId == null) {
            String errMsg = "Session ID unspecified - rejecting authenticate request";
            if (_log.isDebugEnabled()) {
                _log.debug((Object)errMsg);
            }
            asyncHandle.setError(new RuntimeException(errMsg));
            return;
        }
        String sessionIdStr = new String(sessionId);
        Session s = this._sessionManager.getSession(sessionIdStr);
        if (s == null) {
            String errMsg = "Session ID (hashed)" + SHA1HashGenerator.generate((String)sessionIdStr) + " not found - rejecting authenticate request";
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Session ID (hashed) " + SHA1HashGenerator.generate((String)sessionIdStr) + " not found - rejecting authenticate request"));
            }
            asyncHandle.setError(new RuntimeException(errMsg));
            return;
        }
        if (s.isClosed()) {
            String errMsg = "Session ID (hashed) " + SHA1HashGenerator.generate((String)sessionIdStr) + " already closed";
            if (_log.isDebugEnabled()) {
                _log.debug((Object)errMsg);
            }
            asyncHandle.setError(new RuntimeException(errMsg));
            this._sessionManager.returnSession(s);
            return;
        }
        final SessionAuthData sad = s.getAuthData();
        if (sad == null) {
            String errMsg = "Session ID (hashed) " + SHA1HashGenerator.generate((String)sessionIdStr) + "found, but not logged in";
            if (_log.isDebugEnabled()) {
                _log.debug((Object)errMsg);
            }
            asyncHandle.setError(new RuntimeException(errMsg));
            return;
        }
        try {
            asyncHandle.setResult((Object)new AuthenticationHandler.AuthenticationResult(){

                public PrincipalId getUser() {
                    return new PrincipalId(){

                        public String getName() {
                            return sad.getUser();
                        }

                        public String getDomain() {
                            return null;
                        }
                    };
                }

                public List<PrincipalId> getGroups() {
                    return null;
                }
            });
        }
        finally {
            if (s != null) {
                this._sessionManager.returnSession(s);
            }
        }
    }

    public List<String> supportedAuthenticationSchemes() {
        return Collections.singletonList("com.vmware.vapi.std.security.session_id");
    }

    public Session getUserVlsisession(AsyncContext<?> asyncContext) {
        ExecutionContext.SecurityContext securityCtx = asyncContext.getInvocationContext().getExecutionContext().retrieveSecurityContext();
        if (securityCtx == null) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)"Unable to fetch security context from the given context");
            }
            throw new Unauthenticated();
        }
        String sessionId = String.valueOf(securityCtx.getProperty("sessionId"));
        if (sessionId == null) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)"vAPI SessionId could not be retrieved from SecurityContext");
            }
            throw new Unauthenticated();
        }
        Session vlsiSession = this._sessionManager.getSession(sessionId);
        if (vlsiSession == null) {
            if (_log.isErrorEnabled()) {
                _log.error((Object)("Unable to fetch VLSI session for id (hashed): " + SHA1HashGenerator.generate((String)sessionId)));
            }
            throw new Unauthenticated();
        }
        this._sessionManager.returnSession(vlsiSession);
        return vlsiSession;
    }

    private Session createVlsiSession() {
        Session newSession = this._sessionManager.createSession();
        this._sessionManager.returnSession(newSession);
        return newSession;
    }

    private class VapiMappedSessionObject
    implements SessionObject {
        private final String _vapiSessionId;

        private VapiMappedSessionObject(String vapiSessionId) {
            this._vapiSessionId = vapiSessionId;
        }

        public void sessionClosed() {
            VlsiBackedSessionManager.this.closeVlsiSession(this._vapiSessionId);
        }
    }
}

