/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.globalview;

import com.vmware.samples.globalview.GlobalService;
import com.vmware.samples.globalview.model.GlobalSettings;
import com.vmware.samples.globalview.model.SettingEnum;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GlobalServiceImpl
implements GlobalService {
    private static final Log _logger = LogFactory.getLog(GlobalServiceImpl.class);
    private static final String SETTINGS_DIR_PATH = GlobalServiceImpl.getGlobalViewDataFolder();
    private static final String SETTINGS_PROPERTIES = "settings.properties";
    private static final String SETTINGS_FILE_PATH = SETTINGS_DIR_PATH + "/" + "settings.properties";
    private GlobalSettings _settings = null;
    private GlobalSettings _defaultSettings = new GlobalSettings("def-value1", "def-value2", SettingEnum.VAL1);
    private Properties _props = new Properties();
    private File _persistentSettings = new File(SETTINGS_FILE_PATH);

    public GlobalServiceImpl() {
        this.initializeSettings();
    }

    @Override
    public synchronized GlobalSettings getSettings() {
        return this._settings;
    }

    @Override
    public synchronized void setSettings(GlobalSettings globalSettings) throws Exception {
        this._settings = globalSettings;
        this.saveSettings();
    }

    private void saveSettings() throws Exception {
        Object object;
        this._props.put("setting1.value", this._settings.getSetting1());
        this._props.put("setting2.value", this._settings.getSetting2());
        this._props.put("setting3.value", this._settings.getSetting3().name());
        if (!this._persistentSettings.exists()) {
            object = new File(SETTINGS_DIR_PATH);
            if (!((File)object).exists()) {
                if (!((File)object).mkdirs()) {
                    String string = "Could not create directory " + SETTINGS_DIR_PATH + ", check the write permission of the Virgo process.";
                    _logger.error((Object)string);
                    throw new Exception(string);
                }
                _logger.info((Object)("Created directory " + ((File)object).getPath()));
            }
            try {
                this._persistentSettings.createNewFile();
            }
            catch (IOException iOException) {
                String string = "Could not create file " + SETTINGS_FILE_PATH;
                _logger.error((Object)string, (Throwable)iOException);
                throw new Exception(string, iOException);
            }
        }
        object = null;
        try {
            object = new FileOutputStream(this._persistentSettings);
            this._props.store((OutputStream)object, "properties file for the globalview sample");
            _logger.info((Object)("Globalview settings saved in " + this._persistentSettings.getPath()));
        }
        catch (Exception exception) {
            String string = "Error while saving settings in " + SETTINGS_FILE_PATH;
            _logger.error((Object)string, (Throwable)exception);
            throw new Exception(string, exception);
        }
        finally {
            if (object != null) {
                try {
                    ((OutputStream)object).close();
                }
                catch (IOException iOException) {
                    _logger.error((Object)iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSettings() {
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this._persistentSettings);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (inputStream == null && (inputStream = this.getClass().getClassLoader().getResourceAsStream(SETTINGS_PROPERTIES)) == null) {
            _logger.warn((Object)"Resource file missing: settings.properties, will use the hard-coded default settings instead");
            this._settings = this._defaultSettings;
            return;
        }
        try {
            this._props.load(inputStream);
            String string = this._props.getProperty("setting1.value");
            String string2 = this._props.getProperty("setting2.value");
            SettingEnum settingEnum = SettingEnum.valueOf(this._props.getProperty("setting3.value"));
            this._settings = new GlobalSettings(string, string2, settingEnum);
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
            this._settings = this._defaultSettings;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    _logger.error((Object)iOException);
                }
            }
        }
    }

    private static String getGlobalViewDataFolder() {
        String string = System.getProperty("user.name");
        String string2 = System.getenv("VMWARE_DATA_DIR");
        String string3 = (string2 == null ? "temp" : string2) + File.separator + string + File.separator + "globalview";
        return string3;
    }
}

