/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.samples.globalview.mvc;

import com.google.gson.Gson;
import com.vmware.samples.globalview.EchoService;
import com.vmware.samples.globalview.GlobalService;
import com.vmware.samples.globalview.model.GlobalSettings;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/services"})
public class ServicesController {
    private final EchoService _echoService;
    private final GlobalService _globalService;

    @Autowired
    public ServicesController(@Qualifier(value="echoService") EchoService echoService, @Qualifier(value="globalService") GlobalService globalService) {
        this._echoService = echoService;
        this._globalService = globalService;
    }

    @RequestMapping(value={"/echo"}, method={RequestMethod.POST})
    @ResponseBody
    public String echo(@RequestParam(value="message", required=true) String string) throws Exception {
        return this._echoService.echo(string);
    }

    @RequestMapping(value={"/getSettings"}, method={RequestMethod.GET})
    @ResponseBody
    public GlobalSettings getSettings() throws Exception {
        return this._globalService.getSettings();
    }

    @RequestMapping(value={"/saveSettings"}, method={RequestMethod.POST})
    @ResponseBody
    public void setSettings(@RequestParam(value="json", required=true) String string) throws Exception {
        Gson gson = new Gson();
        GlobalSettings globalSettings = (GlobalSettings)gson.fromJson(string, GlobalSettings.class);
        this._globalService.setSettings(globalSettings);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public Map<String, String> handleException(Exception exception, HttpServletResponse httpServletResponse) {
        httpServletResponse.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("message", exception.getMessage());
        if (exception.getCause() != null) {
            hashMap.put("cause", exception.getCause().getMessage());
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        hashMap.put("stackTrace", stringWriter.toString());
        return hashMap;
    }
}

