/*
 * Decompiled with CFR 0.152.
 */
package DataServiceProvider.util.vapi;

import com.vmware.cis.data.provider.metadata.vapi.SchemaDefinitions;
import com.vmware.cis.data.provider.vapi.ResourceModelDefinitions;
import com.vmware.vapi.bindings.type.StructType;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class StructTypeUtil {
    public static void populateCanonicalNameToStructTypeMap(Map<String, StructType> map) {
        Validate.notNull(map);
        StructTypeUtil.add(map, "com.vmware.cis.data.provider.resource_model.query_spec", ResourceModelDefinitions.querySpec);
        StructTypeUtil.add(map, "com.vmware.cis.data.provider.resource_model.filter", ResourceModelDefinitions.filter);
        StructTypeUtil.add(map, "com.vmware.cis.data.provider.resource_model.property_predicate", ResourceModelDefinitions.propertyPredicate);
        StructTypeUtil.add(map, "com.vmware.cis.data.provider.resource_model.sort_criterion", ResourceModelDefinitions.sortCriterion);
        StructTypeUtil.add(map, "com.vmware.cis.data.provider.resource_model.result_set", ResourceModelDefinitions.resultSet);
        StructTypeUtil.add(map, "com.vmware.cis.data.provider.resource_model.resource_item", ResourceModelDefinitions.resourceItem);
        StructTypeUtil.add(map, "com.vmware.cis.data.provider.metadata.schema.schema_info", SchemaDefinitions.schemaInfo);
        StructTypeUtil.add(map, "com.vmware.cis.data.provider.metadata.schema.model_info", SchemaDefinitions.modelInfo);
        StructTypeUtil.add(map, "com.vmware.cis.data.provider.metadata.schema.property_info", SchemaDefinitions.propertyInfo);
    }

    private static void add(Map<String, StructType> map, String string, StructType structType) {
        if (map.containsKey(string)) {
            throw new IllegalArgumentException("Two structures with the same canonical name detected: " + string + ". Unable to populate the map.");
        }
        map.put(string, structType);
    }
}

