/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.attribute.impl;

import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vim.CustomFieldsManager;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.fault.DuplicateName;
import com.vmware.vim.binding.vim.fault.InvalidPrivilege;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.attribute.AttributeSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AttributeMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(AttributeMutationProvider.class);
    private static final String RESOURCE_BUNDLE_NAME = "AttributeService";

    public OperationResult add(AttributeSpec attributeSpec) throws DuplicateName, InvalidPrivilege {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = attributeSpec.ownerRef;
        try {
            CustomFieldsManager customFieldsManager = MixedUtil.getCustomFieldManager((ManagedObjectReference)attributeSpec.ownerRef);
            if (customFieldsManager == null) {
                throw new IllegalArgumentException(this.getLocalizedString("error.invalidFieldsManager"));
            }
            TypeName typeName = this.getTypeName(attributeSpec.typeName);
            CustomFieldsManager.FieldDef fieldDef = customFieldsManager.addFieldDefinition(attributeSpec.name, typeName, null, null);
            if (!StringUtil.isNullOrEmpty((String)attributeSpec.value)) {
                customFieldsManager.setField(attributeSpec.ownerRef, fieldDef.key, attributeSpec.value);
            }
            operationResult.result = fieldDef;
        }
        catch (Exception exception) {
            _logger.error((Object)("Error when adding a custom attribute: " + exception));
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, AttributeSpec attributeSpec) throws DuplicateName, InvalidPrivilege {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            CustomFieldsManager customFieldsManager = MixedUtil.getCustomFieldManager((ManagedObjectReference)managedObjectReference);
            if (customFieldsManager == null) {
                throw new IllegalArgumentException(this.getLocalizedString("error.invalidFieldsManager"));
            }
            if (attributeSpec.key == 0) {
                operationResult = this.setCustomValue(managedObjectReference, attributeSpec.name, attributeSpec.value);
            } else {
                customFieldsManager.renameFieldDefinition(attributeSpec.key, attributeSpec.name);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("Error when editing a custom attribute: " + exception));
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return operationResult;
    }

    public OperationResult remove(ManagedObjectReference managedObjectReference, AttributeSpec attributeSpec) {
        OperationResult operationResult = new OperationResult();
        try {
            CustomFieldsManager customFieldsManager = MixedUtil.getCustomFieldManager((ManagedObjectReference)managedObjectReference);
            if (customFieldsManager == null) {
                throw new IllegalArgumentException(this.getLocalizedString("error.invalidFieldsManager"));
            }
            customFieldsManager.removeFieldDefinition(attributeSpec.key);
        }
        catch (Exception exception) {
            _logger.error((Object)("Error when removing a custom attribute: " + exception));
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return operationResult;
    }

    private String getLocalizedString(String string) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)string, (ClassLoader)this.getClass().getClassLoader());
    }

    private OperationResult setCustomValue(ManagedObjectReference managedObjectReference, String string, String string2) throws Exception {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        if (string2 != null && !string2.trim().isEmpty()) {
            ManagedEntity managedEntity = (ManagedEntity)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
            managedEntity.setCustomValue(string, string2);
        }
        return operationResult;
    }

    private TypeName getTypeName(String string) {
        TypeNameImpl typeNameImpl = null;
        if (string != null) {
            typeNameImpl = new TypeNameImpl(string);
        }
        return typeNameImpl;
    }
}

