/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.attribute.impl;

import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vim.CustomFieldsManager;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.fault.DuplicateName;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.TypeName;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.attribute.CustomFieldSpec;

public class CustomFieldMutationProvider
implements MutationProvider {
    private static final String RESOURCE_BUNDLE_NAME = "AttributeService";

    public OperationResult apply(ManagedObjectReference managedObjectReference, CustomFieldSpec customFieldSpec) throws Exception {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        CustomFieldsManager customFieldsManager = MixedUtil.getCustomFieldManager((ManagedObjectReference)managedObjectReference);
        if (customFieldsManager == null) {
            throw new IllegalArgumentException(this.getLocalizedString("error.invalidFieldsManager"));
        }
        switch (customFieldSpec.operationId) {
            case ADD: {
                operationResult.result = this.addCustomFieldDefinition(customFieldsManager, customFieldSpec);
                break;
            }
            case REMOVE: {
                this.removeCustomFieldDefinition(customFieldsManager, customFieldSpec);
                break;
            }
            case RENAME: {
                this.renameCustomFieldDefinition(customFieldsManager, customFieldSpec);
                break;
            }
            case EDIT: {
                this.setCustomFieldValue(customFieldSpec);
                break;
            }
        }
        return operationResult;
    }

    public OperationResult applyMultiSpec(ManagedObjectReference managedObjectReference, CustomFieldSpec[] customFieldSpecArray) throws Exception {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            for (CustomFieldSpec customFieldSpec : customFieldSpecArray) {
                operationResult = this.apply(managedObjectReference, customFieldSpec);
            }
        }
        catch (Exception exception) {
            operationResult.error = exception;
        }
        return operationResult;
    }

    private CustomFieldsManager.FieldDef addCustomFieldDefinition(CustomFieldsManager customFieldsManager, CustomFieldSpec customFieldSpec) throws Exception {
        TypeName typeName = this.typeNameFromString(customFieldSpec.typeName);
        CustomFieldsManager.FieldDef fieldDef = customFieldsManager.addFieldDefinition(customFieldSpec.name, typeName, null, null);
        if (!StringUtil.isNullOrEmpty((String)customFieldSpec.value)) {
            this.setCustomFieldValue(customFieldSpec);
        }
        return fieldDef;
    }

    private void removeCustomFieldDefinition(CustomFieldsManager customFieldsManager, CustomFieldSpec customFieldSpec) {
        customFieldsManager.removeFieldDefinition(customFieldSpec.key);
    }

    private void renameCustomFieldDefinition(CustomFieldsManager customFieldsManager, CustomFieldSpec customFieldSpec) throws DuplicateName {
        customFieldsManager.renameFieldDefinition(customFieldSpec.key, customFieldSpec.name);
    }

    private void setCustomFieldValue(CustomFieldSpec customFieldSpec) throws Exception {
        ManagedEntity managedEntity = (ManagedEntity)ManagedObjectUtil.getManagedObject((ManagedObjectReference)customFieldSpec.owner);
        managedEntity.setCustomValue(customFieldSpec.name, customFieldSpec.value);
    }

    private TypeName typeNameFromString(String string) {
        return string == null ? null : new TypeNameImpl(string);
    }

    private String getLocalizedString(String string) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)string, (ClassLoader)this.getClass().getClassLoader());
    }
}

