/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.error;

import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.vim.TaskFilterSpec;
import com.vmware.vim.binding.vim.TaskHistoryCollector;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.TaskManager;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventFilterSpec;
import com.vmware.vim.binding.vim.event.EventHistoryCollector;
import com.vmware.vim.binding.vim.event.EventManager;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.store.InvalidArgumentException;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.error.ApplicationException;
import com.vmware.vsphere.client.error.I18nUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ErrorReportUtil {
    private static final Log _logger = LogFactory.getLog(ErrorReportUtil.class);
    private static final String FORMAT_TIME = "yyyy-MM-dd HH:mm:ss";

    public static String formatForServer(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Calendar) {
            object = ((Calendar)object).getTime();
        }
        if (object instanceof Date) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_TIME);
            return simpleDateFormat.format((Date)object);
        }
        return object.toString();
    }

    public static String formatForDisplay(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Calendar) {
            object = ((Calendar)object).getTime();
        }
        if (object instanceof Date) {
            DateFormat dateFormat = SimpleDateFormat.getDateTimeInstance();
            return dateFormat.format(object);
        }
        return object.toString();
    }

    public static String htmlEncode(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c > '\u007f' || c == '\'') {
                stringBuffer.append("&#" + c + ";");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String urlEncode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    public static VcService getService(String string) {
        VcService vcService = VimSessionUtil.getService((String)string);
        if (vcService == null) {
            throw new ApplicationException(I18nUtil.text("ErrorMessages.connectionFailed", new String[0]));
        }
        return vcService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Event getEvent(VcService vcService, int n) throws Exception {
        if (n <= 0) {
            return null;
        }
        EventManager eventManager = (EventManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vcService.getServiceInstanceContent().getEventManager());
        EventFilterSpec eventFilterSpec = new EventFilterSpec();
        eventFilterSpec.eventChainId = n;
        EventHistoryCollector eventHistoryCollector = (EventHistoryCollector)ManagedObjectUtil.getManagedObject((ManagedObjectReference)eventManager.createCollector(eventFilterSpec));
        try {
            Event[] eventArray = eventHistoryCollector.readNext(1);
            if (eventArray == null) {
                Event event = null;
                return event;
            }
            if (eventArray.length > 0) {
                Event event = eventArray[0];
                return event;
            }
        }
        catch (Exception exception) {
            _logger.debug((Object)exception);
        }
        finally {
            if (eventHistoryCollector != null) {
                eventHistoryCollector.remove();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskInfo getTaskInfo(VcService vcService, String string, int n, String string2) throws Exception {
        if (StringUtil.isNullOrEmpty((String)string) || !string.startsWith("task-")) {
            return null;
        }
        if (n <= 0 && StringUtil.isNullOrEmpty((String)string2)) {
            throw new InvalidArgumentException("eventChainId or parentTaskId is required");
        }
        TaskManager taskManager = (TaskManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vcService.getServiceInstanceContent().getTaskManager());
        TaskFilterSpec taskFilterSpec = new TaskFilterSpec();
        taskFilterSpec.eventChainId = new int[]{n};
        taskFilterSpec.parentTaskKey = !StringUtil.isNullOrEmpty((String)string2) ? new String[]{string2} : new String[0];
        TaskHistoryCollector taskHistoryCollector = (TaskHistoryCollector)ManagedObjectUtil.getManagedObject((ManagedObjectReference)taskManager.createCollector(taskFilterSpec));
        try {
            TaskInfo[] taskInfoArray = taskHistoryCollector.readNext(10);
            if (taskInfoArray == null) {
                TaskInfo taskInfo = null;
                return taskInfo;
            }
            for (TaskInfo taskInfo : taskInfoArray) {
                if (!taskInfo.key.equals(string)) continue;
                TaskInfo taskInfo2 = taskInfo;
                return taskInfo2;
            }
        }
        catch (Exception exception) {
            _logger.debug((Object)exception);
        }
        finally {
            taskHistoryCollector.remove();
        }
        return null;
    }

    public static KeyAnyValue newKeyValue(String string, Object object) {
        KeyAnyValueImpl keyAnyValueImpl = new KeyAnyValueImpl();
        keyAnyValueImpl.setKey(string);
        keyAnyValueImpl.setValue(object);
        return keyAnyValueImpl;
    }
}

