/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.error.impl;

import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.service.ServiceListener;
import com.vmware.vise.util.service.ServiceRegistry;
import com.vmware.vsphere.client.common.error.ErrorStackResolver;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ErrorStackResolverRegistrar {
    private static final Log _logger = LogFactory.getLog(ErrorStackResolverRegistrar.class);
    private HashMap<String, ErrorStackResolver> _resolverByResolveeClassName;
    private boolean _initialized = false;
    private ServiceRegistry _serviceRegistry;

    public ErrorStackResolverRegistrar(ServiceRegistry serviceRegistry) {
        this._serviceRegistry = serviceRegistry;
        this._resolverByResolveeClassName = new HashMap();
        this.initialize();
    }

    public synchronized ErrorStackResolver getErrorStackResolver(String string) {
        return this._resolverByResolveeClassName.get(string);
    }

    private synchronized void initialize() {
        if (this._initialized) {
            return;
        }
        ServiceListener serviceListener = new ServiceListener(){

            public void serviceAdded(Object object) {
                ErrorStackResolverRegistrar.this.addResolverToCache(object);
            }

            public void serviceRemoved(Object object) {
                ErrorStackResolverRegistrar.this.removeResolverFromCache(object);
            }
        };
        this._serviceRegistry.registerServiceListener(ErrorStackResolver.class.getName(), serviceListener);
        this._initialized = true;
    }

    private synchronized void addResolverToCache(Object object) {
        try {
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("Registering ErrorStack resolver " + object));
            }
            if (object instanceof ErrorStackResolver) {
                ErrorStackResolver errorStackResolver = (ErrorStackResolver)object;
                this.registerResolver(errorStackResolver);
            }
        }
        catch (Throwable throwable) {
            _logger.error((Object)throwable.getLocalizedMessage());
        }
    }

    private synchronized void removeResolverFromCache(Object object) {
        if (object instanceof ErrorStackResolver) {
            ErrorStackResolver errorStackResolver = (ErrorStackResolver)object;
            this.unregisterResolver(errorStackResolver);
        }
    }

    private synchronized void unregisterResolver(ErrorStackResolver errorStackResolver) {
        String[] stringArray;
        for (String string : stringArray = errorStackResolver.getHandledTypeNames()) {
            if (StringUtil.isNullOrEmpty((String)string)) continue;
            this._resolverByResolveeClassName.remove(string);
        }
    }

    private synchronized void registerResolver(ErrorStackResolver errorStackResolver) {
        String[] stringArray;
        for (String string : stringArray = errorStackResolver.getHandledTypeNames()) {
            if (StringUtil.isNullOrEmpty((String)string)) continue;
            this._resolverByResolveeClassName.put(string, errorStackResolver);
        }
    }
}

