/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.export.datagrid;

import com.vmware.vise.data.common.XSFacet;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.SortType;
import com.vmware.vise.data.query.impl.DataFormatUtil;
import com.vmware.vise.metadata.MetadataService;
import com.vmware.vise.metadata.PropertyDescriptor;
import com.vmware.vise.metadata.Units;
import com.vmware.vise.reporting.DataSource;
import com.vmware.vise.reporting.ReportingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class DatagridDataSource
extends DataSource {
    private static final long serialVersionUID = 1L;
    public static final int NO_VIRTUAL_PAGING = -1;
    public static final int OFFSET_START = 0;
    private int _index = -1;
    private ArrayList<Map<String, String>> _data;
    private HashMap<String, HashMap<String, PropertyDescriptor>> _metadata = new HashMap();
    private int _pageSize = -1;
    private int _offset = 0;
    private DataService _dataService;
    private MetadataService _metadataService;
    private QuerySpec[] _querySpecs;

    public void requestData(DataService dataService, MetadataService metadataService, QuerySpec[] querySpecArray, int n, int n2) {
        if (dataService == null || querySpecArray == null) {
            this._data = null;
            return;
        }
        this._dataService = dataService;
        this._metadataService = metadataService;
        this._querySpecs = querySpecArray;
        this._pageSize = n;
        this._offset = n2;
        this.doRequestData();
    }

    public void requestData(DataService dataService, MetadataService metadataService, QuerySpec[] querySpecArray) {
        this.requestData(dataService, metadataService, querySpecArray, -1, 0);
    }

    private void doRequestData() {
        if (this._querySpecs == null || this._querySpecs.length != 1) {
            throw new RuntimeException("QuerySpec is invalid.");
        }
        this._data = new ArrayList();
        this._index = -1;
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.maxResultCount = this._pageSize;
        resultSpec.offset = this._offset;
        resultSpec.order = this.createOrderingCriteria();
        this._querySpecs[0].resultSpec = resultSpec;
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = this._querySpecs;
        Response response = new Response();
        response.resultSet = null;
        response = this._dataService.getData(requestSpec);
        ResultItem[] resultItemArray = response.resultSet[0].items;
        if (resultItemArray.length == 0) {
            return;
        }
        for (ResultItem resultItem : resultItemArray) {
            PropertyDescriptor[] propertyDescriptorArray;
            String string = QueryUtil.getReferenceType((Object)resultItem.resourceObject);
            if (this._metadata == null || !this._metadata.containsKey(string)) {
                propertyDescriptorArray = this._metadataService.getPropertyMetadata(string);
                this.createMetadataForType(string, propertyDescriptorArray);
            }
            propertyDescriptorArray = resultItem.properties;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
                String string2 = propertyDescriptor.propertyName;
                String string3 = null;
                if (propertyDescriptor.value instanceof Object[]) {
                    Object[] objectArray = (Object[])propertyDescriptor.value;
                    StringBuilder stringBuilder = new StringBuilder();
                    String string4 = ", ";
                    for (int i = 0; i < objectArray.length; ++i) {
                        String string5 = this.format(string, string2, objectArray[i]);
                        stringBuilder.append(string5);
                        if (i == objectArray.length - 1) continue;
                        stringBuilder.append(string4);
                    }
                    string3 = stringBuilder.toString();
                } else {
                    string3 = this.format(string, string2, propertyDescriptor.value);
                }
                hashMap.put(string2, string3);
            }
            this._data.add(hashMap);
        }
    }

    private void createMetadataForType(String string, PropertyDescriptor[] propertyDescriptorArray) {
        if (propertyDescriptorArray.length == 0) {
            return;
        }
        HashMap<String, PropertyDescriptor> hashMap = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
            String[] stringArray;
            String string2 = propertyDescriptor.name;
            hashMap.put(string2, propertyDescriptor);
            for (String string3 : stringArray = propertyDescriptor.aliases) {
                hashMap.put(string3, propertyDescriptor);
            }
        }
        this._metadata.put(string, hashMap);
    }

    private String format(String string, String string2, Object object) {
        if (object == null) {
            return "";
        }
        if (this._metadata == null || !this._metadata.containsKey(string)) {
            return object.toString();
        }
        HashMap<String, PropertyDescriptor> hashMap = this._metadata.get(string);
        if (!hashMap.containsKey(string2)) {
            return object.toString();
        }
        String string3 = null;
        PropertyDescriptor propertyDescriptor = hashMap.get(string2);
        string3 = propertyDescriptor.unit != null ? DataFormatUtil.formatValueWithUnit((Object)object, (Units)propertyDescriptor.unit, (Units)propertyDescriptor.displayForm) : (propertyDescriptor.staticValueSpace != null ? DataFormatUtil.formatValueWithStaticValueSpace((Object)object, (XSFacet[])propertyDescriptor.staticValueSpace) : object.toString());
        return string3;
    }

    private OrderingCriteria createOrderingCriteria() {
        OrderingPropertySpec orderingPropertySpec = new OrderingPropertySpec();
        String[] stringArray = this.getFirstPropertyFromQuerySpec();
        if (stringArray == null) {
            return null;
        }
        orderingPropertySpec.propertyNames = stringArray;
        orderingPropertySpec.orderingType = SortType.ASCENDING;
        OrderingPropertySpec[] orderingPropertySpecArray = new OrderingPropertySpec[]{orderingPropertySpec};
        OrderingCriteria orderingCriteria = new OrderingCriteria();
        orderingCriteria.orderingProperties = orderingPropertySpecArray;
        return orderingCriteria;
    }

    private String[] getFirstPropertyFromQuerySpec() {
        try {
            String string = this._querySpecs[0].resourceSpec.propertySpecs[0].propertyNames[0];
            return new String[]{string};
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Object getValue(DataSource.Field field) {
        String string = this._data.get(this._index).get(field.name);
        return string;
    }

    public boolean nextRow() throws ReportingException {
        if (this._pageSize == -1) {
            ++this._index;
            return this._index < this._data.size();
        }
        if (this._index >= this._pageSize - 1) {
            this._offset += this._pageSize;
            this.doRequestData();
        }
        ++this._index;
        if (this._data.size() == 0) {
            return false;
        }
        if (this._data.size() < this._pageSize) {
            return this._index < this._data.size();
        }
        return true;
    }
}

