/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.export.datagrid;

import com.vmware.vise.reporting.ReportDef;
import com.vmware.vise.reporting.util.Logger;
import com.vmware.vsphere.client.export.LabelSpec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import org.apache.commons.logging.Log;

public class DatagridReportDef
implements ReportDef {
    private static final long serialVersionUID = 1L;
    private static Log _log = Logger.getLog(DatagridReportDef.class);
    private static final int DEFAULT_COLUMN_WIDTH = 200;
    private static final int DEFAULT_COLUMN_HEIGHT = 30;
    public static final String REPORT_TITLE = "ReportTitle";
    public static final String DEFAULT_REPORT_NAME = "DefaultReportName";
    private LabelSpec[] _labelSpecs;
    private String _name;

    public void init(String string, LabelSpec[] labelSpecArray) {
        this._name = string;
        this._labelSpecs = labelSpecArray;
    }

    public void init(LabelSpec[] labelSpecArray) {
        this._name = DEFAULT_REPORT_NAME;
        this._labelSpecs = labelSpecArray;
    }

    public String getName() {
        return this._name;
    }

    public InputStream getReportDefinition() {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            JasperDesign jasperDesign = this.getJasperDesign();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            JasperCompileManager.writeReportToXmlStream((JRReport)jasperDesign, (OutputStream)byteArrayOutputStream);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
        }
        catch (JRException jRException) {
            _log.debug((Object)"Failed to convert JasperDesign object into XML stream.", (Throwable)jRException);
        }
        catch (IOException iOException) {
            _log.debug((Object)"Output stream failed.", (Throwable)iOException);
        }
        return byteArrayInputStream;
    }

    public InputStream getUIDefinition() {
        throw new RuntimeException("Functionality not provided");
    }

    public Properties getManifest() {
        Properties properties = new Properties();
        properties.setProperty("ProductName", "vSphere Client");
        properties.setProperty("BundleName", "com.vmware.vise.reporting");
        properties.setProperty("BundleVersion", "5.1.0");
        properties.setProperty("REPORTING_DEFINITION_FORMAT", "jrxml");
        return properties;
    }

    public InputStream getResource(String string) throws IOException {
        throw new RuntimeException("Functionality not provided");
    }

    public String[] getResourceNames() {
        throw new RuntimeException("Functionality not provided");
    }

    private JasperDesign getJasperDesign() throws JRException {
        JRDesignField jRDesignField;
        if (this._labelSpecs == null) {
            _log.error((Object)"TODO cgu: _properties cannot be null. Error message need to be justified");
            return null;
        }
        JasperDesign jasperDesign = new JasperDesign();
        jasperDesign.setName(this._name);
        jasperDesign.setPageWidth(842);
        jasperDesign.setPageHeight(595);
        jasperDesign.setColumnWidth(802);
        jasperDesign.setOrientation(OrientationEnum.LANDSCAPE);
        jasperDesign.setColumnSpacing(0);
        jasperDesign.setLeftMargin(20);
        jasperDesign.setRightMargin(20);
        jasperDesign.setTopMargin(20);
        jasperDesign.setBottomMargin(20);
        jasperDesign.setIgnorePagination(true);
        JRDesignStyle jRDesignStyle = new JRDesignStyle();
        jRDesignStyle.setName("Default");
        jRDesignStyle.setDefault(true);
        jRDesignStyle.setFontSize(12);
        jasperDesign.addStyle((JRStyle)jRDesignStyle);
        JRDesignParameter jRDesignParameter = new JRDesignParameter();
        jRDesignParameter.setName(REPORT_TITLE);
        jRDesignParameter.setValueClass(String.class);
        jasperDesign.addParameter((JRParameter)jRDesignParameter);
        for (LabelSpec labelSpec : this._labelSpecs) {
            jRDesignField = new JRDesignField();
            jRDesignField.setName(labelSpec.property);
            jRDesignField.setValueClass(String.class);
            jasperDesign.addField((JRField)jRDesignField);
        }
        JRDesignBand jRDesignBand = new JRDesignBand();
        jasperDesign.setPageHeader((JRBand)jRDesignBand);
        JRDesignBand jRDesignBand2 = new JRDesignBand();
        for (int i = 0; i < this._labelSpecs.length; ++i) {
            LabelSpec labelSpec;
            jRDesignBand2.setHeight(30);
            labelSpec = new JRDesignStaticText();
            labelSpec.setX(i * 200);
            labelSpec.setY(0);
            labelSpec.setWidth(200);
            labelSpec.setHeight(30);
            labelSpec.setHorizontalAlignment(HorizontalAlignEnum.CENTER);
            labelSpec.setStyle((JRStyle)jRDesignStyle);
            labelSpec.setPrintWhenDetailOverflows(true);
            labelSpec.setText(this._labelSpecs[i].name);
            jRDesignBand2.addElement((JRDesignElement)labelSpec);
        }
        jasperDesign.setColumnHeader((JRBand)jRDesignBand2);
        JRDesignBand jRDesignBand3 = new JRDesignBand();
        for (int i = 0; i < this._labelSpecs.length; ++i) {
            jRDesignBand3.setHeight(30);
            jRDesignField = new JRDesignTextField();
            jRDesignField.setX(i * 200);
            jRDesignField.setY(0);
            jRDesignField.setWidth(200);
            jRDesignField.setHeight(30);
            jRDesignField.setHorizontalAlignment(HorizontalAlignEnum.CENTER);
            jRDesignField.setStyle((JRStyle)jRDesignStyle);
            jRDesignField.setBlankWhenNull(true);
            jRDesignField.setStretchWithOverflow(true);
            jRDesignField.setPrintWhenDetailOverflows(true);
            JRDesignExpression jRDesignExpression = new JRDesignExpression();
            jRDesignExpression.setValueClass(String.class);
            jRDesignExpression.setText("$F{" + this._labelSpecs[i].property + "}");
            jRDesignField.setExpression((JRExpression)jRDesignExpression);
            jRDesignBand3.addElement((JRDesignElement)jRDesignField);
        }
        ((JRDesignSection)jasperDesign.getDetailSection()).addBand((JRBand)jRDesignBand3);
        jRDesignBand = new JRDesignBand();
        jasperDesign.setColumnFooter((JRBand)jRDesignBand);
        jRDesignBand = new JRDesignBand();
        jasperDesign.setPageFooter((JRBand)jRDesignBand);
        jRDesignBand = new JRDesignBand();
        jasperDesign.setSummary((JRBand)jRDesignBand);
        return jasperDesign;
    }
}

