/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.extension;

import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionManager;
import com.vmware.vise.extensionfw.ExtensionPointInfo;
import com.vmware.vise.extensionfw.IExtensionObjectParser;
import com.vmware.vise.extensionfw.PluginInfo;
import com.vmware.vise.util.IPluginRef;
import com.vmware.vise.util.IUID;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.io.StreamUtil;
import com.vmware.vsphere.client.extension.ClassInfo;
import java.io.Closeable;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtensionObjectParser
implements IExtensionObjectParser {
    private static final Log _logger = LogFactory.getLog(ExtensionObjectParser.class);
    private static final Pattern RESOURCE_REG_EX_NO_BUNDLE_NAME = Pattern.compile("#\\{(\\w+)(\\.\\w+)*\\}");
    private static final String TOKEN_PREFIX = "#{";
    private static final Map<String, ClassInfo> _javaClassByFlexClassName = new HashMap<String, ClassInfo>();
    private static final ConcurrentHashMap<String, Unmarshaller> _jaxbUnmarshallerByType = new ConcurrentHashMap();

    public ExtensionObjectParser(List<ClassInfo> list) {
        for (ClassInfo classInfo : list) {
            _javaClassByFlexClassName.put(classInfo.flexClassname, classInfo);
        }
    }

    public void initialize() {
        ExtensionManager.getInstance().setExtensionObjectParser((IExtensionObjectParser)this);
    }

    public void parse(ExtensionPointInfo extensionPointInfo, Iterable<ExtensionInfo> iterable) {
        if (extensionPointInfo == null || extensionPointInfo.getObjectType() == null || !_javaClassByFlexClassName.containsKey(extensionPointInfo.getObjectType())) {
            return;
        }
        ClassInfo classInfo = _javaClassByFlexClassName.get(extensionPointInfo.getObjectType());
        for (ExtensionInfo extensionInfo : iterable) {
            String string = extensionInfo.getId();
            if (extensionInfo.object != null) continue;
            PluginInfo pluginInfo = ExtensionManager.getInstance().getPluginInfo(extensionInfo.getPluginRef());
            String string2 = ExtensionObjectParser.resolveObjectXml(extensionInfo, pluginInfo.getDefaultBundle());
            if (classInfo.useJaxb) {
                extensionInfo.object = ExtensionObjectParser.deserializeUsingJaxb(extensionPointInfo, string2, classInfo, string);
            } else {
                try {
                    extensionInfo.object = classInfo.clazz.getConstructor(String.class).newInstance(string2);
                }
                catch (Exception exception) {
                    _logger.error((Object)("Error when unmarshalling extension object with id - " + string), (Throwable)exception);
                }
            }
            if (extensionInfo.object == null) continue;
            ExtensionObjectParser.fillValues(extensionInfo);
        }
    }

    private static void fillValues(ExtensionInfo extensionInfo) {
        IPluginRef iPluginRef;
        if (extensionInfo.object instanceof IPluginRef) {
            iPluginRef = (IPluginRef)extensionInfo.object;
            iPluginRef.setPluginRef(extensionInfo.getPluginRef());
        }
        if (extensionInfo.object instanceof IUID && StringUtil.isNullOrEmpty((String)(iPluginRef = (IUID)extensionInfo.object).getUid())) {
            iPluginRef.setUid(extensionInfo.getId());
        }
    }

    private static Unmarshaller createJaxbUnmarshaller(String string, Class<?> clazz) {
        Unmarshaller unmarshaller = null;
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            unmarshaller = jAXBContext.createUnmarshaller();
            Unmarshaller unmarshaller2 = _jaxbUnmarshallerByType.putIfAbsent(string, unmarshaller);
            if (unmarshaller2 != null) {
                unmarshaller = unmarshaller2;
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("Error when creating jaxb unmarshaller for type " + string), (Throwable)exception);
        }
        return unmarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object deserializeUsingJaxb(ExtensionPointInfo extensionPointInfo, String string, ClassInfo classInfo, String string2) {
        Unmarshaller unmarshaller;
        Object object;
        StringReader stringReader;
        block5: {
            stringReader = null;
            object = null;
            unmarshaller = _jaxbUnmarshallerByType.get(extensionPointInfo.getObjectType());
            stringReader = new StringReader(string);
            if (unmarshaller != null || (unmarshaller = ExtensionObjectParser.createJaxbUnmarshaller(extensionPointInfo.getObjectType(), classInfo.clazz)) != null) break block5;
            Object object2 = object;
            StreamUtil.close((Closeable)stringReader);
            return object2;
        }
        try {
            object = unmarshaller.unmarshal((Source)new StreamSource(stringReader));
        }
        catch (JAXBException jAXBException) {
            try {
                _logger.error((Object)("Error when unmarshalling extension object with id - " + string2), (Throwable)jAXBException);
            }
            catch (Throwable throwable) {
                StreamUtil.close(stringReader);
                throw throwable;
            }
            StreamUtil.close((Closeable)stringReader);
        }
        StreamUtil.close((Closeable)stringReader);
        return object;
    }

    private static String resolveObjectXml(ExtensionInfo extensionInfo, String string) {
        String string2 = extensionInfo.getObjectXmlStr();
        try {
            Matcher matcher = RESOURCE_REG_EX_NO_BUNDLE_NAME.matcher(string2);
            HashSet<String> hashSet = new HashSet<String>();
            while (matcher.find()) {
                hashSet.add(matcher.group());
            }
            for (String string3 : hashSet) {
                String string4 = ExtensionObjectParser.resolvePropertyName(string3, string);
                if (StringUtil.isNullOrEmpty((String)string4)) continue;
                string2 = string2.replace(string3, string4);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)("Error when resolving xml for extension - " + extensionInfo.getId()), (Throwable)exception);
        }
        return string2;
    }

    private static String resolvePropertyName(String string, String string2) {
        int n = string.indexOf(TOKEN_PREFIX) + TOKEN_PREFIX.length();
        string = TOKEN_PREFIX + string2 + ":" + string.substring(n);
        return string;
    }
}

