/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.mixed;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class MixedServiceUtil {
    private static final String RESOURCE_BUNDLE_NAME = "MixedService";
    private static final String NAME_PROPERTY = "name";
    private static final ManagedObjectReference DVS_NOT_MAPPED = new ManagedObjectReference(null, null, null);
    private static final Cache<ManagedObjectReference, ManagedObjectReference> VDVS_LOOKUP_CACHE = CacheBuilder.newBuilder().initialCapacity(10).maximumSize(10000L).expireAfterAccess(7L, TimeUnit.DAYS).build();

    public static String getLocalizedString(String string) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)string, (ClassLoader)MixedServiceUtil.class.getClassLoader());
    }

    public static ManagedObjectReference[] replaceDvsEntries(ManagedObjectReference[] managedObjectReferenceArray, Map<ManagedObjectReference, ManagedObjectReference> map) {
        if (map.size() == 0) {
            return managedObjectReferenceArray;
        }
        ManagedObjectReference[] managedObjectReferenceArray2 = new ManagedObjectReference[managedObjectReferenceArray.length];
        for (int i = 0; i < managedObjectReferenceArray.length; ++i) {
            managedObjectReferenceArray2[i] = map.containsKey(managedObjectReferenceArray[i]) ? map.get(managedObjectReferenceArray[i]) : managedObjectReferenceArray[i];
        }
        return managedObjectReferenceArray2;
    }

    public static Map<ManagedObjectReference, ManagedObjectReference> getDvsLookups(DataService dataService, ManagedObjectReference ... managedObjectReferenceArray) {
        ManagedObjectReference managedObjectReference;
        if (managedObjectReferenceArray == null || managedObjectReferenceArray.length == 0) {
            return Collections.emptyMap();
        }
        LinkedList<ManagedObjectReference> linkedList = new LinkedList<ManagedObjectReference>();
        String string = DistributedVirtualSwitch.class.getSimpleName();
        for (ManagedObjectReference managedObjectReference22 : managedObjectReferenceArray) {
            if (managedObjectReference22 == null || !managedObjectReference22.getType().equals(string)) continue;
            linkedList.add(managedObjectReference22);
        }
        if (linkedList.size() == 0) {
            return Collections.emptyMap();
        }
        HashSet hashSet = new HashSet(linkedList.size());
        HashMap<ManagedObjectReference, ManagedObjectReference> hashMap = new HashMap<ManagedObjectReference, ManagedObjectReference>();
        for (ManagedObjectReference managedObjectReference2 : linkedList) {
            managedObjectReference = (ManagedObjectReference)VDVS_LOOKUP_CACHE.getIfPresent((Object)managedObjectReference2);
            if (managedObjectReference == null) {
                hashSet.add(managedObjectReference2);
            }
            if (DVS_NOT_MAPPED == managedObjectReference) continue;
            hashMap.put(managedObjectReference2, managedObjectReference);
        }
        QuerySpec querySpec = MixedServiceUtil.buildDvsValidationSpec(hashSet);
        QuerySpec[] querySpecArray = new QuerySpec[]{querySpec};
        managedObjectReference = new RequestSpec();
        managedObjectReference.querySpec = querySpecArray;
        Response response = dataService.getData((RequestSpec)managedObjectReference);
        if (response == null || response.resultSet.length == 0) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                ManagedObjectReference managedObjectReference3 = (ManagedObjectReference)iterator.next();
                VDVS_LOOKUP_CACHE.put((Object)managedObjectReference3, (Object)DVS_NOT_MAPPED);
            }
            return hashMap;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            ManagedObjectReference managedObjectReference4 = (ManagedObjectReference)iterator.next();
            ManagedObjectReference managedObjectReference5 = MixedServiceUtil.findCorrespondingEntityInResults(managedObjectReference4, response.resultSet);
            if (managedObjectReference5 != null) {
                hashMap.put(managedObjectReference4, managedObjectReference5);
                VDVS_LOOKUP_CACHE.put((Object)managedObjectReference4, (Object)managedObjectReference5);
                continue;
            }
            VDVS_LOOKUP_CACHE.put((Object)managedObjectReference4, (Object)DVS_NOT_MAPPED);
        }
        return hashMap;
    }

    private static ManagedObjectReference findCorrespondingEntityInResults(ManagedObjectReference managedObjectReference, ResultSet[] resultSetArray) {
        String string = managedObjectReference.getValue();
        for (ResultSet resultSet : resultSetArray) {
            for (ResultItem resultItem : resultSet.items) {
                ManagedObjectReference managedObjectReference2 = (ManagedObjectReference)resultItem.resourceObject;
                if (!managedObjectReference2.getValue().equals(string)) continue;
                if (managedObjectReference2.getServerGuid().equals(managedObjectReference.getServerGuid())) {
                    // empty if block
                }
                return managedObjectReference2;
            }
        }
        return null;
    }

    private static QuerySpec buildDvsValidationSpec(Collection<ManagedObjectReference> collection) {
        ManagedObjectReference managedObjectReference2;
        QuerySpec querySpec = new QuerySpec();
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.conjoiner = Conjoiner.OR;
        ArrayList<ObjectIdentityConstraint> arrayList = new ArrayList<ObjectIdentityConstraint>();
        for (ManagedObjectReference managedObjectReference2 : collection) {
            ManagedObjectReference managedObjectReference3 = new ManagedObjectReference(VmwareDistributedVirtualSwitch.class.getSimpleName(), managedObjectReference2.getValue(), managedObjectReference2.getServerGuid());
            ObjectIdentityConstraint objectIdentityConstraint = new ObjectIdentityConstraint();
            objectIdentityConstraint.target = managedObjectReference3;
            objectIdentityConstraint.targetType = VmwareDistributedVirtualSwitch.class.getSimpleName();
            arrayList.add(objectIdentityConstraint);
        }
        ResourceSpec resourceSpec = new ResourceSpec();
        compositeConstraint.nestedConstraints = arrayList.toArray(new Constraint[0]);
        resourceSpec.constraint = compositeConstraint;
        managedObjectReference2 = new PropertySpec();
        managedObjectReference2.propertyNames = new String[]{NAME_PROPERTY};
        resourceSpec.propertySpecs = new PropertySpec[]{managedObjectReference2};
        querySpec.resourceSpec = resourceSpec;
        return querySpec;
    }
}

