/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.mixed.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.Network;
import com.vmware.vim.binding.vim.OpaqueNetwork;
import com.vmware.vim.binding.vim.ResourceConfigSpec;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.ValidationResult;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.common.util.RpUtil;
import com.vmware.vsphere.client.mixed.DefaultHwVersionSpec;
import com.vmware.vsphere.client.mixed.HostSpec;
import com.vmware.vsphere.client.mixed.ManagedEntityExtendedNameInfo;
import com.vmware.vsphere.client.mixed.ManagedEntityMoveSpec;
import com.vmware.vsphere.client.mixed.ManagedEntityNameInfo;
import com.vmware.vsphere.client.rp.ResourcePoolSpec;
import java.util.ArrayList;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedEntityMutationProvider
implements MutationProvider {
    private static final String RESOURCE_BUNDLE_NAME = "ManagedEntityService";
    private static final String VM_FOLDER = "VirtualMachineFolder";
    private static final String HOST_FOLDER = "HostFolder";
    private static final String DATASTORE_FOLDER = "DatastoreFolder";
    private static final String NETWORK_FOLDER = "NetworkFolder";
    private static final String NAME_PROPERTY = "name";
    private static final String COMPUTE_RESOURCE_PROPERTY = "parent";
    private static final Log _logger = LogFactory.getLog(ManagedEntityMutationProvider.class);
    private static final String CLUSTER_HA_ENABLED_PROP_NAME = "configurationEx[@type='ClusterConfigInfoEx'].dasConfig.enabled";
    private QueryExecutor queryExecutor;
    private QuerySpecBuilder querySpecBuilder;
    private final TaskMonitor taskMonitor;

    public ManagedEntityMutationProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder, TaskMonitor taskMonitor) {
        this.queryExecutor = queryExecutor;
        this.querySpecBuilder = querySpecBuilder;
        this.taskMonitor = taskMonitor;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, ManagedEntityNameInfo managedEntityNameInfo) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        String string = null;
        try {
            ManagedEntity managedEntity = (ManagedEntity)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
            if (managedEntity == null) {
                string = this.getLocalizedString("error.invalidEntity");
                throw new IllegalArgumentException(string);
            }
            managedEntityNameInfo.name = managedEntityNameInfo.name.trim();
            this.validateEntityName(managedEntityNameInfo.name);
            String string2 = MixedUtil.escapeVimEntityNameSpecialChars((String)managedEntityNameInfo.name);
            operationResult.task = managedEntity.rename(string2);
        }
        catch (Exception exception) {
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return operationResult;
    }

    public ValidationResult validate(ManagedObjectReference managedObjectReference, ManagedEntityExtendedNameInfo managedEntityExtendedNameInfo) {
        Validate.notNull((Object)((Object)managedEntityExtendedNameInfo));
        Validate.notNull((Object)managedEntityExtendedNameInfo.name);
        ValidationResult validationResult = new ValidationResult();
        validationResult.entity = managedObjectReference;
        try {
            String string = managedEntityExtendedNameInfo.name.trim();
            boolean bl = true;
            if (managedEntityExtendedNameInfo.targetType == null) {
                ManagedEntity managedEntity = (ManagedEntity)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
                if (managedEntity == null) {
                    throw new IllegalStateException(this.getLocalizedString("error.invalidEntity"));
                }
                if (!managedEntity.getName().equals(string)) {
                    if (ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, DistributedVirtualSwitch.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, VmwareDistributedVirtualSwitch.class)) {
                        bl = this.validateDistributedSwitchRename(managedObjectReference, string);
                    } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, DistributedVirtualPortgroup.class)) {
                        bl = this.validateDistributedVirtualPortgroupRename(managedObjectReference, string);
                    } else if (managedEntity instanceof ResourcePool) {
                        ManagedObjectReference managedObjectReference2;
                        if (managedEntity instanceof VirtualApp && (managedObjectReference2 = ((VirtualApp)managedEntity).getParentFolder()) != null) {
                            bl = this.isNameUniqueWithinParentFolder(managedObjectReference2, string);
                        }
                        bl = bl && this.isResourcePoolNameUniqueWithinParentResourcePool(managedEntity.getParent(), string);
                    } else if (managedEntity instanceof Datastore) {
                        ManagedObjectReference managedObjectReference3 = (ManagedObjectReference)this.queryExecutor.getProperty((Object)managedObjectReference, "dc");
                        bl = this.isDatastoreNameUniqueWithinDatacenter(managedObjectReference3, string);
                    } else {
                        bl = this.isNameUniqueWithinParentFolder(managedEntity.getParent(), string);
                    }
                }
            } else {
                ManagedObjectReference managedObjectReference4 = null;
                if (ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, Folder.class)) {
                    managedObjectReference4 = managedObjectReference;
                } else if (ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, Datacenter.class)) {
                    managedObjectReference4 = this.getDatacenterFolderOfType(managedObjectReference, managedEntityExtendedNameInfo.targetType);
                } else {
                    throw new IllegalArgumentException("Folder can be created only under Folder or Datacenter");
                }
                bl = this.isNameUniqueWithinParentFolder(managedObjectReference4, string);
            }
            validationResult.result = bl;
        }
        catch (Exception exception) {
            validationResult.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return validationResult;
    }

    private boolean validateDistributedSwitchRename(ManagedObjectReference managedObjectReference, String string) throws Exception {
        ResultSet resultSet;
        ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)managedObjectReference);
        QuerySpec querySpec = this.querySpecBuilder.buildQuerySpec((Constraint)objectIdentityConstraint, new String[]{"dvsNameExists"});
        if (querySpec.resourceSpec.propertySpecs[0] != null) {
            querySpec.resourceSpec.propertySpecs[0].type = managedObjectReference.getType();
            resultSet = new ParameterSpec();
            resultSet.parameter = string;
            resultSet.propertyName = "dvsNameExists";
            querySpec.resourceSpec.propertySpecs[0].parameters = new ParameterSpec[]{resultSet};
        }
        if ((resultSet = this.queryExecutor.getData(querySpec)) == null) {
            _logger.warn((Object)"DVS name uniquness check returned null. Assuming name is unique!");
        } else if (!ArrayUtil.isNullOrEmpty((Object[])resultSet.items) && !ArrayUtil.isNullOrEmpty((Object[])resultSet.items[0].properties) && Boolean.TRUE.equals(resultSet.items[0].properties[0].value)) {
            return false;
        }
        return true;
    }

    private boolean validateDistributedVirtualPortgroupRename(ManagedObjectReference managedObjectReference, String string) throws Exception {
        ObjectIdentityConstraint objectIdentityConstraint = QueryUtil.createObjectIdentityConstraint((Object)managedObjectReference);
        RelationalConstraint relationalConstraint = QueryUtil.createRelationalConstraint((String)"parentFolder", (Constraint)objectIdentityConstraint, (Boolean)true, (String)Folder.class.getSimpleName());
        RelationalConstraint relationalConstraint2 = QueryUtil.createRelationalConstraint((String)"dvpg", (Constraint)relationalConstraint, (Boolean)true, (String)DistributedVirtualPortgroup.class.getSimpleName());
        PropertyConstraint propertyConstraint = QueryUtil.createPropertyConstraint((String)DistributedVirtualPortgroup.class.getSimpleName(), (String)NAME_PROPERTY, (Comparator)Comparator.EQUALS, (Object)string);
        CompositeConstraint compositeConstraint = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{relationalConstraint2, propertyConstraint}, (Conjoiner)Conjoiner.AND);
        ResultSet resultSet = this.queryExecutor.getData(this.querySpecBuilder.buildQuerySpec((Constraint)compositeConstraint, new String[0]));
        if (resultSet.error != null) {
            throw resultSet.error;
        }
        return ArrayUtil.isNullOrEmpty((Object[])resultSet.items) || resultSet.items.length > 1 || ManagedObjectUtil.areEqual((ManagedObjectReference)((ManagedObjectReference)resultSet.items[0].resourceObject), (ManagedObjectReference)managedObjectReference) != false;
    }

    private boolean isNameUniqueWithinParentFolder(ManagedObjectReference managedObjectReference, String string) throws Exception {
        PropertyValue[] propertyValueArray;
        if (managedObjectReference == null) {
            return true;
        }
        boolean bl = true;
        for (PropertyValue propertyValue : propertyValueArray = this.queryExecutor.getPropertyForRelatedObjects((Object)managedObjectReference, "childEntity", null, NAME_PROPERTY)) {
            if (!string.equals(propertyValue.value)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean isDatastoreNameUniqueWithinDatacenter(ManagedObjectReference managedObjectReference, String string) throws Exception {
        PropertyConstraint propertyConstraint;
        Constraint constraint = this.querySpecBuilder.createConstraintForRelationship((Object)managedObjectReference, "datastore", Datastore.class.getSimpleName());
        QuerySpec querySpec = this.querySpecBuilder.buildQuerySpec(this.querySpecBuilder.combineIntoSingleConstraint(new Constraint[]{constraint, propertyConstraint = this.querySpecBuilder.createPropertyConstraint(Datastore.class.getSimpleName(), NAME_PROPERTY, Comparator.EQUALS, (Object)string)}, Conjoiner.AND), new String[]{NAME_PROPERTY});
        ResultSet resultSet = this.queryExecutor.getData(querySpec);
        if (resultSet != null && resultSet.items != null) {
            for (ResultItem resultItem : resultSet.items) {
                if (resultItem.properties == null) continue;
                for (PropertyValue propertyValue : resultItem.properties) {
                    if (!NAME_PROPERTY.equals(propertyValue.propertyName) || !string.equals(propertyValue.value)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isResourcePoolNameUniqueWithinParentResourcePool(ManagedObjectReference managedObjectReference, Object object) throws Exception {
        ObjectIdentityConstraint objectIdentityConstraint = this.querySpecBuilder.createObjectIdentityConstraint((Object)managedObjectReference);
        RelationalConstraint relationalConstraint = this.querySpecBuilder.createRelationalConstraint(COMPUTE_RESOURCE_PROPERTY, (Constraint)objectIdentityConstraint, Boolean.valueOf(false), ResourcePool.class.getSimpleName());
        Constraint constraint = this.querySpecBuilder.combineIntoSingleConstraint(new Constraint[]{relationalConstraint}, Conjoiner.AND);
        QuerySpec querySpec = this.querySpecBuilder.buildQuerySpec(constraint, new String[]{NAME_PROPERTY});
        ResultSet resultSet = this.queryExecutor.getData(querySpec);
        for (ResultItem resultItem : resultSet.items) {
            if (!object.equals(resultItem.properties[0].value)) continue;
            return false;
        }
        return true;
    }

    private ManagedObjectReference getDatacenterFolderOfType(ManagedObjectReference managedObjectReference, String string) throws Exception {
        String string2 = null;
        if (HOST_FOLDER.equals(string)) {
            string2 = "hostFolder";
        } else if (VM_FOLDER.equals(string)) {
            string2 = "vmFolder";
        } else if (DATASTORE_FOLDER.equals(string)) {
            string2 = "datastoreFolder";
        } else if (NETWORK_FOLDER.equals(string)) {
            string2 = "networkFolder";
        } else {
            throw new IllegalArgumentException("Unexpected target type: " + string);
        }
        return (ManagedObjectReference)this.queryExecutor.getProperty((Object)managedObjectReference, string2);
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, ManagedEntityMoveSpec managedEntityMoveSpec) {
        OperationResult operationResult;
        block25: {
            operationResult = new OperationResult();
            operationResult.entity = managedObjectReference;
            String string = null;
            try {
                ManagedEntity managedEntity = (ManagedEntity)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
                if (managedEntity == null || !(managedEntity instanceof Folder) && !(managedEntity instanceof ResourcePool) && !(managedEntity instanceof Datacenter) && !(managedEntity instanceof ClusterComputeResource)) {
                    string = this.getLocalizedString("error.invalidEntity");
                    throw new IllegalArgumentException(string);
                }
                if (managedEntityMoveSpec == null || managedEntityMoveSpec.entities == null || managedEntityMoveSpec.entities.length == 0) {
                    string = this.getLocalizedString("error.invalidMoveSpec");
                    throw new IllegalArgumentException(string);
                }
                String string2 = managedEntityMoveSpec.entities[0].getType();
                if (managedEntity instanceof Folder) {
                    Folder folder = (Folder)managedEntity;
                    operationResult.task = string2.equals(DistributedVirtualSwitch.class.getSimpleName()) || string2.equals(VmwareDistributedVirtualSwitch.class.getSimpleName()) ? folder.moveInto(this.getPortGroups(managedEntityMoveSpec)) : folder.moveInto(managedEntityMoveSpec.entities);
                    break block25;
                }
                if (managedEntity instanceof Datacenter) {
                    Datacenter datacenter = (Datacenter)managedEntity;
                    Folder folder = null;
                    if (string2.equals(VirtualMachine.class.getSimpleName()) || string2.equals(VirtualApp.class.getSimpleName()) || string2.equals(Folder.class.getSimpleName()) && ManagedObjectUtil.isVmFolder((ManagedObjectReference)managedEntityMoveSpec.entities[0])) {
                        folder = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)datacenter.getVmFolder());
                        operationResult.task = folder.moveInto(managedEntityMoveSpec.entities);
                    } else if (string2.equals(Datastore.class.getSimpleName()) || string2.equals(Folder.class.getSimpleName()) && ManagedObjectUtil.isStorageFolder((ManagedObjectReference)managedEntityMoveSpec.entities[0])) {
                        folder = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)datacenter.getDatastoreFolder());
                        operationResult.task = folder.moveInto(managedEntityMoveSpec.entities);
                    } else if (string2.equals(HostSystem.class.getSimpleName()) || string2.equals(ComputeResource.class.getSimpleName()) || string2.equals(ClusterComputeResource.class.getSimpleName()) || string2.equals(Folder.class.getSimpleName()) && ManagedObjectUtil.isHostFolder((ManagedObjectReference)managedEntityMoveSpec.entities[0])) {
                        folder = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)datacenter.getHostFolder());
                        operationResult.task = folder.moveInto(managedEntityMoveSpec.entities);
                    } else if (string2.equals(Network.class.getSimpleName()) || string2.equals(OpaqueNetwork.class.getSimpleName()) || string2.equals(DistributedVirtualSwitch.class.getSimpleName()) || string2.equals(VmwareDistributedVirtualSwitch.class.getSimpleName()) || string2.equals(Folder.class.getSimpleName()) && ManagedObjectUtil.isNetworkFolder((ManagedObjectReference)managedEntityMoveSpec.entities[0])) {
                        folder = (Folder)ManagedObjectUtil.getManagedObject((ManagedObjectReference)datacenter.getNetworkFolder());
                        ManagedObjectReference managedObjectReference2 = managedEntityMoveSpec.entities[0];
                        operationResult.task = managedObjectReference2.getType().equals(DistributedVirtualSwitch.class.getSimpleName()) || managedObjectReference2.getType().equals(VmwareDistributedVirtualSwitch.class.getSimpleName()) ? folder.moveInto(this.getPortGroups(managedEntityMoveSpec)) : folder.moveInto(managedEntityMoveSpec.entities);
                    }
                    break block25;
                }
                if (managedEntity instanceof ResourcePool) {
                    ResourcePool resourcePool = (ResourcePool)managedEntity;
                    resourcePool.moveInto(managedEntityMoveSpec.entities);
                    break block25;
                }
                if (!(managedEntity instanceof ClusterComputeResource)) break block25;
                ClusterComputeResource clusterComputeResource = (ClusterComputeResource)managedEntity;
                Boolean bl = (Boolean)this.queryExecutor.getProperty((Object)managedObjectReference, CLUSTER_HA_ENABLED_PROP_NAME);
                ManagedObjectReference managedObjectReference3 = null;
                if (managedEntityMoveSpec.attributes != null) {
                    ManagedObjectReference managedObjectReference4;
                    if (managedEntityMoveSpec.entities == null || managedEntityMoveSpec.entities.length != 1) {
                        string = this.getLocalizedString("error.incorrectMoveSpec");
                        throw new IllegalArgumentException(string);
                    }
                    ManagedObjectReference managedObjectReference5 = managedEntityMoveSpec.entities[0];
                    ResourcePoolSpec resourcePoolSpec = (ResourcePoolSpec)((Object)managedEntityMoveSpec.attributes[0]);
                    ManagedObjectReference managedObjectReference6 = null;
                    if (resourcePoolSpec != null) {
                        managedObjectReference4 = resourcePoolSpec.parent;
                        ResourcePool resourcePool = (ResourcePool)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference4);
                        String string3 = resourcePoolSpec.name;
                        ResourceConfigSpec resourceConfigSpec = RpUtil.createChildResourcePoolSpec();
                        managedObjectReference6 = resourcePool.createResourcePool(string3, resourceConfigSpec);
                    }
                    managedObjectReference3 = clusterComputeResource.moveHostInto(managedObjectReference5, managedObjectReference6);
                    if (bl != null && bl.booleanValue() || managedObjectReference6 != null) {
                        managedObjectReference4 = null;
                        try {
                            managedObjectReference4 = this.taskMonitor.monitorTask(managedObjectReference3);
                        }
                        catch (Exception exception) {
                            _logger.error((Object)"Error monitoring cluster.moveHostInto task", (Throwable)exception);
                        }
                        if (managedObjectReference6 != null && managedObjectReference4 != null && managedObjectReference4.error != null) {
                            this.remove(managedObjectReference6);
                        }
                    }
                } else {
                    managedObjectReference3 = clusterComputeResource.moveInto(managedEntityMoveSpec.entities);
                    if (bl != null && bl.booleanValue()) {
                        try {
                            this.taskMonitor.monitorTask(managedObjectReference3);
                        }
                        catch (Exception exception) {
                            _logger.error((Object)"Error monitoring cluster.moveHostInto task for drs disabled cluster or not standalone host", (Throwable)exception);
                        }
                    }
                }
                operationResult.task = managedObjectReference3;
            }
            catch (Exception exception) {
                operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
            }
        }
        return operationResult;
    }

    public OperationResult apply(ManagedObjectReference managedObjectReference, DefaultHwVersionSpec defaultHwVersionSpec) {
        OperationResult operationResult;
        block7: {
            operationResult = new OperationResult();
            operationResult.entity = managedObjectReference;
            String string = null;
            try {
                ManagedEntity managedEntity = (ManagedEntity)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
                if (defaultHwVersionSpec == null) {
                    string = this.getLocalizedString("error.invalidHwVersionSpec");
                    throw new IllegalArgumentException(string);
                }
                if (managedEntity instanceof HostSystem) {
                    ManagedObjectReference managedObjectReference2 = (ManagedObjectReference)this.queryExecutor.getProperty((Object)managedObjectReference, COMPUTE_RESOURCE_PROPERTY);
                    if (managedObjectReference2 == null) {
                        string = ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)"error.computeResourceForHost", (String[])new String[]{managedObjectReference.toString()}, (ClassLoader)this.getClass().getClassLoader());
                        throw new Exception(string);
                    }
                    operationResult.task = this.establishDefaultHwVersionForComputeResource(managedObjectReference2, defaultHwVersionSpec.hwVersionKey);
                    break block7;
                }
                if (managedEntity instanceof ClusterComputeResource) {
                    operationResult.task = this.establishDefaultHwVersionForComputeResource(managedObjectReference, defaultHwVersionSpec.hwVersionKey);
                    break block7;
                }
                if (managedEntity instanceof Datacenter) {
                    Datacenter datacenter = (Datacenter)managedEntity;
                    Datacenter.ConfigSpec configSpec = new Datacenter.ConfigSpec();
                    configSpec.defaultHardwareVersionKey = defaultHwVersionSpec.hwVersionKey;
                    operationResult.task = datacenter.reconfigure(configSpec, true);
                    break block7;
                }
                string = this.getLocalizedString("error.invalidHwVersionEntity");
                throw new IllegalArgumentException(string);
            }
            catch (Exception exception) {
                operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
            }
        }
        return operationResult;
    }

    public OperationResult remove(ManagedObjectReference managedObjectReference) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = managedObjectReference;
        try {
            ManagedEntity managedEntity = (ManagedEntity)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
            if (managedEntity == null) {
                String string = this.getLocalizedString("error.invalidEntity");
                throw new IllegalArgumentException(string);
            }
            operationResult.task = managedEntity.destroy();
        }
        catch (Exception exception) {
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return operationResult;
    }

    public OperationResult remove(ManagedObjectReference managedObjectReference, HostSpec hostSpec) {
        OperationResult operationResult = new OperationResult();
        operationResult.entity = hostSpec.hostRef;
        try {
            ManagedObjectReference managedObjectReference2 = ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference, ComputeResource.class) ? managedObjectReference : hostSpec.hostRef;
            ManagedEntity managedEntity = (ManagedEntity)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference2);
            if (managedEntity == null) {
                String string = this.getLocalizedString("error.invalidEntity");
                throw new IllegalArgumentException(string);
            }
            operationResult.task = managedEntity.destroy();
        }
        catch (Exception exception) {
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return operationResult;
    }

    private void validateEntityName(String string) throws Exception {
        String string2 = null;
        if (string == null || string.length() == 0) {
            string2 = this.getLocalizedString("error.invalidManagedEntityName");
            throw new IllegalArgumentException(string2);
        }
    }

    private String getLocalizedString(String string) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)string, (ClassLoader)this.getClass().getClassLoader());
    }

    private Object establishDefaultHwVersionForComputeResource(ManagedObjectReference managedObjectReference, String string) throws Exception {
        ComputeResource computeResource = (ComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
        ComputeResource.ConfigSpec configSpec = new ComputeResource.ConfigSpec();
        configSpec.defaultHardwareVersionKey = string;
        ManagedObjectReference managedObjectReference2 = computeResource.reconfigureEx(configSpec, true);
        return managedObjectReference2;
    }

    private ManagedObjectReference[] getPortGroups(ManagedEntityMoveSpec managedEntityMoveSpec) throws Exception {
        ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
        for (int i = 0; i < managedEntityMoveSpec.entities.length; ++i) {
            DistributedVirtualSwitch distributedVirtualSwitch = (DistributedVirtualSwitch)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedEntityMoveSpec.entities[i]);
            arrayList.add(managedEntityMoveSpec.entities[i]);
            ManagedObjectReference[] managedObjectReferenceArray = distributedVirtualSwitch.getPortgroup();
            for (int j = 0; j < managedObjectReferenceArray.length; ++j) {
                arrayList.add(managedObjectReferenceArray[j]);
            }
        }
        ManagedObjectReference[] managedObjectReferenceArray = new ManagedObjectReference[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            managedObjectReferenceArray[i] = (ManagedObjectReference)arrayList.get(i);
        }
        return managedObjectReferenceArray;
    }
}

