/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.navigator.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.concurrent.QueuingCachedThreadPool;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vsphere.client.navigator.ChildrenMetadataSpec;
import com.vmware.vsphere.client.navigator.NavigatorService;
import com.vmware.vsphere.client.navigator.ObjectChainElement;
import com.vmware.vsphere.client.navigator.PathQueryResultSet;
import com.vmware.vsphere.client.navigator.PathQuerySpec;
import com.vmware.vsphere.client.navigator.PathToTheRootSpec;
import com.vmware.vsphere.client.navigator.QuerySpecChainElement;
import com.vmware.vsphere.client.navigator.impl.ParentInTreeQueryCreator;
import com.vmware.vsphere.client.navigator.impl.PathRetriever;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NavigatorServiceImpl
implements NavigatorService {
    private static final Log _logger = LogFactory.getLog(NavigatorServiceImpl.class);
    private static final int DEFAULT_POOL_SIZE = 10;
    private static final int MAXIMUM_PATH_LENGTH = 1024;
    private final DataService _dataService;
    private final ExecutorService _executor;

    public NavigatorServiceImpl(DataService dataService) {
        this._dataService = dataService;
        this._executor = ThreadPoolFactory.newQueingCachedThreadPool((int)10, (ThreadFactory)new WorkerThreadFactory("navigator-service-pool"), (long)10L, (TimeUnit)TimeUnit.SECONDS, (long)1L, (TimeUnit)TimeUnit.MINUTES, (QueuingCachedThreadPool.TaskExpirationPolicy)QueuingCachedThreadPool.TaskExpirationPolicy.CALLER_RUNS);
    }

    @Override
    public Object[] getPathToTheRoot(PathToTheRootSpec pathToTheRootSpec) {
        Object object = pathToTheRootSpec.object;
        ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
        while (object != null && arrayList.size() < 1024) {
            arrayList.add((ManagedObjectReference)object);
            Object object2 = this.getParent((ManagedObjectReference)object, pathToTheRootSpec.currentTreeViewId);
            if (object.equals(object2)) break;
            object = object2;
        }
        Collections.reverse(arrayList);
        return arrayList.toArray(new Object[0]);
    }

    @Override
    public Map<String, Object> getParents(ChildrenMetadataSpec childrenMetadataSpec) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (childrenMetadataSpec.children == null) {
            return hashMap;
        }
        for (int i = 0; i < childrenMetadataSpec.children.length; ++i) {
            ManagedObjectReference managedObjectReference = childrenMetadataSpec.children[i];
            String string = childrenMetadataSpec.childrenIds[i];
            Object object = this.getParent(managedObjectReference, childrenMetadataSpec.currentTreeViewId);
            if (object == null) continue;
            hashMap.put(string, object);
        }
        return hashMap;
    }

    @Override
    public PathQueryResultSet[] queryObjectPath(PathQuerySpec[] pathQuerySpecArray) {
        if (pathQuerySpecArray == null || pathQuerySpecArray.length < 1) {
            return PathQueryResultSet.EMPTYSET;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Map<Callable<PathQueryResultSet>, PathQuerySpec> map = this.getPendingTasks(pathQuerySpecArray, SessionUtil.getHttpRequest());
        HashMap<Future<PathQueryResultSet>, PathQuerySpec> hashMap = new HashMap<Future<PathQueryResultSet>, PathQuerySpec>(map.size());
        try {
            for (Callable<PathQueryResultSet> object : map.keySet()) {
                hashMap.put(this._executor.submit(object), map.get(object));
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"Some exception in submitting tasks", (Throwable)exception);
            return PathQueryResultSet.EMPTYSET;
        }
        Object object = this.queryObjectPathSingle(pathQuerySpecArray[0]);
        arrayList.add(object);
        for (Future future : hashMap.keySet()) {
            try {
                object = (PathQueryResultSet)future.get();
            }
            catch (Exception exception) {
                _logger.error((Object)("Error executing PathQuery for " + ((PathQuerySpec)hashMap.get((Object)future)).id), (Throwable)exception);
                object = new PathQueryResultSet();
                ((PathQueryResultSet)object).error = exception;
            }
            arrayList.add(object);
        }
        return arrayList.toArray(new PathQueryResultSet[0]);
    }

    private Map<Callable<PathQueryResultSet>, PathQuerySpec> getPendingTasks(PathQuerySpec[] pathQuerySpecArray, final HttpServletRequest httpServletRequest) {
        HashMap<Callable<PathQueryResultSet>, PathQuerySpec> hashMap = new HashMap<Callable<PathQueryResultSet>, PathQuerySpec>(pathQuerySpecArray.length - 1);
        for (int i = 1; i < pathQuerySpecArray.length; ++i) {
            final PathQuerySpec pathQuerySpec = pathQuerySpecArray[i];
            Callable<PathQueryResultSet> callable = new Callable<PathQueryResultSet>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public PathQueryResultSet call() throws Exception {
                    try {
                        PathQueryResultSet pathQueryResultSet;
                        SessionUtil.setHttpRequest((HttpServletRequest)httpServletRequest);
                        PathQueryResultSet pathQueryResultSet2 = pathQueryResultSet = NavigatorServiceImpl.this.queryObjectPathSingle(pathQuerySpec);
                        return pathQueryResultSet2;
                    }
                    finally {
                        SessionUtil.setHttpRequest(null);
                    }
                }
            };
            hashMap.put(callable, pathQuerySpec);
        }
        return hashMap;
    }

    private PathQueryResultSet queryObjectPathSingle(PathQuerySpec pathQuerySpec) {
        PathQueryResultSet pathQueryResultSet = new PathQueryResultSet();
        pathQueryResultSet.pathQuerySpecId = pathQuerySpec.id;
        Object object = pathQuerySpec.object;
        QuerySpecChainElement querySpecChainElement = pathQuerySpec.querySpecChain;
        if (object == null || querySpecChainElement == null) {
            return null;
        }
        _logger.debug((Object)("Start queryObjectPath for " + pathQuerySpec.id));
        ObjectChainElement[] objectChainElementArray = null;
        try {
            PathRetriever pathRetriever = new PathRetriever();
            pathRetriever.dataService = this._dataService;
            objectChainElementArray = pathRetriever.queryObjectPath(object, querySpecChainElement);
        }
        catch (Exception exception) {
            _logger.error((Object)("Unable to determine path for " + object.toString()), (Throwable)exception);
            pathQueryResultSet.error = exception;
        }
        _logger.debug((Object)("End queryObjectPath for " + pathQuerySpec.id));
        pathQueryResultSet.paths = objectChainElementArray;
        return pathQueryResultSet;
    }

    private Object getParent(ManagedObjectReference managedObjectReference, String string) {
        String string2 = managedObjectReference.getType();
        Object object = null;
        if ("ResourcePool".equals(string2) || "VirtualApp".equals(string2)) {
            object = this.getRpParent(managedObjectReference, string);
        } else if ("VirtualMachine".equals(string2)) {
            object = this.getVmParent(managedObjectReference, string);
        } else if ("HostSystem".equals(string2)) {
            object = this.getHostParent(managedObjectReference);
        } else if ("ClusterComputeResource".equals(string2)) {
            object = this.getClusterParent(managedObjectReference);
        } else if ("Folder".equals(string2) || "Datastore".equals(string2) || "StoragePod".equals(string2) || "Network".equals(string2) || "OpaqueNetwork".equals(string2) || "DistributedVirtualSwitch".equals(string2) || "VmwareDistributedVirtualSwitch".equals(string2)) {
            object = this.getFolderParent(managedObjectReference);
        } else if ("Datacenter".equals(string2)) {
            object = this.getDatacenterParent(managedObjectReference);
        } else if ("DistributedVirtualPortgroup".equals(string2)) {
            object = this.getDvpgParent(managedObjectReference);
        }
        return object;
    }

    private Object getVmParent(ManagedObjectReference managedObjectReference, String string) {
        int n = 0;
        QuerySpec[] querySpecArray = new QuerySpec[]{ParentInTreeQueryCreator.vmParentQuery(managedObjectReference, string, n++)};
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecArray;
        Response response = null;
        Object object = null;
        while (querySpecArray[0] != null && (object = this.getFirstResultIfAvailable(response = this._dataService.getData(requestSpec))) == null) {
            querySpecArray[0] = ParentInTreeQueryCreator.vmParentQuery(managedObjectReference, string, n++);
        }
        return object;
    }

    private Object getHostParent(ManagedObjectReference managedObjectReference) {
        QuerySpec[] querySpecArray = new QuerySpec[]{ParentInTreeQueryCreator.hostParentFirstQuery(managedObjectReference)};
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecArray;
        Response response = this._dataService.getData(requestSpec);
        Object object = this.getFirstResultIfAvailable(response);
        if (object != null) {
            return object;
        }
        querySpecArray[0] = ParentInTreeQueryCreator.hostParentSecondQuery(managedObjectReference);
        response = this._dataService.getData(requestSpec);
        object = this.getFirstResultIfAvailable(response);
        if (object != null) {
            return object;
        }
        querySpecArray[0] = ParentInTreeQueryCreator.hostParentThirdQuery(managedObjectReference);
        response = this._dataService.getData(requestSpec);
        object = this.getFirstResultIfAvailable(response);
        return object;
    }

    private Object getRpParent(Object object, String string) {
        int n = 0;
        QuerySpec[] querySpecArray = new QuerySpec[]{ParentInTreeQueryCreator.rpParentQuery(object, string, n++)};
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecArray;
        Response response = null;
        Object object2 = null;
        while (querySpecArray[0] != null && (object2 = this.getFirstResultIfAvailable(response = this._dataService.getData(requestSpec))) == null) {
            querySpecArray[0] = ParentInTreeQueryCreator.rpParentQuery(object, string, n++);
        }
        return object2;
    }

    private Object getClusterParent(Object object) {
        QuerySpec[] querySpecArray = new QuerySpec[]{ParentInTreeQueryCreator.clusterParentFirstQuery(object)};
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecArray;
        Response response = this._dataService.getData(requestSpec);
        Object object2 = this.getFirstResultIfAvailable(response);
        if (object2 != null) {
            return object2;
        }
        querySpecArray[0] = ParentInTreeQueryCreator.clusterParentSecondQuery(object);
        response = this._dataService.getData(requestSpec);
        object2 = this.getFirstResultIfAvailable(response);
        return object2;
    }

    private Object getFolderParent(Object object) {
        QuerySpec[] querySpecArray = new QuerySpec[]{ParentInTreeQueryCreator.folderParentFirstQuery(object)};
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecArray;
        Response response = this._dataService.getData(requestSpec);
        Object object2 = this.getFirstResultIfAvailable(response);
        if (object2 != null && !object2.equals(object)) {
            return object2;
        }
        querySpecArray[0] = ParentInTreeQueryCreator.folderParentSecondQuery(object);
        response = this._dataService.getData(requestSpec);
        object2 = this.getFirstResultIfAvailable(response);
        if (object.equals(object2)) {
            return null;
        }
        return object2;
    }

    private Object getDatacenterParent(Object object) {
        QuerySpec[] querySpecArray = new QuerySpec[]{ParentInTreeQueryCreator.datacenterParentQuery(object)};
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecArray;
        Response response = this._dataService.getData(requestSpec);
        Object object2 = this.getFirstResultIfAvailable(response);
        return object2;
    }

    private Object getDvpgParent(Object object) {
        int n = 0;
        QuerySpec[] querySpecArray = new QuerySpec[]{ParentInTreeQueryCreator.dvpgParent(object, n++)};
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = querySpecArray;
        Response response = null;
        Object object2 = null;
        while (querySpecArray[0] != null && (object2 = this.getFirstResultIfAvailable(response = this._dataService.getData(requestSpec))) == null) {
            querySpecArray[0] = ParentInTreeQueryCreator.dvpgParent(object, n++);
        }
        return object2;
    }

    private Object getFirstResultIfAvailable(Response response) {
        ResultSet[] resultSetArray = response.resultSet;
        if (resultSetArray.length > 0) {
            ResultSet resultSet = resultSetArray[0];
            if (resultSet.items.length > 0) {
                ResultItem resultItem = resultSet.items[0];
                if (resultItem.properties != null && resultItem.properties.length > 0) {
                    return resultItem.properties[0].value;
                }
                return resultItem.resourceObject;
            }
        }
        return null;
    }
}

