/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.task.impl;

import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.cluster.ConfigInfoEx;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.ObjectReferenceService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.mixed.ManagedEntityParentLocator;
import com.vmware.vsphere.client.mixed.MixedServiceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientTaskInfoPostProcessor {
    private static final String ROOT_FOLDER_NAME = "rootFolder";
    private static final Log _logger = LogFactory.getLog(ClientTaskInfoPostProcessor.class);
    private final ManagedEntityParentLocator parentLocator;
    private final DataService dataService;
    private final ObjectReferenceService objectReferenceService;

    public ClientTaskInfoPostProcessor(DataService dataService, ManagedEntityParentLocator managedEntityParentLocator, ObjectReferenceService objectReferenceService) {
        this.dataService = dataService;
        this.parentLocator = managedEntityParentLocator;
        this.objectReferenceService = objectReferenceService;
    }

    public List<ClientTaskInfo> process(Collection<ClientTaskInfo> collection, Set<ManagedObjectReference> set) {
        if (set.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<ClientTaskInfo> arrayList = new ArrayList<ClientTaskInfo>();
        ManagedObjectReference[] managedObjectReferenceArray = new ManagedObjectReference[set.size()];
        set.toArray(managedObjectReferenceArray);
        Map<ManagedObjectReference, ManagedObjectReference> map = MixedServiceUtil.getDvsLookups(this.dataService, managedObjectReferenceArray);
        managedObjectReferenceArray = MixedServiceUtil.replaceDvsEntries(managedObjectReferenceArray, map);
        Map<ManagedObjectReference, OperationResult> map2 = this.parentLocator.locateCustomParents(managedObjectReferenceArray);
        HashMap<ManagedObjectReference, ClientTaskInfo> hashMap = new HashMap<ManagedObjectReference, ClientTaskInfo>();
        for (ClientTaskInfo clientTaskInfo : collection) {
            EntityLookupData entityLookupData = this.getEntityData((ManagedObjectReference)clientTaskInfo.entity, clientTaskInfo.entityName, clientTaskInfo.service, map, map2);
            if (entityLookupData.entity != null && entityLookupData.name != null) {
                arrayList.add(clientTaskInfo);
                clientTaskInfo.entity = entityLookupData.entity;
                clientTaskInfo.entityName = entityLookupData.name;
                clientTaskInfo.entityUid = this.objectReferenceService.getUid(clientTaskInfo.entity);
                clientTaskInfo.rootFolderUid = this.objectReferenceService.getUid((Object)ManagedObjectUtil.getRootFolder((String)entityLookupData.entity.getServerGuid()));
            }
            if (entityLookupData.type != null) {
                clientTaskInfo.entityType = entityLookupData.type;
            }
            if (!(clientTaskInfo.result instanceof ManagedObjectReference)) continue;
            EntityLookupData entityLookupData2 = this.getEntityData((ManagedObjectReference)clientTaskInfo.result, clientTaskInfo.resultName, clientTaskInfo.service, map, map2);
            if (entityLookupData2.entity == null) continue;
            if (entityLookupData2.name == null) {
                hashMap.put(entityLookupData2.entity, clientTaskInfo);
            }
            arrayList.add(clientTaskInfo);
            clientTaskInfo.result = entityLookupData2.entity;
            clientTaskInfo.resultName = entityLookupData2.name;
            clientTaskInfo.resultEntityUid = this.objectReferenceService.getUid(clientTaskInfo.result);
            clientTaskInfo.resultType = this.objectReferenceService.getResourceObjectType((Object)entityLookupData2.entity);
        }
        this.setResultEntitiesNames(hashMap);
        return arrayList;
    }

    private void setResultEntitiesNames(Map<ManagedObjectReference, ClientTaskInfo> map) {
        if (!map.isEmpty()) {
            Set<ManagedObjectReference> set = map.keySet();
            PropertyValue[] propertyValueArray = null;
            try {
                propertyValueArray = QueryUtil.getProperty((DataService)this.dataService, (Object[])set.toArray(new Object[set.size()]), (String)"name");
            }
            catch (Exception exception) {
                _logger.warn((Object)"Failed to retrieve names for task result objects", (Throwable)exception);
            }
            if (propertyValueArray != null) {
                for (PropertyValue propertyValue : propertyValueArray) {
                    ClientTaskInfo clientTaskInfo = map.get(propertyValue.resourceObject);
                    clientTaskInfo.resultName = MixedUtil.unescapeVimEntityNameSpecialChars((String)((String)propertyValue.value));
                }
            }
        }
    }

    private EntityLookupData getEntityData(ManagedObjectReference managedObjectReference, String string, String string2, Map<ManagedObjectReference, ManagedObjectReference> map, Map<ManagedObjectReference, OperationResult> map2) {
        ManagedObjectReference managedObjectReference2;
        ManagedObjectReference managedObjectReference3;
        EntityLookupData entityLookupData = new EntityLookupData();
        entityLookupData.entity = managedObjectReference3 = managedObjectReference;
        entityLookupData.name = string;
        if (map.containsKey(managedObjectReference3)) {
            entityLookupData.entity = managedObjectReference3 = map.get(managedObjectReference3);
        }
        if (managedObjectReference3 == null) {
            entityLookupData.name = MixedUtil.unescapeVimEntityNameSpecialChars((String)entityLookupData.name);
            return entityLookupData;
        }
        entityLookupData.type = managedObjectReference3.getType();
        OperationResult operationResult = map2.get(managedObjectReference3);
        if (operationResult != null && operationResult.error != null) {
            entityLookupData.name = MixedUtil.unescapeVimEntityNameSpecialChars((String)entityLookupData.name);
            return entityLookupData;
        }
        ManagedObjectReference managedObjectReference4 = null;
        boolean bl = false;
        if (operationResult != null && this.parentLocator.customParentRelated(managedObjectReference3, managedObjectReference2 = (ManagedObjectReference)operationResult.entity)) {
            if (ComputeResource.class.equals((Object)ManagedObjectUtil.getType((ManagedObjectReference)managedObjectReference2))) {
                managedObjectReference2 = this.getHostFromComputeResource(managedObjectReference2);
            }
            entityLookupData.type = managedObjectReference2.getType();
            if (ManagedObjectUtil.isRootFolder((ManagedObjectReference)managedObjectReference2)) {
                managedObjectReference4 = managedObjectReference2;
            } else {
                entityLookupData.name = (String)operationResult.result;
                entityLookupData.entity = managedObjectReference2;
            }
            bl = true;
        }
        if (!bl) {
            managedObjectReference4 = managedObjectReference3;
        }
        if (managedObjectReference4 != null && ManagedObjectUtil.isRootFolder((ManagedObjectReference)managedObjectReference3)) {
            entityLookupData.type = ROOT_FOLDER_NAME;
            entityLookupData.name = string2;
        }
        entityLookupData.name = MixedUtil.unescapeVimEntityNameSpecialChars((String)entityLookupData.name);
        return entityLookupData;
    }

    private ManagedObjectReference getHostFromComputeResource(ManagedObjectReference managedObjectReference) {
        assert (ComputeResource.class.equals((Object)ManagedObjectUtil.getType((ManagedObjectReference)managedObjectReference)));
        try {
            ComputeResource computeResource = (ComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
            if (!(computeResource.getConfigurationEx() instanceof ConfigInfoEx) && !ArrayUtil.isNullOrEmpty((Object[])computeResource.getHost())) {
                return computeResource.getHost()[0];
            }
            _logger.error((Object)"Did not expect compute resource to be a cluster");
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed to retrieve compute resource from MOR " + managedObjectReference), (Throwable)exception);
        }
        return managedObjectReference;
    }

    static class EntityLookupData {
        public ManagedObjectReference entity;
        public String type;
        public String name;

        EntityLookupData() {
        }
    }
}

