/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.task.impl;

import com.vmware.vim.binding.vim.TaskFilterSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vsphere.client.task.TaskIteratorSpec;
import com.vmware.vsphere.client.task.TaskRegistry;
import com.vmware.vsphere.client.task.impl.ClientTaskFilter;
import com.vmware.vsphere.client.task.impl.ParametrizedMessageException;
import com.vmware.vsphere.client.task.impl.TaskUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="vsphere:Task")
public class ClientTaskInfoProvider
implements DataProviderAdapter {
    private static final long RECENT_TASKS_LIMIT_IN_MILLIS = 600000L;
    private static final Log _logger = LogFactory.getLog(ClientTaskInfoProvider.class);
    private final TaskRegistry _taskRegistry;

    public ClientTaskInfoProvider(TaskRegistry taskRegistry) {
        this._taskRegistry = taskRegistry;
    }

    public Response getData(RequestSpec requestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{requestSpec});
        QuerySpec[] querySpecArray = requestSpec.querySpec;
        ResultSet[] resultSetArray = new ResultSet[querySpecArray.length];
        for (int i = 0; i < querySpecArray.length; ++i) {
            resultSetArray[i] = this.processQuery(querySpecArray[i]);
        }
        Response response = new Response();
        response.resultSet = resultSetArray;
        return response;
    }

    private ResultSet processQuery(QuerySpec querySpec) {
        if (!this.isValidTaskQuery(querySpec)) {
            return null;
        }
        ClientTaskFilter clientTaskFilter = this.getFilter(querySpec);
        List<ClientTaskInfo> list = this.getResults(clientTaskFilter);
        return TaskUtil.createResultSet(list, querySpec);
    }

    private List<ClientTaskInfo> getResults(ClientTaskFilter clientTaskFilter) {
        int n = 50;
        if (clientTaskFilter.getPage() != -1) {
            n = (clientTaskFilter.getPage() + 1) * clientTaskFilter.getPageSize();
        }
        List<Object> list = new ArrayList<ClientTaskInfo>(n);
        Iterator<ClientTaskInfo> iterator = this.getTaskIterator(clientTaskFilter.recentTasksOnly());
        while (iterator.hasNext() && list.size() <= n) {
            ClientTaskInfo clientTaskInfo = iterator.next();
            if (!clientTaskFilter.accepts(clientTaskInfo)) continue;
            list.add(clientTaskInfo);
        }
        if (clientTaskFilter.getPage() != -1) {
            int n2 = clientTaskFilter.getPage() * clientTaskFilter.getPageSize();
            if (n2 > list.size()) {
                return Collections.emptyList();
            }
            int n3 = n2 + clientTaskFilter.getPageSize();
            if (n3 > list.size()) {
                n3 = list.size();
            }
            list = list.subList(n2, n3);
        }
        this.attemptLocalize(list);
        return list;
    }

    private void attemptLocalize(List<ClientTaskInfo> list) {
        assert (list != null);
        if (list.isEmpty()) {
            return;
        }
        ClassLoader classLoader = ClientTaskInfoProvider.class.getClassLoader();
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            ClientTaskInfo clientTaskInfo = list.get(i);
            String string = this.getLocalizedString(clientTaskInfo.description, classLoader);
            String string2 = this.getLocalizedString(clientTaskInfo.details, classLoader);
            String string3 = null;
            if (clientTaskInfo.error != null && (string3 = this.getLocalizedString(clientTaskInfo.error.getMessage(), classLoader)) != null && clientTaskInfo.error instanceof ParametrizedMessageException) {
                object = (ParametrizedMessageException)clientTaskInfo.error;
                string3 = MessageFormat.format(string3, ((ParametrizedMessageException)object).getMessageParameters());
            }
            if (string2 == null && string == null && string3 == null) continue;
            object = (ClientTaskInfo)ObjectUtil.shallowCopy((Object)clientTaskInfo, ClientTaskInfo.class);
            if (string != null) {
                ((ClientTaskInfo)object).description = string;
            }
            if (string2 != null) {
                ((ClientTaskInfo)object).details = string2;
            }
            if (string3 != null) {
                ((ClientTaskInfo)object).error = new MethodFault(string3);
                ((ClientTaskInfo)object).error.setStackTrace(clientTaskInfo.error.getStackTrace());
            }
            list.set(i, (ClientTaskInfo)object);
        }
    }

    private String getLocalizedString(String string, ClassLoader classLoader) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            return null;
        }
        String string2 = ResourceUtil.getString((String)"ClientTask", (String)string, (ClassLoader)classLoader);
        if (string2 != string) {
            return string2;
        }
        return null;
    }

    private Iterator<ClientTaskInfo> getTaskIterator(boolean bl) {
        Long l = null;
        if (bl) {
            long l2 = System.currentTimeMillis();
            long l3 = l2 - 600000L;
            l = l3;
        }
        TaskIteratorSpec taskIteratorSpec = new TaskIteratorSpec(l, null, TaskIteratorSpec.Direction.ASCENDING);
        return this._taskRegistry.iterator(taskIteratorSpec);
    }

    private boolean isValidTaskQuery(QuerySpec querySpec) {
        return querySpec.resourceSpec != null && querySpec.resourceSpec.propertySpecs != null && querySpec.resourceSpec.propertySpecs.length != 0 && querySpec.resourceSpec.propertySpecs[0].propertyNames != null && querySpec.resourceSpec.propertySpecs[0].propertyNames.length != 0 && querySpec.resourceSpec.propertySpecs[0].propertyNames[0].equals("info");
    }

    private ClientTaskFilter getFilter(QuerySpec querySpec) {
        Constraint[] constraintArray;
        ClientTaskFilter clientTaskFilter = new ClientTaskFilter();
        Constraint constraint = querySpec.resourceSpec.constraint;
        if (constraint == null) {
            return clientTaskFilter;
        }
        if (constraint instanceof PropertyConstraint) {
            constraintArray = new PropertyConstraint[]{(PropertyConstraint)constraint};
        } else if (constraint instanceof CompositeConstraint) {
            constraintArray = ((CompositeConstraint)constraint).nestedConstraints;
        } else {
            String string = "Invalid query constraint for task adapter: " + constraint.getClass().getName();
            _logger.error((Object)string);
            throw new IllegalArgumentException(string);
        }
        for (Constraint constraint2 : constraintArray) {
            if (!(constraint2 instanceof PropertyConstraint)) {
                _logger.error((Object)("Invalid query constraint for task adapter: " + constraint2.getClass().getName() + ". Only property constraint accepted."));
                continue;
            }
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint2;
            if (!propertyConstraint.comparator.equals((Object)Comparator.EQUALS)) {
                _logger.error((Object)("Invalid query comparator for task adapter. Expected 'EQUALS' but got '" + propertyConstraint.comparator + "'"));
                continue;
            }
            String string = propertyConstraint.propertyName;
            if (StringUtil.isNullOrEmpty((String)string)) {
                _logger.error((Object)"Property name in PropertyConstraint is null or empty");
                continue;
            }
            if (propertyConstraint.comparableValue == null && this.propertyRequiresComparableValue(string)) {
                _logger.error((Object)("The constraints comparable value is null but the property '" + string + "' requires a non-null target value."));
                continue;
            }
            Object object = propertyConstraint.comparableValue;
            if ("info.initiator".equals(string)) {
                clientTaskFilter.addUserNames((TaskFilterSpec.ByUsername)object);
                continue;
            }
            if ("info.entity".equals(string)) {
                if (object instanceof ManagedObjectReference) {
                    clientTaskFilter.setEntity((ManagedObjectReference)object);
                    continue;
                }
                _logger.error((Object)("Task target type of " + object.getClass().getCanonicalName() + " is not supported."));
                continue;
            }
            if ("info.recentTasks".equals(string)) {
                assert (propertyConstraint.comparableValue instanceof Boolean);
                clientTaskFilter.setRecentTasks((Boolean)propertyConstraint.comparableValue);
                continue;
            }
            if ("info.activeTasks".equals(string)) {
                clientTaskFilter.addTaskStates(TaskState.QUEUED);
                clientTaskFilter.addTaskStates(TaskState.RUNNING);
                continue;
            }
            if ("info.rootTasks".equals(string)) {
                Object[] objectArray;
                for (Object object2 : objectArray = (Object[])object) {
                    clientTaskFilter.addRootTaskKey((String)object2);
                }
                continue;
            }
            if ("info.maxResultsPerSource".equals(string)) {
                clientTaskFilter.setPageSize((Integer)object);
                continue;
            }
            if ("info.currentPage".equals(string)) {
                clientTaskFilter.setPage((Integer)object);
                continue;
            }
            if (string.equals("requestingPrevPage")) continue;
            throw new IllegalArgumentException("Invalid property constraint " + string);
        }
        return clientTaskFilter;
    }

    private boolean propertyRequiresComparableValue(String string) {
        return "info.initiator".equals(string) || "info.entity".equals(string) || "info.rootTasks".equals(string) || "info.maxResultsPerSource".equals(string);
    }
}

