/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.task.impl;

import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.uri.DefaultUriSchemeUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.io.Closeable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public class TaskUtil {
    public static final String TASK_DATASERVICE_TYPE = "Task";
    private static final String RESOURCE_BUNDLE_NAME = "TaskService";
    private static final Map<String, Pair<Future<?>, Closeable>> _taskFutureCloseableMap = new HashMap();

    public static String getLocalizedString(String string) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)string, (ClassLoader)TaskUtil.class.getClassLoader());
    }

    public static String getLocalizedString(String string, String ... stringArray) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)string, (String[])stringArray, (ClassLoader)TaskUtil.class.getClassLoader());
    }

    public static ResultSet createResultSet(List<ClientTaskInfo> list, QuerySpec querySpec) {
        ResultSet resultSet = new ResultSet();
        resultSet.totalMatchedObjectCount = list.size();
        resultSet.items = new ResultItem[list.size()];
        int n = 0;
        for (ClientTaskInfo clientTaskInfo : list) {
            ResultItem resultItem = new ResultItem();
            PropertyValue propertyValue = new PropertyValue();
            propertyValue.propertyName = "info";
            propertyValue.value = clientTaskInfo;
            resultItem.properties = new PropertyValue[]{propertyValue};
            resultItem.resourceObject = clientTaskInfo.taskRef != null ? clientTaskInfo.taskRef : DefaultUriSchemeUtil.createUri((String)TASK_DATASERVICE_TYPE, (String)clientTaskInfo.key);
            resultSet.items[n++] = resultItem;
        }
        return resultSet;
    }

    public static void addClientTaskKeyFutureCloseablePair(String string, Future<?> future, Closeable closeable) {
        _taskFutureCloseableMap.put(string, new Pair(future, (Object)closeable));
    }

    public static Pair<Future<?>, Closeable> getClientTaskFutureCloseablePair(String string) {
        return _taskFutureCloseableMap.get(string);
    }

    public static void removeClientTaskKeyFromMap(String string) {
        _taskFutureCloseableMap.remove(string);
    }
}

