/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.task.messaging;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.PartialUpdateItem;
import com.vmware.vise.vim.commons.messaging.TaskRegistryProcessor;
import com.vmware.vsphere.client.task.TaskIteratorSpec;
import com.vmware.vsphere.client.task.impl.ClientTaskRegistry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientTaskRegistryProcessor
implements TaskRegistryProcessor {
    private static final String DOWNLOADING_LOGS_CLIENT_TASK_TYPE = "DownloadingLogsTask";
    private static final String CLIENT_TASK_UPDATE_PREFIX = "ClientTaskUpdate:";
    private static long CLIENT_TASK_UPDATE_ID_COUNTER = 0L;
    private static final String UPLOADING_FILE_TO_SR_TASK_TYPE = "UploadingFileToSr";
    private static final List<String> DELTA_PROPERTIES = Arrays.asList("state", "progress", "error", "completionTime");
    private static final Log logger = LogFactory.getLog(ClientTaskRegistryProcessor.class);
    private final ClientTaskRegistry _clientTaskRegistry;
    private final Map<String, TaskDetails> _processedClientTasks = new HashMap<String, TaskDetails>();

    public ClientTaskRegistryProcessor(ClientTaskRegistry clientTaskRegistry) {
        this._clientTaskRegistry = clientTaskRegistry;
    }

    public PartialUpdate<ClientTaskInfo> process() {
        Iterator<ClientTaskInfo> iterator = this._clientTaskRegistry.iterator(new TaskIteratorSpec(null, null, TaskIteratorSpec.Direction.ASCENDING));
        PartialUpdate partialUpdate = PartialUpdate.empty();
        long l = 0L;
        if (logger.isDebugEnabled()) {
            l = System.currentTimeMillis();
        }
        HashSet<ManagedObjectReference> hashSet = new HashSet<ManagedObjectReference>();
        while (iterator.hasNext()) {
            PartialUpdateItem partialUpdateItem;
            boolean bl;
            ManagedObjectReference managedObjectReference;
            ClientTaskInfo clientTaskInfo = iterator.next();
            if (clientTaskInfo.taskRef == null || !(clientTaskInfo.taskRef instanceof ManagedObjectReference) || !DOWNLOADING_LOGS_CLIENT_TASK_TYPE.equals((managedObjectReference = (ManagedObjectReference)clientTaskInfo.taskRef).getType()) && !UPLOADING_FILE_TO_SR_TASK_TYPE.equals(managedObjectReference.getType())) continue;
            hashSet.add(managedObjectReference);
            TaskDetails taskDetails = this._processedClientTasks.get(clientTaskInfo.key);
            if (taskDetails == null) {
                taskDetails = new TaskDetails(clientTaskInfo.progress, clientTaskInfo.state, clientTaskInfo.error, (ManagedObjectReference)clientTaskInfo.taskRef);
                bl = false;
            } else {
                if (taskDetails.progress == clientTaskInfo.progress && taskDetails.state == clientTaskInfo.state && taskDetails.error == clientTaskInfo.error) continue;
                taskDetails.progress = clientTaskInfo.progress;
                taskDetails.state = clientTaskInfo.state;
                taskDetails.error = clientTaskInfo.error;
                bl = true;
            }
            this._processedClientTasks.put(clientTaskInfo.key, taskDetails);
            if (bl) {
                partialUpdateItem = PartialUpdateItem.deltaOf((Object)clientTaskInfo, (Object)clientTaskInfo.taskRef);
                partialUpdateItem.deltaProperties = DELTA_PROPERTIES;
            } else {
                partialUpdateItem = PartialUpdateItem.of((Object)clientTaskInfo, (Object)clientTaskInfo.taskRef);
            }
            partialUpdate.updates.add(partialUpdateItem);
        }
        this.deleteExpiredTasks(hashSet, (PartialUpdate<ClientTaskInfo>)partialUpdate);
        if (logger.isDebugEnabled() && partialUpdate.updates.size() > 0) {
            partialUpdate.changeId = CLIENT_TASK_UPDATE_PREFIX + CLIENT_TASK_UPDATE_ID_COUNTER++;
            partialUpdate.timeWhenChangeIsReceived = l;
            partialUpdate.timeWhenUpdateIsPushedToTheStream = System.currentTimeMillis();
        }
        return partialUpdate;
    }

    private void deleteExpiredTasks(Set<ManagedObjectReference> set, PartialUpdate<ClientTaskInfo> partialUpdate) {
        if (set.size() < this._processedClientTasks.size()) {
            for (TaskDetails taskDetails : this._processedClientTasks.values()) {
                if (set.contains(taskDetails.taskReference)) continue;
                partialUpdate.deleted.add(taskDetails.taskReference);
            }
        }
    }

    private static class TaskDetails {
        int progress;
        TaskState state;
        Exception error;
        final ManagedObjectReference taskReference;

        TaskDetails(int n, TaskState taskState, Exception exception, ManagedObjectReference managedObjectReference) {
            this.progress = n;
            this.state = taskState;
            this.error = exception;
            this.taskReference = managedObjectReference;
        }
    }
}

