/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.task.messaging;

import com.google.common.base.Optional;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.messaging.PartialUpdate;
import com.vmware.vise.vim.commons.messaging.PartialUpdateItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DsUtil {
    private QueryExecutor queryExecutor;
    private static final Log _logger = LogFactory.getLog(DsUtil.class);

    public DsUtil(QueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    public PartialUpdate<ClientTaskInfo> getTasks() {
        Optional<ResultSet> optional2 = this.execQuery(this.recentTasksQuery());
        PartialUpdate partialUpdate = PartialUpdate.empty();
        if (!optional2.isPresent()) {
            _logger.debug((Object)"DS emtpy tasks");
            return partialUpdate;
        }
        for (ResultItem resultItem : ((ResultSet)optional2.get()).items) {
            for (PropertyValue propertyValue : resultItem.properties) {
                ClientTaskInfo clientTaskInfo = (ClientTaskInfo)propertyValue.value;
                partialUpdate.updates.add(PartialUpdateItem.of((Object)clientTaskInfo, (Object)clientTaskInfo.taskRef));
            }
        }
        return partialUpdate;
    }

    public Optional<ResultSet> execQuery(QuerySpec querySpec) {
        Optional optional2 = Optional.absent();
        try {
            ResultSet resultSet = this.queryExecutor.getData(querySpec);
            optional2 = resultSet == null ? Optional.absent() : Optional.of((Object)resultSet);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return optional2;
    }

    private QuerySpec recentTasksQuery() {
        QuerySpec querySpec = new QuerySpec();
        ResourceSpec resourceSpec = new ResourceSpec();
        PropertySpec propertySpec = new PropertySpec();
        ResultSpec resultSpec = new ResultSpec();
        resultSpec.maxResultCount = -1;
        resultSpec.offset = 0;
        CompositeConstraint compositeConstraint = this.createTaskConstraint();
        compositeConstraint.targetType = "Task";
        resourceSpec.constraint = compositeConstraint;
        propertySpec.propertyNames = new String[]{"info"};
        propertySpec.type = "ManagedEntity";
        resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        querySpec.name = "vsphere:Task!!!!-!!!!info";
        querySpec.resourceSpec = resourceSpec;
        querySpec.resultSpec = resultSpec;
        return querySpec;
    }

    private CompositeConstraint createTaskConstraint() {
        CompositeConstraint compositeConstraint = new CompositeConstraint();
        compositeConstraint.conjoiner = Conjoiner.AND;
        compositeConstraint.targetType = "vsphere:Task";
        compositeConstraint.nestedConstraints = new Constraint[]{this.createPropertyConstraint("info.recentTasks")};
        return compositeConstraint;
    }

    private PropertyConstraint createPropertyConstraint(String string) {
        PropertyConstraint propertyConstraint = new PropertyConstraint();
        propertyConstraint.propertyName = string;
        propertyConstraint.comparableValue = true;
        propertyConstraint.targetType = "vsphere:Task";
        propertyConstraint.comparator = Comparator.EQUALS;
        return propertyConstraint;
    }
}

