/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search;

import com.vmware.vise.core.model.optional;
import com.vmware.vise.search.PassthroughPropertyUnmarshaller;
import com.vmware.vise.search.PropertyInfo;
import com.vmware.vise.search.PropertyUnmarshaller;
import com.vmware.vise.search.ValueEx;
import com.vmware.vise.search.impl.TypeRefUtils;
import com.vmware.vise.search.impl.UnmarshallingUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.reflection.ClassDirectory;
import com.vmware.vise.util.xml.NamespaceUtil;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class JaxbPropertyUnmarshaller
implements PropertyUnmarshaller {
    private final PropertyUnmarshaller _defaultUnmarshaller;
    private final ClassDirectory _packageBindingsDirectory;
    private static final int PACKAGE_BINDINGS_CACHE_SIZE = 100;
    private final ConcurrentMap<String, Class<?>> _classByXmlType = new ConcurrentHashMap();

    public JaxbPropertyUnmarshaller(@optional PropertyUnmarshaller propertyUnmarshaller, @optional Collection<String> collection, @optional ClassLoader classLoader, boolean bl) {
        this._defaultUnmarshaller = propertyUnmarshaller != null ? propertyUnmarshaller : new PassthroughPropertyUnmarshaller();
        ClassDirectory classDirectory = null;
        if (collection != null && !collection.isEmpty()) {
            if (classLoader == null) {
                String string = "Need a classLoader for binding packages";
                throw new IllegalArgumentException(string);
            }
            classDirectory = new ClassDirectory(collection, classLoader, Integer.valueOf(100));
        }
        this._packageBindingsDirectory = classDirectory;
        if (bl) {
            this._classByXmlType.put(TypeRefUtils.BYTE_TYPEREF.getName(), Byte.class);
            this._classByXmlType.put(TypeRefUtils.SHORT_TYPEREF.getName(), Short.class);
            this._classByXmlType.put(TypeRefUtils.INT_TYPEREF.getName(), Integer.class);
            this._classByXmlType.put(TypeRefUtils.LONG_TYPEREF.getName(), Long.class);
            this._classByXmlType.put(TypeRefUtils.FLOAT_TYPEREF.getName(), Float.class);
            this._classByXmlType.put(TypeRefUtils.DOUBLE_TYPEREF.getName(), Double.class);
            this._classByXmlType.put(TypeRefUtils.BOOLEAN_TYPEREF.getName(), Boolean.class);
            this._classByXmlType.put(TypeRefUtils.STRING_TYPEREF.getName(), String.class);
            this._classByXmlType.put(TypeRefUtils.DATETIME_TYPEREF.getName(), Date.class);
        }
    }

    public static JaxbPropertyUnmarshaller newInstance(Collection<String> collection, ClassLoader classLoader) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{collection, classLoader});
        PropertyUnmarshaller propertyUnmarshaller = null;
        boolean bl = true;
        JaxbPropertyUnmarshaller jaxbPropertyUnmarshaller = new JaxbPropertyUnmarshaller(propertyUnmarshaller, collection, classLoader, bl);
        return jaxbPropertyUnmarshaller;
    }

    public static JaxbPropertyUnmarshaller newPrimitiveInstance() {
        PropertyUnmarshaller propertyUnmarshaller = null;
        boolean bl = true;
        List<String> list = Collections.emptyList();
        ClassLoader classLoader = null;
        JaxbPropertyUnmarshaller jaxbPropertyUnmarshaller = new JaxbPropertyUnmarshaller(propertyUnmarshaller, list, classLoader, bl);
        return jaxbPropertyUnmarshaller;
    }

    public void registerJaxbBindingClass(String string, Class<?> clazz) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string, clazz});
        this._classByXmlType.put(string, clazz);
    }

    @Override
    public ValueEx<Object> getValue(PropertyInfo propertyInfo, XMLStreamReader xMLStreamReader) throws XMLStreamException {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyInfo, xMLStreamReader});
        if (xMLStreamReader.getEventType() != 1) {
            throw new IllegalStateException("XMLStreamReader must be at start of element.");
        }
        Class<?> clazz = this.getPropertyType(propertyInfo);
        LinkedList<Exception> linkedList = new LinkedList<Exception>();
        if (propertyInfo.isMultiCardinality()) {
            Object object = this.processCollectionType(propertyInfo, clazz, xMLStreamReader, linkedList);
            return new ValueEx<Object>(object, linkedList);
        }
        Object object = this.unmarshalValue(propertyInfo, clazz, xMLStreamReader, linkedList);
        return new ValueEx<Object>(object, linkedList);
    }

    private Object processCollectionType(PropertyInfo propertyInfo, Class<?> clazz, XMLStreamReader xMLStreamReader, Collection<Exception> collection) throws XMLStreamException {
        Object object;
        Class<?> clazz2;
        assert (propertyInfo != null);
        assert (xMLStreamReader != null);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        QName qName = xMLStreamReader.getName();
        while (xMLStreamReader.getEventType() == 1 && qName.equals(clazz2 = xMLStreamReader.getName())) {
            object = this.unmarshalValue(propertyInfo, clazz, xMLStreamReader, collection);
            arrayList.add(object);
        }
        clazz2 = clazz;
        if (clazz2 == null) {
            clazz2 = Object.class;
        }
        object = Array.newInstance(clazz2, arrayList.size());
        for (int i = 0; i < arrayList.size(); ++i) {
            Array.set(object, i, arrayList.get(i));
        }
        return object;
    }

    private Object unmarshalValue(PropertyInfo propertyInfo, Class<?> clazz, XMLStreamReader xMLStreamReader, Collection<Exception> collection) throws XMLStreamException {
        assert (xMLStreamReader != null);
        if (UnmarshallingUtil.isReferenceProperty(xMLStreamReader)) {
            Object object = UnmarshallingUtil.processReferenceProperty(xMLStreamReader, propertyInfo);
            UnmarshallingUtil.moveReaderUntilStartOrEndElement(xMLStreamReader);
            return object;
        }
        if (clazz == null) {
            ValueEx<Object> valueEx = this._defaultUnmarshaller.getValue(propertyInfo, xMLStreamReader);
            Collection<Exception> collection2 = valueEx.getExceptions();
            collection.addAll(collection2);
            return valueEx.getValue();
        }
        try {
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            JAXBElement jAXBElement = unmarshaller.unmarshal(xMLStreamReader, clazz);
            Object object = jAXBElement.getValue();
            return object;
        }
        catch (JAXBException jAXBException) {
            throw new IllegalStateException(jAXBException.toString());
        }
    }

    private Class<?> getPropertyType(PropertyInfo propertyInfo) {
        assert (propertyInfo != null);
        String string = propertyInfo.getType();
        if (string == null) {
            return null;
        }
        String string2 = NamespaceUtil.getUnqualifiedTypeName((String)string);
        Class clazz = (Class)this._classByXmlType.get(string2);
        if (clazz != null) {
            return clazz;
        }
        if (this._packageBindingsDirectory == null) {
            return null;
        }
        clazz = this._packageBindingsDirectory.getClass(string2);
        return clazz;
    }
}

