/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.auth;

import com.vmware.vise.search.auth.AuthDataRegistry;
import com.vmware.vise.search.auth.internal.AuthDataRegistryImpl;
import com.vmware.vise.util.session.SessionUtil;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.Validate;

public class AuthDataRegistryHelper {
    private static final String SESSION_ATTR_NAME__LOGIN_SPEC_REGISTRY = "LOGIN_SPEC_REGISTRY";

    public static AuthDataRegistry getAuthDataRegistry() {
        AuthDataRegistry authDataRegistry = AuthDataRegistryHelper.getAuthDataRegistry(null);
        return authDataRegistry;
    }

    public static AuthDataRegistry getAuthDataRegistry(HttpSession httpSession) {
        if (httpSession == null) {
            httpSession = SessionUtil.getHttpSession();
        }
        if (httpSession == null) {
            throw new IllegalStateException("Missing HTTP session");
        }
        String string = SessionUtil.getClientId((HttpSession)httpSession);
        return AuthDataRegistryHelper.getAuthDataRegistryByClientId(string);
    }

    public static AuthDataRegistry getAuthDataRegistryByClientId(String string) {
        Validate.notEmpty((String)string, (String)"clientId is required");
        Object object = SessionUtil.getData((String)SESSION_ATTR_NAME__LOGIN_SPEC_REGISTRY, (String)string);
        AuthDataRegistry authDataRegistry = null;
        if (object == null) {
            authDataRegistry = new AuthDataRegistryImpl();
            object = SessionUtil.setDataIfAbsent((String)SESSION_ATTR_NAME__LOGIN_SPEC_REGISTRY, (Object)authDataRegistry, (String)string);
        }
        if (object != null) {
            try {
                authDataRegistry = (AuthDataRegistry)object;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalStateException("Invalid " + AuthDataRegistry.class.getSimpleName() + " in session", classCastException);
            }
        }
        return authDataRegistry;
    }
}

