/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.search.ComparisonOperator;
import com.vmware.vise.search.impl.CompositeConstraintInternal;
import com.vmware.vise.search.impl.ConstraintInternal;
import com.vmware.vise.search.impl.ConstraintUtils;
import com.vmware.vise.search.impl.ConstraintVisitorBase;
import com.vmware.vise.search.impl.EntitySetDescriptor;
import com.vmware.vise.search.impl.ObjectIdentityConstraintInternal;
import com.vmware.vise.search.impl.QueryConstructionContext;
import com.vmware.vise.search.impl.QueryExpr;
import com.vmware.vise.search.impl.QueryExprBase;
import com.vmware.vise.search.impl.RelationalConstraintInternal;
import com.vmware.vise.search.impl.SetExpr;
import com.vmware.vise.search.impl.SimplePropertyConstraintInternal;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.RelationDescriptor;
import com.vmware.vise.search.model.ModelUtils;
import com.vmware.vise.search.util.Strings;
import com.vmware.vise.search.xquery.VarRefExpression;
import com.vmware.vise.search.xquery.XQueryUtils;
import com.vmware.vise.search.xquery.render.ConstraintRenderer;
import com.vmware.vise.search.xquery.render.RendererFactory;
import com.vmware.vise.util.StringUtil;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExpressionTreeBuilderVisitor
extends ConstraintVisitorBase {
    private static final Log _logger = LogFactory.getLog(ExpressionTreeBuilderVisitor.class);
    private final List<EntitySetDescriptor> _entitySetDescriptorList;
    private final MetadataDirectory _metadataDirectory;
    private final RendererFactory _rendererFactory;
    private final String _targetId;

    ExpressionTreeBuilderVisitor(List<EntitySetDescriptor> list, MetadataDirectory metadataDirectory, RendererFactory rendererFactory, Map<ConstraintInternal, ConstraintVisitorBase.VisitContext> map, String string) {
        super(map);
        assert (list != null);
        assert (metadataDirectory != null);
        this._entitySetDescriptorList = list;
        this._metadataDirectory = metadataDirectory;
        this._rendererFactory = rendererFactory;
        this._targetId = !StringUtil.isNullOrEmpty((String)string) ? string : "target";
    }

    @Override
    public void visitCompositeConstraint(CompositeConstraintInternal compositeConstraintInternal) {
        QueryConstructionContext queryConstructionContext = this.createContext(compositeConstraintInternal);
        QueryExpr queryExpr = queryConstructionContext.conditional;
        queryExpr.setConjoiner(compositeConstraintInternal.getConjoiner());
    }

    @Override
    public void visitDefaultConstraint(ConstraintInternal constraintInternal) {
        this.createContext(constraintInternal);
    }

    @Override
    public void visitObjectIdentityConstraint(ObjectIdentityConstraintInternal objectIdentityConstraintInternal) {
        QueryConstructionContext queryConstructionContext = this.createContext(objectIdentityConstraintInternal);
        QueryExpr queryExpr = queryConstructionContext.conditional;
        ConstraintRenderer constraintRenderer = this._rendererFactory.newObjectIdentityConstraintRenderer();
        constraintRenderer.setConstraint(objectIdentityConstraintInternal);
        String string = constraintRenderer.render();
        queryExpr.setExpr(string);
        if (objectIdentityConstraintInternal.getTarget() != null) {
            String string2 = QueryUtil.getReferenceType((Object)objectIdentityConstraintInternal.getTarget());
            queryExpr.setEntityType(string2);
        } else {
            queryExpr.setEntityType(objectIdentityConstraintInternal.getSearchTarget());
        }
    }

    @Override
    public void visitRelationalConstraint(RelationalConstraintInternal relationalConstraintInternal) {
        QueryConstructionContext queryConstructionContext = this.createContext(relationalConstraintInternal);
        RelationDescriptor relationDescriptor = MetadataUtil.getRelationFromSpec(this._metadataDirectory, relationalConstraintInternal.getRelationSpec());
        QueryConstructionContext queryConstructionContext2 = new QueryConstructionContext(queryConstructionContext);
        queryConstructionContext2.constraint = (ConstraintInternal)relationalConstraintInternal.getNestedConstraint();
        EntitySetDescriptor entitySetDescriptor = this.entitySetForRelationshipTarget(relationDescriptor, queryConstructionContext2);
        queryConstructionContext2 = new QueryConstructionContext(queryConstructionContext);
        queryConstructionContext2.constraint = relationalConstraintInternal;
        EntitySetDescriptor entitySetDescriptor2 = this.entitySetForRelationshipSource(relationDescriptor, entitySetDescriptor.id, queryConstructionContext2);
        queryConstructionContext2.conditional.setEntityType(entitySetDescriptor2.getEntityType());
        this.applyEntitySetAsExpr(queryConstructionContext2.conditional, entitySetDescriptor2);
        List<EntitySetDescriptor> list = queryConstructionContext.resultEntitySetDescriptorList;
        list.add(0, entitySetDescriptor2);
        list.add(0, entitySetDescriptor);
        ConstraintVisitorBase.VisitContext visitContext = this.getVisitContext(relationalConstraintInternal);
        if (visitContext != null) {
            visitContext.querySetExprForRelationshipTarget = entitySetDescriptor.getSetExpr();
        }
    }

    @Override
    public void visitSimplePropertyConstraint(SimplePropertyConstraintInternal simplePropertyConstraintInternal) {
        QueryConstructionContext queryConstructionContext = this.createContext(simplePropertyConstraintInternal);
        QueryExpr queryExpr = queryConstructionContext.conditional;
        ComparisonOperator comparisonOperator = simplePropertyConstraintInternal.getComparisonOperator();
        switch (comparisonOperator) {
            case TEXTUALLY_MATCHES: 
            case CONTAINS: 
            case STARTS_WITH: 
            case ENDS_WITH: 
            case EQUALS: 
            case NOT_EQUALS: 
            case GREATER: 
            case GREATER_OR_EQUALS: 
            case SMALLER: 
            case SMALLER_OR_EQUALS: {
                this.addQueryConditionalForPropertyConstraint(simplePropertyConstraintInternal, queryExpr);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Simple property constraint case not implemented: " + (Object)((Object)comparisonOperator));
            }
        }
    }

    private QueryConstructionContext createContext(ConstraintInternal constraintInternal) {
        Object object;
        QueryConstructionContext queryConstructionContext;
        ConstraintVisitorBase.VisitContext visitContext = this.getParentContext(constraintInternal);
        if (visitContext == null || visitContext.context == null) {
            queryConstructionContext = new QueryConstructionContext();
            queryConstructionContext.resultEntitySetDescriptorList = this._entitySetDescriptorList;
            object = this._targetId;
            EntitySetDescriptor entitySetDescriptor = this.lookupEntitySetById(this._entitySetDescriptorList, (String)object);
            if (entitySetDescriptor == null) {
                String string = constraintInternal.getSearchTarget();
                entitySetDescriptor = EntitySetDescriptor.newInstance((String)object, string, this._metadataDirectory);
                entitySetDescriptor.constraint = constraintInternal;
                this._entitySetDescriptorList.add(entitySetDescriptor);
            }
            queryConstructionContext.conditional = entitySetDescriptor.getSetExpr();
        } else {
            queryConstructionContext = new QueryConstructionContext(visitContext.context);
            queryConstructionContext.constraint = constraintInternal;
            if (visitContext.querySetExprForRelationshipTarget == null) {
                object = new SetExpr(this._metadataDirectory);
                ((QueryExprBase)object).setEntityType(constraintInternal.getSearchTarget());
                queryConstructionContext.conditional = object;
                visitContext.context.conditional.addChild(queryConstructionContext.conditional);
            } else {
                queryConstructionContext.conditional = visitContext.querySetExprForRelationshipTarget;
            }
        }
        queryConstructionContext.conditional.setEntityType(constraintInternal.getSearchTarget());
        object = new ConstraintVisitorBase.VisitContext();
        ((ConstraintVisitorBase.VisitContext)object).context = queryConstructionContext;
        this._contextByConstraint.put(constraintInternal, object);
        return queryConstructionContext;
    }

    private EntitySetDescriptor entitySetForRelationshipTarget(RelationDescriptor relationDescriptor, QueryConstructionContext queryConstructionContext) {
        String string = MetadataUtil.getTargetType(relationDescriptor, this._metadataDirectory);
        String string2 = this._metadataDirectory.getTypeDescriptor(string).getAlias();
        EntitySetDescriptor entitySetDescriptor = this.entitySetFor(string2, string, null, queryConstructionContext);
        entitySetDescriptor.setCardinalityMultiple(MetadataUtil.isMultiCardinality(relationDescriptor, this._metadataDirectory));
        return entitySetDescriptor;
    }

    private EntitySetDescriptor entitySetForRelationshipSource(RelationDescriptor relationDescriptor, String string, QueryConstructionContext queryConstructionContext) {
        String string2 = null;
        String string3 = null;
        return this.entitySetForRelationshipSource(relationDescriptor, string2, string3, string, queryConstructionContext);
    }

    private EntitySetDescriptor entitySetForRelationshipSource(RelationDescriptor relationDescriptor, String string, String string2, String string3, QueryConstructionContext queryConstructionContext) {
        String string4 = MetadataUtil.getSourceType(relationDescriptor, this._metadataDirectory);
        if (string2 == null || string2.length() == 0) {
            string2 = this.formatRelatedEntitySetId(string4, string3);
        }
        String string5 = relationDescriptor.getInverseId();
        RelationDescriptor relationDescriptor2 = this._metadataDirectory.getRelationDescriptor(string5);
        String string6 = MetadataUtil.getQueryExpression(relationDescriptor2);
        String string7 = String.format("%1$sSet", string3);
        string6 = XQueryUtils.replaceTargetIdWith(string6, string7);
        EntitySetDescriptor entitySetDescriptor = this.entitySetFor(string2, string4, string6, queryConstructionContext);
        this.addConditionalExprTo(entitySetDescriptor, string);
        return entitySetDescriptor;
    }

    private String formatRelatedEntitySetId(String string, String string2) {
        String string3 = Strings.capFirstChar(this._metadataDirectory.getTypeDescriptor(string).getAlias());
        String string4 = String.format("%1$s%2$s", string2, string3);
        return string4;
    }

    private void addConditionalExprTo(EntitySetDescriptor entitySetDescriptor, String string) {
        if (string == null) {
            return;
        }
        SetExpr setExpr = entitySetDescriptor.getSetExpr();
        if (setExpr != null && setExpr.isUnset()) {
            setExpr.setExpr(string);
            return;
        }
        setExpr = new SetExpr(this._metadataDirectory);
        setExpr.setExpr(string);
        if (entitySetDescriptor.getSetExpr() == null) {
            entitySetDescriptor.setSetExpr(setExpr);
        } else {
            this.turnConditionalIntoComposite(entitySetDescriptor);
            entitySetDescriptor.getSetExpr().addChild(setExpr);
        }
    }

    private EntitySetDescriptor entitySetFor(String string, String string2, String string3, QueryConstructionContext queryConstructionContext) {
        EntitySetDescriptor entitySetDescriptor;
        List<EntitySetDescriptor> list = queryConstructionContext.resultEntitySetDescriptorList;
        String string4 = string;
        int n = 1;
        while ((entitySetDescriptor = this.lookupEntitySetById(list, string4)) != null) {
            if (this.existingEntitySetApplies(entitySetDescriptor, queryConstructionContext.constraint, string3)) {
                CompositeConstraintInternal compositeConstraintInternal = (CompositeConstraintInternal)queryConstructionContext.constraint.getParentConstraint();
                this.turnConditionalIntoComposite(entitySetDescriptor);
                entitySetDescriptor.getSetExpr().setConjoiner(compositeConstraintInternal.getConjoiner());
                return entitySetDescriptor;
            }
            string4 = String.format("%1$s%2$s", string, n++);
        }
        entitySetDescriptor = EntitySetDescriptor.newInstance(string4, string2, this._metadataDirectory);
        entitySetDescriptor.constraint = queryConstructionContext.constraint;
        if (!Strings.isNullOrEmpty(string3)) {
            entitySetDescriptor.setExpr(string3);
        }
        return entitySetDescriptor;
    }

    private void turnConditionalIntoComposite(EntitySetDescriptor entitySetDescriptor) {
        SetExpr setExpr = entitySetDescriptor.getSetExpr();
        if (setExpr.getChildren().length > 0) {
            return;
        }
        if (setExpr != null && !setExpr.isUnset()) {
            SetExpr setExpr2 = new SetExpr(setExpr, this._metadataDirectory);
            setExpr.clear();
            setExpr.addChild(setExpr2);
        }
    }

    private boolean existingEntitySetApplies(EntitySetDescriptor entitySetDescriptor, ConstraintInternal constraintInternal, String string) {
        if (!ConstraintUtils.areConjoinedTwins(entitySetDescriptor.constraint, constraintInternal)) {
            return false;
        }
        return string == null || string.length() == 0 || entitySetDescriptor.getExpr() == string;
    }

    public EntitySetDescriptor lookupEntitySetById(List<EntitySetDescriptor> list, String string) {
        for (EntitySetDescriptor entitySetDescriptor : list) {
            if (!entitySetDescriptor.id.equals(string)) continue;
            return entitySetDescriptor;
        }
        return null;
    }

    private void applyEntitySetAsExpr(QueryExpr queryExpr, EntitySetDescriptor entitySetDescriptor) {
        VarRefExpression varRefExpression = new VarRefExpression(entitySetDescriptor.id);
        String string = String.format("%1$sSet", varRefExpression.evaluate());
        queryExpr.setExpr(string);
        if (queryExpr instanceof SetExpr) {
            ((SetExpr)queryExpr).exprDefinesDocSet = true;
        }
    }

    private void addQueryConditionalForPropertyConstraint(SimplePropertyConstraintInternal simplePropertyConstraintInternal, QueryExpr queryExpr) {
        assert (simplePropertyConstraintInternal.getComparativeValues().length > 0) : "Unexpected value for the param";
        ConstraintRenderer constraintRenderer = this._rendererFactory.newPropertyConstraintRenderer();
        constraintRenderer.setConstraint(simplePropertyConstraintInternal);
        String string = constraintRenderer.render();
        queryExpr.setExpr(string);
        String string2 = ModelUtils.getResourceModel(simplePropertyConstraintInternal.getProperty());
        if (string2 == null) {
            queryExpr.setEntityType(ConstraintUtils.getSearchTargetType(simplePropertyConstraintInternal));
        } else {
            queryExpr.setResourceModel(string2);
        }
    }

    private ConstraintVisitorBase.VisitContext getParentContext(ConstraintInternal constraintInternal) {
        ConstraintInternal constraintInternal2 = constraintInternal.getParentConstraint();
        return constraintInternal2 == null ? null : (ConstraintVisitorBase.VisitContext)this._contextByConstraint.get(constraintInternal2);
    }
}

