/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.search.CompositeConstraint;
import com.vmware.vise.search.ConstraintConjoiner;
import com.vmware.vise.search.ObjectIdentityConstraint;
import com.vmware.vise.search.TypeRef;
import com.vmware.vise.search.impl.CompositeConstraintInternal;
import com.vmware.vise.search.impl.ConstraintInternal;
import com.vmware.vise.search.impl.ConstraintVisitorBase;
import com.vmware.vise.search.impl.EntitySetDescriptor;
import com.vmware.vise.search.impl.ObjectIdentityConstraintInternal;
import com.vmware.vise.search.impl.QueryElement;
import com.vmware.vise.search.impl.QueryExpr;
import com.vmware.vise.search.impl.RelationalConstraintInternal;
import com.vmware.vise.search.impl.SetExpr;
import com.vmware.vise.search.impl.SimplePropertyConstraintInternal;
import com.vmware.vise.search.impl.TypeRefDirectory;
import com.vmware.vise.search.impl.TypeRefUtils;
import java.util.Map;

public class ExpressionTreeOptimizerVisitor
extends ConstraintVisitorBase {
    private final TypeRefDirectory _typeRefDirectory;
    private final Map<ConstraintInternal, ConstraintVisitorBase.SimplificationType> _simplificationTypeMap;

    public ExpressionTreeOptimizerVisitor(TypeRefDirectory typeRefDirectory, Map<ConstraintInternal, ConstraintVisitorBase.SimplificationType> map, Map<ConstraintInternal, ConstraintVisitorBase.VisitContext> map2) {
        super(map2);
        this._typeRefDirectory = typeRefDirectory;
        this._simplificationTypeMap = map;
    }

    @Override
    public void visitSimplePropertyConstraint(SimplePropertyConstraintInternal simplePropertyConstraintInternal) {
        this.tryMarkConstraintToPredicateExpr(simplePropertyConstraintInternal);
    }

    @Override
    public void visitObjectIdentityConstraint(ObjectIdentityConstraintInternal objectIdentityConstraintInternal) {
        this.tryMarkConstraintToPredicateExpr(objectIdentityConstraintInternal);
    }

    @Override
    public void visitRelationalConstraint(RelationalConstraintInternal relationalConstraintInternal) {
        this._simplificationTypeMap.put(relationalConstraintInternal, ConstraintVisitorBase.SimplificationType.None);
    }

    @Override
    public void visitCompositeConstraint(CompositeConstraintInternal compositeConstraintInternal) {
        this._simplificationTypeMap.put(compositeConstraintInternal, ConstraintVisitorBase.SimplificationType.None);
        ChildrenInfo childrenInfo = this.getChildrenInfo(compositeConstraintInternal);
        if (this.definesObjectSet(compositeConstraintInternal, childrenInfo)) {
            this.optimizeObjectSet(compositeConstraintInternal);
        } else if (childrenInfo.haveTheSameType) {
            this.optimizeCompositeOverSameType(compositeConstraintInternal, childrenInfo);
        }
    }

    @Override
    public void visitDefaultConstraint(ConstraintInternal constraintInternal) {
        if (this.canConvertToPredicate(constraintInternal)) {
            this._simplificationTypeMap.put(constraintInternal, ConstraintVisitorBase.SimplificationType.PredicateExpr);
        } else {
            this._simplificationTypeMap.put(constraintInternal, ConstraintVisitorBase.SimplificationType.None);
        }
    }

    private boolean definesObjectSet(CompositeConstraintInternal compositeConstraintInternal, ChildrenInfo childrenInfo) {
        ConstraintConjoiner constraintConjoiner = compositeConstraintInternal.getConjoiner();
        boolean bl = constraintConjoiner == ConstraintConjoiner.AND || constraintConjoiner == ConstraintConjoiner.OR;
        boolean bl2 = childrenInfo.areObjectSets && bl;
        return bl2;
    }

    private void optimizeObjectSet(CompositeConstraintInternal compositeConstraintInternal) {
        this._simplificationTypeMap.put(compositeConstraintInternal, ConstraintVisitorBase.SimplificationType.ObjectSetExpr);
        this.markAllNestedToPredicateExprs(compositeConstraintInternal);
    }

    private void optimizeCompositeOverSameType(CompositeConstraintInternal compositeConstraintInternal, ChildrenInfo childrenInfo) {
        assert (childrenInfo.haveTheSameType);
        ConstraintConjoiner constraintConjoiner = compositeConstraintInternal.getConjoiner();
        ConstraintInternal[] constraintInternalArray = compositeConstraintInternal.getNestedConstraints();
        if (childrenInfo.numOfPredicateExprs == constraintInternalArray.length && (constraintConjoiner == ConstraintConjoiner.AND || constraintConjoiner == ConstraintConjoiner.OR)) {
            if (this.canConvertToPredicate(compositeConstraintInternal)) {
                this._simplificationTypeMap.put(compositeConstraintInternal, ConstraintVisitorBase.SimplificationType.PredicateExpr);
            } else {
                this._simplificationTypeMap.put(compositeConstraintInternal, ConstraintVisitorBase.SimplificationType.PredicateSetExpr);
            }
        } else if (childrenInfo.numOfPredicateExprs > 0) {
            if (constraintConjoiner == ConstraintConjoiner.AND) {
                this._simplificationTypeMap.put(compositeConstraintInternal, ConstraintVisitorBase.SimplificationType.PredicateSetExpr);
            } else {
                this.markAllNestedPrdicateExprsToPredicatesSetExprs(compositeConstraintInternal);
            }
        }
    }

    private void tryMarkConstraintToPredicateExpr(ConstraintInternal constraintInternal) {
        TypeRef typeRef;
        ConstraintInternal constraintInternal2 = constraintInternal.getParentConstraint();
        TypeRef typeRef2 = this._typeRefDirectory.getTypeRef(constraintInternal.getSearchTarget());
        if (constraintInternal2 != null && typeRef2.isAssignableFrom(typeRef = this._typeRefDirectory.getTypeRef(constraintInternal2.getSearchTarget()))) {
            this._simplificationTypeMap.put(constraintInternal, ConstraintVisitorBase.SimplificationType.PredicateExpr);
        }
    }

    private void markAllNestedPrdicateExprsToPredicatesSetExprs(CompositeConstraintInternal compositeConstraintInternal) {
        ConstraintInternal[] constraintInternalArray;
        for (ConstraintInternal constraintInternal : constraintInternalArray = compositeConstraintInternal.getNestedConstraints()) {
            if (this._simplificationTypeMap.get(constraintInternal) != ConstraintVisitorBase.SimplificationType.PredicateExpr) continue;
            this._simplificationTypeMap.put(constraintInternal, ConstraintVisitorBase.SimplificationType.PredicateSetExpr);
        }
    }

    private void markAllNestedToPredicateExprs(CompositeConstraintInternal compositeConstraintInternal) {
        for (ConstraintInternal constraintInternal : compositeConstraintInternal.getNestedConstraints()) {
            this._simplificationTypeMap.put(constraintInternal, ConstraintVisitorBase.SimplificationType.PredicateExpr);
        }
    }

    boolean canConvertToPredicate(ConstraintInternal constraintInternal) {
        ConstraintInternal constraintInternal2 = constraintInternal.getParentConstraint();
        if (!(constraintInternal2 instanceof CompositeConstraint)) {
            return false;
        }
        ConstraintVisitorBase.VisitContext visitContext = this.getVisitContext(constraintInternal);
        QueryExpr queryExpr = visitContext.context.conditional;
        if (queryExpr == null || queryExpr.isUnset()) {
            return false;
        }
        if (!(queryExpr instanceof SetExpr)) {
            return false;
        }
        SetExpr setExpr = (SetExpr)queryExpr;
        if (setExpr.exprDefinesDocSet) {
            return false;
        }
        String string = setExpr.getEntityType();
        if (string != null && !TypeRefUtils.ROOT_TYPEREF.getName().equals(string)) {
            TypeRef typeRef;
            QueryElement queryElement = setExpr.getParent();
            if (queryElement == null || queryElement instanceof EntitySetDescriptor) {
                return false;
            }
            String string2 = queryElement.getEntityType();
            if (string2 == null) {
                return false;
            }
            TypeRef typeRef2 = this._typeRefDirectory.getTypeRef(string);
            if (!typeRef2.isAssignableFrom(typeRef = this._typeRefDirectory.getTypeRef(string2))) {
                return false;
            }
        }
        return true;
    }

    private ChildrenInfo getChildrenInfo(CompositeConstraintInternal compositeConstraintInternal) {
        String string = compositeConstraintInternal.getSearchTarget();
        TypeRef typeRef = this._typeRefDirectory.getTypeRef(string);
        boolean bl = true;
        boolean bl2 = true;
        int n = 0;
        for (ConstraintInternal constraintInternal : compositeConstraintInternal.getNestedConstraints()) {
            ConstraintVisitorBase.SimplificationType simplificationType = this._simplificationTypeMap.get(constraintInternal);
            boolean bl3 = bl2 = bl2 && (constraintInternal instanceof ObjectIdentityConstraint || simplificationType == ConstraintVisitorBase.SimplificationType.ObjectSetExpr);
            if (this._simplificationTypeMap.get(constraintInternal) != ConstraintVisitorBase.SimplificationType.PredicateExpr) continue;
            ++n;
            String string2 = constraintInternal.getSearchTarget();
            TypeRef typeRef2 = this._typeRefDirectory.getTypeRef(string2);
            bl = bl && typeRef2.isAssignableFrom(typeRef);
        }
        ChildrenInfo childrenInfo = new ChildrenInfo();
        childrenInfo.numOfPredicateExprs = n;
        childrenInfo.haveTheSameType = bl;
        childrenInfo.areObjectSets = bl2;
        return childrenInfo;
    }

    private class ChildrenInfo {
        int numOfPredicateExprs;
        boolean haveTheSameType;
        boolean areObjectSets;

        private ChildrenInfo() {
        }
    }
}

