/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.search.PropertySpec;
import com.vmware.vise.search.impl.EntitySetDescriptor;
import com.vmware.vise.search.impl.QueryExprBase;
import com.vmware.vise.search.impl.SetExpr;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.metadata.RelationDescriptor;
import com.vmware.vise.search.util.Renderer;
import com.vmware.vise.search.util.Strings;
import com.vmware.vise.search.xquery.VarRefExpression;
import com.vmware.vise.search.xquery.XQueryUtils;
import com.vmware.vise.search.xquery.render.CompositePropertyRenderer;
import com.vmware.vise.search.xquery.render.PropertyRenderer;
import com.vmware.vise.search.xquery.render.RendererFactory;
import com.vmware.vise.util.ValidationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PropertySpecExprBuilder {
    private static final Log _logger = LogFactory.getLog(PropertySpecExprBuilder.class);
    private final PropertySpec[] _propSpecs;
    private final String _providerId;
    private final boolean _toReturnOneObjectFromExprs;
    private final MetadataDirectory _metadataDirectory;
    private final RendererFactory _rendererFactory;
    private static final String RETURN_PROPERTIES_TAG = "properties";
    private static final String RETURN_CLAUSE_FORMAT = String.format("return <%1$s:%2$s %1$s:%3$s=\"{$targetDocId}\" %1$s:%4$s=\"{$resourceId}\">\n{local:extractGenerations($%%1$s)}\n<%1$s:%5$s>%%%%1$s</%1$s:%5$s>\n</%1$s:%2$s>", "query", "item", "provider", "resource", "properties");
    private final String _returnClauseFormatForProviderId;
    Map<String, List<PropertyRenderer.PropertyRendererContext>> _propsByProvider = new HashMap<String, List<PropertyRenderer.PropertyRendererContext>>();
    private List<EntitySetDescriptor> targetRelativesForReturn = new ArrayList<EntitySetDescriptor>();
    private Map<RelationDescriptor, List<EntitySetDescriptor>> groupedTargetsRelativeForReturn = new HashMap<RelationDescriptor, List<EntitySetDescriptor>>();
    private Map<String, EntitySetDescriptor> returnTargetRelativesByExpr = new HashMap<String, EntitySetDescriptor>(4);

    public PropertySpecExprBuilder(PropertySpec[] propertySpecArray, MetadataDirectory metadataDirectory, RendererFactory rendererFactory) {
        this(propertySpecArray, "target", true, metadataDirectory, rendererFactory);
    }

    PropertySpecExprBuilder(PropertySpec[] propertySpecArray, String string, boolean bl, MetadataDirectory metadataDirectory, RendererFactory rendererFactory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{metadataDirectory, rendererFactory});
        ValidationUtil.paramsNotNull((Object[])propertySpecArray);
        ValidationUtil.stringsNotNullOrEmpty((String[])new String[]{string});
        this._propSpecs = propertySpecArray;
        this._providerId = string;
        this._returnClauseFormatForProviderId = String.format(RETURN_CLAUSE_FORMAT, this._providerId);
        this._toReturnOneObjectFromExprs = bl;
        this._metadataDirectory = metadataDirectory;
        this._rendererFactory = rendererFactory;
        this.addPropertiesToProviderMap();
    }

    public String getSetExprString() {
        String string = "";
        String[] stringArray = EntitySetDescriptor.toUniqueSetDefnClauses(this.targetRelativesForReturn, string);
        String string2 = "";
        if (stringArray.length > 0) {
            string2 = Strings.join("\n  ", stringArray);
            string2 = String.format("\n  %1$s", string2);
        }
        return string2;
    }

    public String getProviderIdFor(PropertySpec propertySpec) {
        if (Strings.isNullOrEmpty(propertySpec.relationship)) {
            return this._providerId;
        }
        RelationDescriptor[] relationDescriptorArray = MetadataUtil.getRelationshipHops(this._metadataDirectory, propertySpec.providerType, propertySpec.relationship);
        EntitySetDescriptor entitySetDescriptor = this.findTargetRelativeForReturn(relationDescriptorArray[relationDescriptorArray.length - 1]);
        return entitySetDescriptor.id;
    }

    public String getProviderTypeFor(PropertySpec propertySpec) {
        if (Strings.isNullOrEmpty(propertySpec.relationship)) {
            return propertySpec.providerType;
        }
        RelationDescriptor[] relationDescriptorArray = MetadataUtil.getRelationshipHops(this._metadataDirectory, propertySpec.providerType, propertySpec.relationship);
        EntitySetDescriptor entitySetDescriptor = this.findTargetRelativeForReturn(relationDescriptorArray[relationDescriptorArray.length - 1]);
        String string = entitySetDescriptor.getEntityType();
        return string;
    }

    public String getReturnExprString() {
        Collection<Renderer> collection = this.createReturnPropertyRenderers();
        StringBuilder stringBuilder = new StringBuilder();
        HashSet<String> hashSet = new HashSet<String>();
        for (Renderer renderer : collection) {
            String string = renderer.render();
            if (hashSet.contains(string)) continue;
            hashSet.add(string);
            string = String.format("\n           {%1$s}", string);
            stringBuilder.append(string);
        }
        stringBuilder = stringBuilder.append("\n         ");
        String string = this.formatReturnClause(stringBuilder.toString());
        return string;
    }

    private void addTargetRelativeForReturn(RelationDescriptor relationDescriptor, EntitySetDescriptor entitySetDescriptor) {
        ArrayList<EntitySetDescriptor> arrayList;
        String string = entitySetDescriptor.evaluate("/*");
        EntitySetDescriptor entitySetDescriptor2 = this.returnTargetRelativesByExpr.get(string);
        if (entitySetDescriptor2 == null) {
            this.returnTargetRelativesByExpr.put(string, entitySetDescriptor);
        } else {
            arrayList = new SetExpr(this._metadataDirectory);
            VarRefExpression varRefExpression = new VarRefExpression(entitySetDescriptor2.id);
            String string2 = varRefExpression.evaluate();
            ((QueryExprBase)((Object)arrayList)).setExpr(string2);
            ((SetExpr)((Object)arrayList)).exprDefinesDocSet = true;
            String string3 = null;
            SetExpr setExpr = entitySetDescriptor2.getSetExpr();
            if (setExpr != null) {
                string3 = setExpr.getEntityType();
            }
            ((QueryExprBase)((Object)arrayList)).setEntityType(string3);
            entitySetDescriptor.setSetExpr((SetExpr)((Object)arrayList));
            entitySetDescriptor.setExpr(null);
        }
        arrayList = this.groupedTargetsRelativeForReturn.get(relationDescriptor);
        if (arrayList == null) {
            arrayList = new ArrayList<EntitySetDescriptor>();
            this.groupedTargetsRelativeForReturn.put(relationDescriptor, arrayList);
        }
        arrayList.add(entitySetDescriptor);
        this.targetRelativesForReturn.add(entitySetDescriptor);
    }

    private EntitySetDescriptor findTargetRelativeForReturn(RelationDescriptor relationDescriptor) {
        List<EntitySetDescriptor> list = this.groupedTargetsRelativeForReturn.get(relationDescriptor);
        EntitySetDescriptor entitySetDescriptor = list == null ? null : list.get(list.size() - 1);
        return entitySetDescriptor;
    }

    private Collection<Renderer> createReturnPropertyRenderers() {
        assert (this._propsByProvider != null);
        ArrayList<Renderer> arrayList = new ArrayList<Renderer>();
        for (String string : this._propsByProvider.keySet()) {
            Object object;
            List<PropertyRenderer.PropertyRendererContext> list = this._propsByProvider.get(string);
            if (list.size() == 0) continue;
            if (!string.equals(this._providerId)) {
                PropertyRenderer.PropertyRendererContext propertyRendererContext = list.get(0);
                String string2 = propertyRendererContext.propertyDescriptor.getProvider();
                object = this._metadataDirectory.getTypeDescriptor(string2).getAlias();
                CompositePropertyRenderer compositePropertyRenderer = this._rendererFactory.newCompositeReturnPropertyRenderer((String)object, string);
                for (PropertyRenderer.PropertyRendererContext propertyRendererContext2 : list) {
                    PropertyRenderer propertyRenderer = this._rendererFactory.newReturnPropertyRenderer();
                    propertyRenderer.setRendererContext(propertyRendererContext2);
                    compositePropertyRenderer.addChild(propertyRenderer);
                }
                arrayList.add(compositePropertyRenderer);
                continue;
            }
            for (PropertyRenderer.PropertyRendererContext propertyRendererContext : list) {
                object = this._rendererFactory.newReturnPropertyRenderer();
                object.setRendererContext(propertyRendererContext);
                arrayList.add((Renderer)object);
            }
        }
        return arrayList;
    }

    private void addPropertiesToProviderMap() {
        String string = null;
        for (PropertySpec propertySpec : this._propSpecs) {
            string = this._providerId;
            String string2 = propertySpec.providerType;
            if (!Strings.isNullOrEmpty(propertySpec.relationship)) {
                EntitySetDescriptor entitySetDescriptor = this.processAndGetLastEntitySetDefnForRelation(string2, propertySpec.relationship);
                string2 = entitySetDescriptor.getEntityType();
                string = entitySetDescriptor.id;
            }
            for (String string3 : propertySpec.properties) {
                this.addPropertyToProviderMap(string2, string3, string);
            }
        }
    }

    private void addPropertyToProviderMap(String string, String string2, String string3) {
        assert (string2 != null);
        PropertyDescriptor propertyDescriptor = this._metadataDirectory.getPropertyDescriptor(string2, string);
        if (!MetadataUtil.isSupported(propertyDescriptor)) {
            return;
        }
        List<PropertyRenderer.PropertyRendererContext> list = this._propsByProvider.get(string3);
        if (list == null) {
            list = new LinkedList<PropertyRenderer.PropertyRendererContext>();
            this._propsByProvider.put(string3, list);
        }
        PropertyRenderer.PropertyRendererContext propertyRendererContext = new PropertyRenderer.PropertyRendererContext(propertyDescriptor, string3, string2);
        list.add(propertyRendererContext);
    }

    private EntitySetDescriptor processAndGetLastEntitySetDefnForRelation(String string, String string2) {
        EntitySetDescriptor entitySetDescriptor;
        assert (string2 != null);
        assert (string != null);
        RelationDescriptor[] relationDescriptorArray = MetadataUtil.getRelationshipHops(this._metadataDirectory, string, string2);
        String string3 = this._providerId;
        if (relationDescriptorArray.length <= 0) {
            _logger.error((Object)String.format("Invalid relationship: %1$s. It doesn't match to relatinships meta-data.", string2));
        }
        if ((entitySetDescriptor = this.findTargetRelativeForReturn(relationDescriptorArray[relationDescriptorArray.length - 1])) != null) {
            return entitySetDescriptor;
        }
        for (RelationDescriptor relationDescriptor : relationDescriptorArray) {
            entitySetDescriptor = this.findTargetRelativeForReturn(relationDescriptor);
            if (entitySetDescriptor != null) continue;
            entitySetDescriptor = this.getEntitySetDefnForRelation(string3, relationDescriptor);
            this.addTargetRelativeForReturn(relationDescriptor, entitySetDescriptor);
            string3 = entitySetDescriptor.id;
        }
        return entitySetDescriptor;
    }

    private EntitySetDescriptor getEntitySetDefnForRelation(String string, RelationDescriptor relationDescriptor) {
        String string2 = MetadataUtil.getTargetType(relationDescriptor, this._metadataDirectory);
        String string3 = this._metadataDirectory.getTypeDescriptor(string2).getAlias();
        EntitySetDescriptor entitySetDescriptor = EntitySetDescriptor.newInstance(string3, string2, this._metadataDirectory);
        entitySetDescriptor.setWriteExprAsSingular(this._toReturnOneObjectFromExprs);
        String string4 = MetadataUtil.getQueryExpression(relationDescriptor);
        string4 = XQueryUtils.replaceTargetIdWith(string4, string);
        entitySetDescriptor.setExpr(string4);
        return entitySetDescriptor;
    }

    private String formatReturnClause(String string) {
        return String.format(this._returnClauseFormatForProviderId, string);
    }
}

