/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vise.search.ComparisonOperator;
import com.vmware.vise.search.Constraint;
import com.vmware.vise.search.ConstraintConjoiner;
import com.vmware.vise.search.ConstraintFactory;
import com.vmware.vise.search.SimplePropertyConstraint;
import com.vmware.vise.search.impl.ConstraintUtils;
import com.vmware.vise.search.impl.SearchUtil;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.metadata.TypeDescriptor;
import com.vmware.vise.search.model.ModelUtils;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.transform.Transformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class SearchPropertyConstraintTransformer
implements Transformer<Constraint> {
    private static final String TYPE_FOLDER = Folder.class.getSimpleName();
    private static final String FILTER_SYSTEM_FOLDER_PROPERTY = "isSystemFolder";
    private static final String TYPE_RP = ResourcePool.class.getSimpleName();
    private static final String FILTER_SYSTEM_RP_PROPERTY = "isRootRP";
    private final ConstraintFactory _constraintFactory;
    private final MetadataDirectory _metadataDirectory;

    SearchPropertyConstraintTransformer(MetadataDirectory metadataDirectory, ConstraintFactory constraintFactory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{metadataDirectory, constraintFactory});
        this._metadataDirectory = metadataDirectory;
        this._constraintFactory = constraintFactory;
    }

    public Transformer.Result<Constraint> transform(Constraint constraint) {
        if (!(constraint instanceof SimplePropertyConstraint)) {
            return new Transformer.Result((Object)constraint);
        }
        SimplePropertyConstraint simplePropertyConstraint = (SimplePropertyConstraint)constraint;
        Constraint constraint2 = this.getEquivalentSearchConstraint(simplePropertyConstraint);
        boolean bl = constraint2 != simplePropertyConstraint;
        return new Transformer.Result((Object)constraint2, bl);
    }

    private Constraint getEquivalentSearchConstraint(SimplePropertyConstraint simplePropertyConstraint) {
        Collection<TypeDescriptor> collection;
        ArrayList<TypeDescriptor> arrayList;
        if (ModelUtils.isQualifiedWithResourceModel(simplePropertyConstraint.getProperty())) {
            return simplePropertyConstraint;
        }
        String string = simplePropertyConstraint.getSearchTarget();
        boolean bl = SearchUtil.representsAllTypes(string);
        if (bl) {
            arrayList = new ArrayList<TypeDescriptor>();
            collection = MetadataUtil.getSearchableTypes(this._metadataDirectory);
            if (collection.isEmpty()) {
                return simplePropertyConstraint;
            }
        } else {
            return simplePropertyConstraint;
        }
        arrayList.addAll(collection);
        collection = this.createORingCompositeConstraint(simplePropertyConstraint, arrayList);
        if (bl) {
            Constraint constraint = this.getFilterConstraint();
            collection = ConstraintUtils.combineIntoSingleConstraint(new Constraint[]{collection, constraint}, ConstraintConjoiner.EXCEPT);
        }
        return collection;
    }

    private Constraint createORingCompositeConstraint(SimplePropertyConstraint simplePropertyConstraint, Collection<TypeDescriptor> collection) {
        ArrayList<SimplePropertyConstraint> arrayList = new ArrayList<SimplePropertyConstraint>();
        for (TypeDescriptor object2 : collection) {
            String string = object2.getType();
            List<PropertyDescriptor> list = this.getPropertyDescriptors(string, simplePropertyConstraint);
            for (PropertyDescriptor propertyDescriptor : list) {
                String string2 = propertyDescriptor.getName();
                SimplePropertyConstraint simplePropertyConstraint2 = simplePropertyConstraint.getDeepCopy();
                simplePropertyConstraint2.setSearchTarget(string);
                simplePropertyConstraint2.setProperty(string2);
                arrayList.add(simplePropertyConstraint2);
            }
        }
        Constraint[] constraintArray = arrayList.toArray(new Constraint[arrayList.size()]);
        Constraint constraint = ConstraintUtils.combineIntoSingleConstraint(constraintArray, ConstraintConjoiner.OR);
        return constraint;
    }

    private List<PropertyDescriptor> getPropertyDescriptors(String string, SimplePropertyConstraint simplePropertyConstraint) {
        String string2 = simplePropertyConstraint.getProperty();
        List<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>();
        if (SearchUtil.representsAllProperties(string2)) {
            list = simplePropertyConstraint.getComparisonOperator() == ComparisonOperator.TEXTUALLY_MATCHES ? this._metadataDirectory.getTextualPropertyDescriptors(string) : this._metadataDirectory.getPropertyDescriptors(string);
        } else {
            PropertyDescriptor propertyDescriptor = this._metadataDirectory.getPropertyDescriptor(string2, string);
            list.add(propertyDescriptor);
        }
        return list;
    }

    private Constraint getFilterConstraint() {
        SimplePropertyConstraint simplePropertyConstraint = this._constraintFactory.newSimplePropertyConstraint();
        simplePropertyConstraint.setSearchTarget(TYPE_FOLDER);
        simplePropertyConstraint.setProperty(FILTER_SYSTEM_FOLDER_PROPERTY);
        simplePropertyConstraint.setComparisonOperator(ComparisonOperator.EQUALS);
        simplePropertyConstraint.setComparativeValues(new Object[]{true});
        SimplePropertyConstraint simplePropertyConstraint2 = this._constraintFactory.newSimplePropertyConstraint();
        simplePropertyConstraint2.setSearchTarget(TYPE_RP);
        simplePropertyConstraint2.setProperty(FILTER_SYSTEM_RP_PROPERTY);
        simplePropertyConstraint2.setComparisonOperator(ComparisonOperator.EQUALS);
        simplePropertyConstraint2.setComparativeValues(new Object[]{true});
        Constraint constraint = ConstraintUtils.combineIntoSingleConstraint(new Constraint[]{simplePropertyConstraint, simplePropertyConstraint2}, ConstraintConjoiner.OR);
        return constraint;
    }
}

