/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.metadata.ObjectModelProvider;
import com.vmware.vise.search.ObjectModelProviderDirectory;
import com.vmware.vise.search.PropertyUnmarshaller;
import com.vmware.vise.search.impl.SearchServiceExtensionRegistryInternal;
import com.vmware.vise.search.impl.TypeRefDirectory;
import com.vmware.vise.search.impl.TypeRefDirectoryImpl;
import com.vmware.vise.search.metadata.CodeFlavor;
import com.vmware.vise.search.metadata.DescriptorSource;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.util.Directory;
import com.vmware.vise.util.DirectoryImpl;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

final class SearchServiceExtensionRegistryImpl
implements SearchServiceExtensionRegistryInternal {
    private static final Log _logger = LogFactory.getLog(SearchServiceExtensionRegistryImpl.class);
    private final Directory<PropertyUnmarshaller> _unmarshallerDirectory;
    private final Directory<ObjectModelProvider> _objectModelProviderDirectory;
    private final TypeRefDirectory _typeRefDirectory;
    private final CopyOnWriteArraySet<String> _reservedNamespaces = new CopyOnWriteArraySet();
    private final Map<CodeFlavor, MetadataDirectory> _metadataDirs;
    private final MetadataDirectory _defaultMetadataDirectory;

    SearchServiceExtensionRegistryImpl() {
        this._objectModelProviderDirectory = new ObjectModelProviderDirectory();
        this._unmarshallerDirectory = new DirectoryImpl();
        this._typeRefDirectory = new TypeRefDirectoryImpl(this._objectModelProviderDirectory);
        this._metadataDirs = MetadataUtil.newMetadataDirectory(this._typeRefDirectory);
        this._defaultMetadataDirectory = this._metadataDirs.get((Object)CodeFlavor.VMODL2_SUPPORT);
    }

    @Override
    public TypeRefDirectory getTypeRefDirectory() {
        return this._typeRefDirectory;
    }

    @Override
    public void registerProvider(ObjectModelProvider objectModelProvider, String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{objectModelProvider});
        if (StringUtil.isNullOrEmpty((String)string)) {
            throw new IllegalArgumentException("Namespace cannot be null or empty.");
        }
        if (this._reservedNamespaces.contains(string)) {
            ObjectModelProvider objectModelProvider2 = (ObjectModelProvider)this._objectModelProviderDirectory.addIfAbsent(string, (Object)objectModelProvider);
            if (objectModelProvider2 != null) {
                String string2 = "Cannot override ObjectModelProvider at reserved namespace: ";
                string2 = string2 + string;
                throw new IllegalStateException(string2);
            }
            return;
        }
        ObjectModelProvider objectModelProvider3 = (ObjectModelProvider)this._objectModelProviderDirectory.add(string, (Object)objectModelProvider);
        if (objectModelProvider3 != null) {
            _logger.warn((Object)("ObjectModelProvider was already registered at " + string));
        }
    }

    @Override
    public void unregisterProvider(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            throw new IllegalArgumentException("Namespace cannot be null or empty.");
        }
        if (this._reservedNamespaces.contains(string)) {
            throw new IllegalStateException("Cannot remove ObjectModelProvider at reserved namespace: " + string);
        }
        ObjectModelProvider objectModelProvider = (ObjectModelProvider)this._objectModelProviderDirectory.remove(string);
        if (objectModelProvider == null) {
            _logger.warn((Object)("No ObjectModelProvider removed for namespace: " + string));
        }
    }

    @Override
    public void registerMetadata(String string, Document document, ClassLoader classLoader, String string2) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string, document});
        DescriptorSource descriptorSource = MetadataUtil.getDescriptorSource(string, document, classLoader, string2);
        this._defaultMetadataDirectory.addSource(descriptorSource);
    }

    @Override
    public void registerMetadata(String string, Document document) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string, document});
        ClassLoader classLoader = null;
        String string2 = null;
        this.registerMetadata(string, document, classLoader, string2);
    }

    @Override
    public void unregisterMetadata(String string) {
        if (string == null) {
            return;
        }
        this._defaultMetadataDirectory.removeSource(string);
    }

    @Override
    public MetadataDirectory getMetadataDirectory() {
        return this._defaultMetadataDirectory;
    }

    @Override
    public MetadataDirectory getMetadataDirectory(CodeFlavor codeFlavor) {
        return this._metadataDirs.get((Object)codeFlavor);
    }

    @Override
    public void registerUnmarshaller(String string, PropertyUnmarshaller propertyUnmarshaller) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyUnmarshaller});
        if (StringUtil.isNullOrEmpty((String)string)) {
            throw new IllegalArgumentException("Namespace cannot be null or empty.");
        }
        if (this._reservedNamespaces.contains(string)) {
            PropertyUnmarshaller propertyUnmarshaller2 = (PropertyUnmarshaller)this._unmarshallerDirectory.addIfAbsent(string, (Object)propertyUnmarshaller);
            if (propertyUnmarshaller2 != null) {
                throw new IllegalStateException("Cannot overwrite unmarshaller at reserved namespace " + string);
            }
            return;
        }
        PropertyUnmarshaller propertyUnmarshaller3 = (PropertyUnmarshaller)this._unmarshallerDirectory.add(string, (Object)propertyUnmarshaller);
        if (propertyUnmarshaller3 != null) {
            _logger.warn((Object)("Unmarshaller already registered at: " + string));
        }
    }

    @Override
    public void unregisterUnmarshaller(String string) {
        if (StringUtil.isNullOrEmpty((String)string)) {
            throw new IllegalArgumentException("Namespace cannot be null or empty.");
        }
        if (this._reservedNamespaces.contains(string)) {
            throw new IllegalStateException("Cannot remove PropertyUnmarshaller at reserved namespace: " + string);
        }
        PropertyUnmarshaller propertyUnmarshaller = (PropertyUnmarshaller)this._unmarshallerDirectory.remove(string);
        if (propertyUnmarshaller == null) {
            _logger.warn((Object)("No unmarshaller removed for namespace: " + string));
        }
    }

    @Override
    public Directory<PropertyUnmarshaller> getUnmarshallerDirectory() {
        return this._unmarshallerDirectory;
    }

    @Override
    public void addReservedNamespace(String string) {
        this._reservedNamespaces.add(string);
    }
}

