/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.search.ConstraintConjoiner;
import com.vmware.vise.search.impl.QueryExpr;
import com.vmware.vise.search.impl.QueryExprBase;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.util.Strings;
import com.vmware.vise.search.xquery.Expression;
import com.vmware.vise.search.xquery.LiteralExpression;
import com.vmware.vise.search.xquery.PredicatedExpression;
import com.vmware.vise.search.xquery.SetExpression;
import com.vmware.vise.search.xquery.XQueryUtils;
import com.vmware.vise.util.ValidationUtil;

class SetExpr
extends QueryExprBase {
    private final MetadataDirectory _metadataDirectory;
    public boolean exprDefinesDocSet = false;

    public SetExpr(MetadataDirectory metadataDirectory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{metadataDirectory});
        this._metadataDirectory = metadataDirectory;
    }

    public SetExpr(SetExpr setExpr, MetadataDirectory metadataDirectory) {
        super(setExpr);
        ValidationUtil.paramsNotNull((Object[])new Object[]{metadataDirectory});
        this._metadataDirectory = metadataDirectory;
        this.exprDefinesDocSet = setExpr.exprDefinesDocSet;
    }

    @Override
    public String toString() {
        String string = null;
        return this.evaluate(string);
    }

    @Override
    public String evaluate(String string) {
        String string2;
        String string3 = this.getResourceModel();
        if (string3 == null) {
            string2 = this.getEntityType();
            if (Strings.isNullOrEmpty(string) || string2 != null && !string2.equals(this.getParent().getEntityType())) {
                string = XQueryUtils.typeMatchingExpression(string2, this._metadataDirectory);
            }
        }
        if (!Strings.isNullOrEmpty(string2 = this.getExpr())) {
            if (this.exprDefinesDocSet) {
                return string2;
            }
            LiteralExpression literalExpression = new LiteralExpression(string);
            LiteralExpression literalExpression2 = new LiteralExpression(string2);
            Expression expression = string3 != null ? XQueryUtils.addModelMatchingExpression(string3, literalExpression2) : literalExpression2;
            PredicatedExpression predicatedExpression = new PredicatedExpression(literalExpression, expression);
            String string4 = XQueryUtils.replaceCascadingClausesWithAnd(predicatedExpression.evaluate());
            return string4;
        }
        return this.evaluateChildren(string);
    }

    protected String evaluateChildren(String string) {
        QueryExpr[] queryExprArray = this.getChildren();
        if (queryExprArray == null || queryExprArray.length == 0) {
            return string;
        }
        if (queryExprArray.length == 1) {
            return queryExprArray[0].evaluate(string);
        }
        ConstraintConjoiner constraintConjoiner = this.getConjoiner() == null ? ConstraintConjoiner.AND : this.getConjoiner();
        Expression[] expressionArray = new Expression[queryExprArray.length];
        int n = 0;
        for (QueryExpr queryExpr : queryExprArray) {
            String string2 = queryExpr.evaluate(string);
            LiteralExpression literalExpression = new LiteralExpression(string2);
            expressionArray[n++] = literalExpression;
        }
        if (expressionArray.length == 1) {
            return expressionArray[0].evaluate();
        }
        SetExpression.Operator operator = XQueryUtils.toSetXQueryOperator(constraintConjoiner);
        SetExpression setExpression = new SetExpression(operator, expressionArray);
        return setExpression.evaluate();
    }

    @Override
    public void clear() {
        super.clear();
        this.exprDefinesDocSet = false;
    }
}

