/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.data.query.SortType;
import com.vmware.vise.search.Constraint;
import com.vmware.vise.search.FacetSpec;
import com.vmware.vise.search.OrderingCriteria;
import com.vmware.vise.search.OrderingPropertySpec;
import com.vmware.vise.search.OrderingType;
import com.vmware.vise.search.PropertySpec;
import com.vmware.vise.search.QuerySpec;
import com.vmware.vise.search.ResponseSpec;
import com.vmware.vise.search.impl.ConstraintInternal;
import com.vmware.vise.search.transport.QueryOptions;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpecUtil {
    private static final Log _logger = LogFactory.getLog(SpecUtil.class);
    private static final String nullStr = "[null]";
    private static final char INDENTATION_CHAR = ' ';
    private static final int INDENTATION_SIZE = 3;

    public static String toString(QuerySpec querySpec) {
        if (querySpec == null) {
            return nullStr;
        }
        try {
            StringBuilder stringBuilder = new StringBuilder(2000);
            stringBuilder.append(querySpec.getClass().getSimpleName());
            String string = SpecUtil.getIndentation(1);
            stringBuilder.append("\n").append(string).append("QueryName: ").append(querySpec.name != null ? querySpec.name : nullStr);
            stringBuilder.append("\n");
            SpecUtil.writeConstraint(stringBuilder, querySpec.constraint, 1, string);
            stringBuilder.append("\n");
            SpecUtil.writeQueryOptions(stringBuilder, querySpec.options, 1, string);
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            _logger.warn((Object)("Failed to generate a string representation of a " + querySpec.getClass().getName()), (Throwable)exception);
            return "???";
        }
    }

    private static void writeConstraint(StringBuilder stringBuilder, Constraint constraint, int n, String string) {
        if (constraint != null) {
            if (constraint instanceof ConstraintInternal) {
                ConstraintInternal constraintInternal = (ConstraintInternal)constraint;
                constraintInternal.toString(stringBuilder, n, 3);
            } else {
                stringBuilder.append(string).append("<<<Unsupported constraint type: ").append(constraint.getClass().getName()).append(">>>");
            }
        } else {
            stringBuilder.append(string).append("Constraint: ").append(nullStr);
        }
    }

    private static void writeQueryOptions(StringBuilder stringBuilder, QueryOptions queryOptions, int n, String string) {
        if (string != null) {
            stringBuilder.append(string);
        }
        stringBuilder.append("QueryOptions: ");
        if (queryOptions != null) {
            String string2 = SpecUtil.getIndentation(n + 1);
            stringBuilder.append("\n").append(string2).append("TargetSpecificProviderName: ").append(queryOptions.targetSpecificProviderName);
            stringBuilder.append("\n").append(string2).append("TargetSpecificProviderUuid: ").append(queryOptions.targetSpecificProviderUuid);
            stringBuilder.append("\n").append(string2).append("ProvidersToSync: ").append(Arrays.toString(queryOptions.providersToSync));
            stringBuilder.append("\n").append(string2).append("Federated: ").append(queryOptions.federated);
        } else {
            stringBuilder.append(nullStr);
        }
    }

    public static String toString(QueryOptions queryOptions) {
        try {
            StringBuilder stringBuilder = new StringBuilder(200);
            SpecUtil.writeQueryOptions(stringBuilder, queryOptions, 0, null);
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            Class clazz = queryOptions != null ? queryOptions.getClass() : QueryOptions.class;
            _logger.warn((Object)("Failed to generate a string representation of a " + clazz.getName()), (Throwable)exception);
            return "???";
        }
    }

    public static String toString(ResponseSpec responseSpec) {
        if (responseSpec == null) {
            return nullStr;
        }
        try {
            Object object;
            int n;
            int n2;
            String string;
            Object[] objectArray;
            StringBuilder stringBuilder = new StringBuilder(2000);
            stringBuilder.append(responseSpec.getClass().getSimpleName());
            String string2 = SpecUtil.getIndentation(1);
            stringBuilder.append("\n").append(string2).append("Offset: ").append(responseSpec.offset);
            stringBuilder.append("\n").append(string2).append("MaxResultsCount: ").append(responseSpec.maxResultsCount);
            stringBuilder.append("\n").append(string2).append("PropertiesToRetrieve: ");
            if (responseSpec.propertiesToRetrieve != null) {
                objectArray = responseSpec.propertiesToRetrieve;
                string = SpecUtil.getIndentation(2);
                n2 = objectArray.length;
                for (n = 0; n < n2; ++n) {
                    object = objectArray[n];
                    stringBuilder.append("\n");
                    SpecUtil.writePropertySpec(stringBuilder, (PropertySpec)object, n, 2, string);
                }
            } else {
                stringBuilder.append(nullStr);
            }
            stringBuilder.append("\n");
            SpecUtil.writeOrderingCriteria(stringBuilder, responseSpec.orderingCriteria, 1, string2);
            stringBuilder.append("\n").append(string2).append("Facets: ");
            if (responseSpec.facets != null) {
                objectArray = responseSpec.facets;
                string = SpecUtil.getIndentation(2);
                n2 = objectArray.length;
                for (n = 0; n < n2; ++n) {
                    object = objectArray[n];
                    stringBuilder.append("\n");
                    SpecUtil.writeFacetSpec(stringBuilder, (FacetSpec)object, n, 2, string);
                }
            } else {
                stringBuilder.append(nullStr);
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            _logger.warn((Object)("Failed to generate a string representation of a " + responseSpec.getClass().getName()), (Throwable)exception);
            return "???";
        }
    }

    private static String writePropertySpec(StringBuilder stringBuilder, PropertySpec propertySpec, int n, int n2, String string) {
        stringBuilder.append(string).append(PropertySpec.class.getSimpleName());
        if (n >= 0) {
            stringBuilder.append("[").append(n).append("]");
        }
        stringBuilder.append(": ");
        if (propertySpec != null) {
            String string2 = SpecUtil.getIndentation(n2 + 1);
            stringBuilder.append("\n").append(string2).append("ProviderType: ").append(propertySpec.providerType);
            stringBuilder.append("\n").append(string2).append("Properties: ").append(Arrays.toString(propertySpec.properties));
            stringBuilder.append("\n").append(string2).append("Relationship: ").append(propertySpec.relationship);
            return string2;
        }
        stringBuilder.append(nullStr);
        return null;
    }

    private static void writeOrderingPropertySpec(StringBuilder stringBuilder, OrderingPropertySpec orderingPropertySpec, int n, int n2, String string) {
        String string2 = SpecUtil.writePropertySpec(stringBuilder, orderingPropertySpec, n, n2, string);
        if (orderingPropertySpec != null) {
            stringBuilder.append("\n").append(string2).append(SortType.class.getSimpleName()).append(": ").append(orderingPropertySpec.sortType);
        }
    }

    private static void writeOrderingCriteria(StringBuilder stringBuilder, OrderingCriteria orderingCriteria, int n, String string) {
        stringBuilder.append(string).append(OrderingCriteria.class.getSimpleName()).append(": ");
        if (orderingCriteria == null) {
            stringBuilder.append(nullStr);
            return;
        }
        String string2 = SpecUtil.getIndentation(n + 1);
        stringBuilder.append("\n").append(string2).append(OrderingType.class.getSimpleName()).append(": ").append((Object)orderingCriteria.orderingType);
        stringBuilder.append("\n").append(string2).append("ApplicableProperties: ");
        if (orderingCriteria.applicableProperties != null) {
            OrderingPropertySpec[] orderingPropertySpecArray = orderingCriteria.applicableProperties;
            String string3 = SpecUtil.getIndentation(n + 2);
            int n2 = orderingPropertySpecArray.length;
            for (int i = 0; i < n2; ++i) {
                OrderingPropertySpec orderingPropertySpec = orderingPropertySpecArray[i];
                stringBuilder.append("\n");
                SpecUtil.writeOrderingPropertySpec(stringBuilder, orderingPropertySpec, i, 2, string3);
            }
        } else {
            stringBuilder.append(nullStr);
        }
    }

    private static void writeFacetSpec(StringBuilder stringBuilder, FacetSpec facetSpec, int n, int n2, String string) {
        stringBuilder.append(string).append(FacetSpec.class.getSimpleName());
        if (n >= 0) {
            stringBuilder.append("[").append(n).append("]");
        }
        stringBuilder.append(": ");
        if (facetSpec != null) {
            int n3 = n2 + 1;
            String string2 = SpecUtil.getIndentation(n3);
            stringBuilder.append("\n");
            SpecUtil.writePropertySpec(stringBuilder, facetSpec.propSpec, -1, n3, string2);
        } else {
            stringBuilder.append(nullStr);
        }
    }

    private static String getIndentation(int n) {
        if (n <= 0) {
            return "";
        }
        char[] cArray = new char[n * 3];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }
}

