/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.metadata.ObjectModelProvider;
import com.vmware.vise.search.TypeRef;
import com.vmware.vise.util.ValidationUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public final class TypeRefUtils {
    private static final ObjectModelProvider PRIMITIVE_PROVIDER = new PrimitiveTypeProvider();
    private static final String[] EMPTY_TYPE_ARRAY = new String[0];
    private static final String ROOT_TYPE_NAME = "Object";
    private static final String ALL_TYPES = "*";
    private static final String[] DEFAULT_SUPERTYPE_ARRAY = new String[]{"Object"};
    private static final Map<String, TypeRef> TYPEREF_CACHE = new HashMap<String, TypeRef>();
    private static DatatypeFactory _dataTypeFactory = null;
    public static final TypeRef ROOT_TYPEREF;
    public static final TypeRef BYTE_TYPEREF;
    public static final TypeRef SHORT_TYPEREF;
    public static final TypeRef INT_TYPEREF;
    public static final TypeRef LONG_TYPEREF;
    public static final TypeRef FLOAT_TYPEREF;
    public static final TypeRef DOUBLE_TYPEREF;
    public static final TypeRef BOOLEAN_TYPEREF;
    public static final TypeRef STRING_TYPEREF;
    public static final TypeRef XML_TYPEREF;
    public static final TypeRef DATETIME_TYPEREF;
    public static final TypeRef ALL_TYPES_TYPEREF;

    private TypeRefUtils() {
    }

    public static boolean isBooleanType(TypeRef typeRef) {
        if (typeRef == null) {
            return false;
        }
        return BOOLEAN_TYPEREF.equalsIgnoreCase(typeRef);
    }

    public static boolean isNumericType(TypeRef typeRef) {
        if (typeRef == null) {
            return false;
        }
        if (BYTE_TYPEREF.equalsIgnoreCase(typeRef)) {
            return true;
        }
        if (SHORT_TYPEREF.equalsIgnoreCase(typeRef)) {
            return true;
        }
        if (INT_TYPEREF.equalsIgnoreCase(typeRef)) {
            return true;
        }
        if (LONG_TYPEREF.equalsIgnoreCase(typeRef)) {
            return true;
        }
        if (FLOAT_TYPEREF.equalsIgnoreCase(typeRef)) {
            return true;
        }
        return DOUBLE_TYPEREF.equalsIgnoreCase(typeRef);
    }

    public static boolean isTextType(TypeRef typeRef) {
        if (typeRef == null) {
            return false;
        }
        return STRING_TYPEREF.equalsIgnoreCase(typeRef);
    }

    public static Queue<TypeRef> removeLeafNodes(Set<TypeRef> set) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{set});
        LinkedList<TypeRef> linkedList = new LinkedList<TypeRef>();
        for (TypeRef typeRef : set) {
            if (!TypeRefUtils.isLeafNode(typeRef, set)) continue;
            linkedList.add(typeRef);
        }
        set.removeAll(linkedList);
        return linkedList;
    }

    static Object toPrimitiveType(String string, String string2) {
        if (string == null) {
            return string2;
        }
        Object object = string2;
        if (BYTE_TYPEREF.getName().equalsIgnoreCase(string)) {
            object = Byte.parseByte(string2);
            return object;
        }
        if (SHORT_TYPEREF.getName().equalsIgnoreCase(string)) {
            object = Short.parseShort(string2);
            return object;
        }
        if (INT_TYPEREF.getName().equalsIgnoreCase(string)) {
            object = Integer.parseInt(string2);
            return object;
        }
        if (LONG_TYPEREF.getName().equalsIgnoreCase(string)) {
            object = Long.parseLong(string2);
            return object;
        }
        if (FLOAT_TYPEREF.getName().equalsIgnoreCase(string)) {
            object = Float.valueOf(Float.parseFloat(string2));
            return object;
        }
        if (DOUBLE_TYPEREF.getName().equalsIgnoreCase(string)) {
            object = Double.parseDouble(string2);
            return object;
        }
        if (BOOLEAN_TYPEREF.getName().equalsIgnoreCase(string)) {
            object = Boolean.parseBoolean(string2);
            return object;
        }
        if (STRING_TYPEREF.getName().equalsIgnoreCase(string)) {
            return object;
        }
        if (XML_TYPEREF.getName().equalsIgnoreCase(string)) {
            return object;
        }
        if (DATETIME_TYPEREF.getName().equalsIgnoreCase(string)) {
            XMLGregorianCalendar xMLGregorianCalendar = _dataTypeFactory.newXMLGregorianCalendar(string2);
            Date date = xMLGregorianCalendar.toGregorianCalendar().getTime();
            return date;
        }
        return object;
    }

    static Collection<TypeRef> getPrimitiveTypes() {
        Collection<TypeRef> collection = TYPEREF_CACHE.values();
        return collection;
    }

    private static boolean isLeafNode(TypeRef typeRef, Set<TypeRef> set) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{typeRef, set});
        for (TypeRef typeRef2 : set) {
            if (typeRef2.isAssignableFrom(typeRef)) continue;
            return false;
        }
        return true;
    }

    private static TypeRef getInstance(String string) {
        assert (string != null);
        TypeRef typeRef = new TypeRef(string, PRIMITIVE_PROVIDER);
        TYPEREF_CACHE.put(string, typeRef);
        return typeRef;
    }

    static {
        try {
            _dataTypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new IllegalStateException("Exception while obtaining DatatypeFactory instance", datatypeConfigurationException);
        }
        ROOT_TYPEREF = TypeRefUtils.getInstance(ROOT_TYPE_NAME);
        BYTE_TYPEREF = TypeRefUtils.getInstance("byte");
        SHORT_TYPEREF = TypeRefUtils.getInstance("short");
        INT_TYPEREF = TypeRefUtils.getInstance("int");
        LONG_TYPEREF = TypeRefUtils.getInstance("long");
        FLOAT_TYPEREF = TypeRefUtils.getInstance("float");
        DOUBLE_TYPEREF = TypeRefUtils.getInstance("double");
        BOOLEAN_TYPEREF = TypeRefUtils.getInstance("boolean");
        STRING_TYPEREF = TypeRefUtils.getInstance("string");
        XML_TYPEREF = TypeRefUtils.getInstance("XML");
        DATETIME_TYPEREF = TypeRefUtils.getInstance("dateTime");
        ALL_TYPES_TYPEREF = TypeRefUtils.getInstance(ALL_TYPES);
    }

    private static final class PrimitiveTypeProvider
    implements ObjectModelProvider {
        private PrimitiveTypeProvider() {
        }

        public String[] getSuperTypes(String string) {
            if (TypeRefUtils.ROOT_TYPE_NAME.equals(string)) {
                return EMPTY_TYPE_ARRAY;
            }
            return DEFAULT_SUPERTYPE_ARRAY;
        }

        public String getImmediateSuperType(String string) {
            if (TypeRefUtils.ROOT_TYPE_NAME.equals(string)) {
                return null;
            }
            return TypeRefUtils.ROOT_TYPE_NAME;
        }
    }
}

