/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.impl;

import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.search.CompositeConstraint;
import com.vmware.vise.search.Constraint;
import com.vmware.vise.search.FacetSpec;
import com.vmware.vise.search.ObjectIdentityConstraint;
import com.vmware.vise.search.PropertySpec;
import com.vmware.vise.search.QuerySpec;
import com.vmware.vise.search.RelationalConstraint;
import com.vmware.vise.search.ResponseSpec;
import com.vmware.vise.search.SimplePropertyConstraint;
import com.vmware.vise.search.impl.ConstraintTreeExprBuilder;
import com.vmware.vise.search.impl.FacetExprGenerator;
import com.vmware.vise.search.impl.NamespaceUtils;
import com.vmware.vise.search.impl.TypeRefDirectory;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.metadata.MetadataUtil;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.metadata.RelationDescriptor;
import com.vmware.vise.search.util.QueryGenerator;
import com.vmware.vise.search.xquery.XQueryUtils;
import com.vmware.vise.search.xquery.render.RendererFactory;
import com.vmware.vise.search.xquery.render.ReturnClauseGenerator;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class XQueryGenerator
implements QueryGenerator {
    private static final Logger _logger = LoggerFactory.getLogger(XQueryGenerator.class);
    private static final String QUERY_NAMESPACE_DECL = String.format("declare namespace %1$s=\"%1$s\";\n", "query");
    private static final String STATIC_NAMESPACE_DECLS = "import module namespace tagging = 'urn:vmware:queryservice:tagging' at '/builtin-functions/tagging';\ndeclare namespace qs=\"urn:vmware:queryservice\";\n" + QUERY_NAMESPACE_DECL + "declare default element namespace \"urn:vim25\";\n" + "declare namespace vapi=\"" + "urn:vim25" + "\";\n" + "declare namespace xlink=\"http://www.w3.org/1999/xlink\";\n" + "declare option xhive:fts-analyzer-class \"com.vmware.vim.query.server.store.impl.CaseInsensitiveWhitespaceAnalyzer\";";
    private static final String EMPTY_FACET_SET = "let $facets := ()";
    private static final String FINAL_RETURN = "return <%1$s:%2$s xmlns:qs=\"urn:vmware:queryservice\" xmlns:%1$s=\"%1$s\" xmlns:%4$s=\"%5$s\" xmlns=\"%5$s\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" %1$s:%3$s=\"{local:serviceUuid()}\">{$itemCount,$items,$facets,$resultSorted}</%1$s:%2$s>";
    private static String FORMATTED_RETURN_CLAUSE = String.format("return <%1$s:%2$s xmlns:qs=\"urn:vmware:queryservice\" xmlns:%1$s=\"%1$s\" xmlns:%4$s=\"%5$s\" xmlns=\"%5$s\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" %1$s:%3$s=\"{local:serviceUuid()}\">{$itemCount,$items,$facets,$resultSorted}</%1$s:%2$s>", "query", "result", "serviceUuid", "vapi", "urn:vim25");
    private static final String NAMESPACE_PREFIX = "urn:";
    private final MetadataDirectory _metadataDirectory;
    private final TypeRefDirectory _typeRefDirectory;
    private final RendererFactory _rendererFactory;

    public XQueryGenerator(TypeRefDirectory typeRefDirectory, MetadataDirectory metadataDirectory, RendererFactory rendererFactory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{typeRefDirectory, metadataDirectory, rendererFactory});
        this._metadataDirectory = metadataDirectory;
        this._typeRefDirectory = typeRefDirectory;
        this._rendererFactory = rendererFactory;
    }

    @Override
    public String generate(QuerySpec querySpec, ResponseSpec responseSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{querySpec, responseSpec});
        String string = this.generateCoreSelectionQuery(querySpec, responseSpec);
        String string2 = EMPTY_FACET_SET + "\n" + string + "\n\n" + FORMATTED_RETURN_CLAUSE;
        String string3 = XQueryUtils.functionDefinitionsIfApplicable(this._metadataDirectory, string2);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.getTypes(querySpec.constraint));
        hashSet.addAll(this.getQueryElements(responseSpec));
        Set<String> set = XQueryGenerator.getNamespaces(hashSet);
        String string4 = XQueryGenerator.generateNamespaceDeclarations(set);
        StringBuilder stringBuilder = new StringBuilder();
        if (!StringUtil.isNullOrEmpty((String)querySpec.name)) {
            stringBuilder.append("(: Query name: ").append(querySpec.name).append(" :)\n");
        }
        stringBuilder.append(string4).append(STATIC_NAMESPACE_DECLS).append("\n").append(string3).append("\n").append(string2);
        string2 = stringBuilder.toString();
        return string2;
    }

    private String generateCoreSelectionQuery(QuerySpec querySpec, ResponseSpec responseSpec) {
        assert (querySpec != null);
        assert (responseSpec != null);
        ConstraintTreeExprBuilder constraintTreeExprBuilder = new ConstraintTreeExprBuilder(querySpec.constraint, this._typeRefDirectory, this._metadataDirectory, this._rendererFactory);
        String string = constraintTreeExprBuilder.toExprString();
        String string2 = this.toFacetClause(responseSpec);
        ReturnClauseGenerator returnClauseGenerator = this._rendererFactory.newReturnClauseGenerator(querySpec);
        String string3 = returnClauseGenerator.generate(responseSpec);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("\n").append(string2).append("\n\n").append(string3);
        String string4 = stringBuilder.toString();
        return string4;
    }

    private String toFacetClause(ResponseSpec responseSpec) {
        assert (responseSpec != null);
        FacetExprGenerator facetExprGenerator = new FacetExprGenerator(this._metadataDirectory, this._rendererFactory);
        String string = facetExprGenerator.generateQueryExprForFacetSpecs(responseSpec.facets);
        return string;
    }

    private static Set<String> getNamespaces(Set<String> set) {
        assert (set != null);
        HashSet<String> hashSet = new HashSet<String>(set.size());
        for (String string : set) {
            String string2 = NamespaceUtils.getNamespace(string);
            if (string2 == null) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    private static String generateNamespaceDeclarations(Set<String> set) {
        assert (set != null);
        assert (!set.contains(null));
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : set) {
            String string2;
            if (string.contains(":")) {
                _logger.error("namespaces containing colons not yet supported: " + string);
            }
            if (STATIC_NAMESPACE_DECLS.contains(string2 = "declare namespace " + string + "=")) continue;
            String string3 = String.format("%1$s\"%2$s%3$s\";\n", string2, NAMESPACE_PREFIX, string);
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private Set<String> getQueryElements(ResponseSpec responseSpec) {
        if (responseSpec == null) {
            return Collections.emptySet();
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (responseSpec.propertiesToRetrieve != null) {
            for (PropertySpec object : responseSpec.propertiesToRetrieve) {
                this.harvestQueryElements(object, hashSet);
            }
        }
        if (responseSpec.facets != null) {
            for (FacetSpec facetSpec : responseSpec.facets) {
                this.harvestQueryElements(facetSpec.propSpec, hashSet);
            }
        }
        return hashSet;
    }

    private void harvestQueryElements(PropertySpec propertySpec, Set<String> set) {
        String[] stringArray;
        String string;
        assert (set != null);
        if (propertySpec == null) {
            return;
        }
        String string2 = propertySpec.providerType;
        if (string2 != null) {
            set.add(string2);
        }
        if ((string = propertySpec.relationship) != null) {
            set.add(string);
        }
        if ((stringArray = propertySpec.properties) == null) {
            return;
        }
        for (String string3 : stringArray) {
            if (string3 == null) continue;
            PropertyDescriptor propertyDescriptor = this._metadataDirectory.getPropertyDescriptor(string3, string2);
            set.add(propertyDescriptor.getType());
            set.add(string3);
        }
    }

    private Set<String> getTypes(Constraint constraint) {
        Object object;
        Object object2;
        assert (constraint != null);
        HashSet<String> hashSet = new HashSet<String>();
        if (constraint instanceof ObjectIdentityConstraint) {
            object2 = (ObjectIdentityConstraint)constraint;
            object = object2.getTarget();
            String string = QueryUtil.getReferenceType((Object)object);
            hashSet.add(string);
        }
        if (constraint instanceof CompositeConstraint) {
            object2 = (CompositeConstraint)constraint;
            object = this.getNestedTypes((CompositeConstraint)object2);
            hashSet.addAll((Collection<String>)object);
        }
        if (constraint instanceof RelationalConstraint) {
            object2 = (RelationalConstraint)constraint;
            object = this.getNestedTypes((RelationalConstraint)object2);
            hashSet.addAll((Collection<String>)object);
        }
        if (constraint instanceof SimplePropertyConstraint) {
            object2 = (SimplePropertyConstraint)constraint;
            object = object2.getProperty();
            hashSet.add((String)object);
        }
        object2 = constraint.getSearchTarget();
        hashSet.add((String)object2);
        return hashSet;
    }

    private Set<String> getNestedTypes(CompositeConstraint compositeConstraint) {
        Constraint[] constraintArray;
        assert (compositeConstraint != null);
        HashSet<String> hashSet = new HashSet<String>();
        for (Constraint constraint : constraintArray = compositeConstraint.getNestedConstraints()) {
            Set<String> set = this.getTypes(constraint);
            hashSet.addAll(set);
        }
        return hashSet;
    }

    private Set<String> getNestedTypes(RelationalConstraint relationalConstraint) {
        assert (relationalConstraint != null);
        HashSet<String> hashSet = new HashSet<String>();
        RelationDescriptor relationDescriptor = MetadataUtil.getRelationFromSpec(this._metadataDirectory, relationalConstraint.getRelationSpec());
        String string = MetadataUtil.getSourceType(relationDescriptor, this._metadataDirectory);
        hashSet.add(string);
        String string2 = MetadataUtil.getTargetType(relationDescriptor, this._metadataDirectory);
        hashSet.add(string2);
        Set<String> set = this.getTypes(relationalConstraint.getNestedConstraint());
        hashSet.addAll(set);
        return hashSet;
    }
}

