/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.metadata;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

final class ChildNodeIndex {
    private final Node _rootNode;
    private final Multimap<String, Node> _nodesByName = LinkedHashMultimap.create();

    ChildNodeIndex(Node node) {
        assert (node != null);
        this._rootNode = node;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            String string = node2.getNodeName();
            this._nodesByName.put((Object)string, (Object)node2);
        }
    }

    Node getRootNode() {
        return this._rootNode;
    }

    Collection<Node> getNodes(String string) {
        assert (string != null);
        return this._nodesByName.get((Object)string);
    }

    String getStringValueFor(String string, String string2) {
        String string3 = this.getStringValueFor(string, true);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    boolean getBooleanValueFor(String string, boolean bl) {
        String string2 = this.getStringValueFor(string, bl);
        return "true".equals(string2);
    }

    String getStringValueFor(String string, boolean bl) {
        assert (string != null);
        Collection collection = this._nodesByName.get((Object)string);
        if (collection.isEmpty()) {
            if (!bl) {
                throw new IllegalStateException("Required element not found: " + string);
            }
            return null;
        }
        Node node = (Node)collection.iterator().next();
        return node.getTextContent();
    }

    String[] getStringValuesFor(String string, boolean bl) {
        assert (string != null);
        Collection collection = this._nodesByName.get((Object)string);
        if (collection.isEmpty()) {
            if (!bl) {
                throw new IllegalStateException("Required element not found: " + string);
            }
            return new String[0];
        }
        String[] stringArray = new String[collection.size()];
        int n = 0;
        for (Node node : collection) {
            stringArray[n] = node.getTextContent();
        }
        return stringArray;
    }
}

