/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.metadata;

import com.vmware.vise.search.metadata.Descriptor;
import com.vmware.vise.util.i18n.MessageLocalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class DescriptorData<T extends Descriptor> {
    private final T _desc;
    private final MessageLocalizer _msgLoc;
    private volatile int _cachedHashCode;

    DescriptorData(T t, MessageLocalizer messageLocalizer) {
        if (t == null) {
            throw new IllegalArgumentException("The descriptor shouldn't be null");
        }
        this._desc = t;
        this._msgLoc = messageLocalizer;
    }

    T getDescriptor() {
        return this._desc;
    }

    MessageLocalizer getMessageLocalizer() {
        return this._msgLoc;
    }

    public static <T extends Descriptor> List<T> extractDescriptors(Collection<DescriptorData<T>> collection) {
        if (collection == null) {
            return null;
        }
        int n = collection.size();
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (DescriptorData<T> descriptorData : collection) {
            arrayList.add(descriptorData != null ? (Object)descriptorData.getDescriptor() : null);
        }
        return arrayList;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DescriptorData) {
            DescriptorData descriptorData = (DescriptorData)object;
            return this._desc.equals(descriptorData._desc) && (this._msgLoc == null ? descriptorData._msgLoc == null : this._msgLoc.equals(descriptorData._msgLoc));
        }
        return false;
    }

    public int hashCode() {
        int n = this._cachedHashCode;
        if (n == 0) {
            n = 17;
            n = 31 * n + this._desc.hashCode();
            this._cachedHashCode = n = 31 * n + (this._msgLoc != null ? this._msgLoc.hashCode() : 0);
        }
        return n;
    }
}

