/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.metadata;

import com.vmware.vise.search.metadata.DescriptorDirectoryStoreAccess;
import com.vmware.vise.search.metadata.FunctionDescriptor;
import com.vmware.vise.search.metadata.FunctionDescriptorDirectory;
import com.vmware.vise.util.i18n.MessageLocalizer;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class FunctionDescriptorDirectoryImpl
implements FunctionDescriptorDirectory,
DescriptorDirectoryStoreAccess<FunctionDescriptor> {
    private static final Log _logger = LogFactory.getLog(FunctionDescriptorDirectoryImpl.class);
    private final ConcurrentMap<String, FunctionDescriptor> _localFunctions = new ConcurrentHashMap<String, FunctionDescriptor>();

    FunctionDescriptorDirectoryImpl() {
    }

    @Override
    public FunctionDescriptor getFunctionDescriptor(String string) {
        FunctionDescriptor functionDescriptor = (FunctionDescriptor)this._localFunctions.get(string);
        return functionDescriptor;
    }

    @Override
    public void addAll(Collection<FunctionDescriptor> collection, MessageLocalizer messageLocalizer) {
        for (FunctionDescriptor functionDescriptor : collection) {
            FunctionDescriptor functionDescriptor2 = this._localFunctions.putIfAbsent(functionDescriptor.getName(), functionDescriptor);
            if (functionDescriptor2 == functionDescriptor || !_logger.isDebugEnabled()) continue;
            String string = "FunctionDescriptor not added. Previous descriptor found: ";
            string = string + functionDescriptor.getName();
            _logger.debug((Object)string);
        }
    }

    @Override
    public void clearAll() {
        this._localFunctions.clear();
    }
}

