/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.search.metadata;

import com.vmware.vise.search.PropertyInfo;
import com.vmware.vise.search.QueryContextType;
import com.vmware.vise.search.QueryExprInfo;
import com.vmware.vise.search.RelationSpec;
import com.vmware.vise.search.impl.NamespaceUtils;
import com.vmware.vise.search.impl.TypeRefDirectory;
import com.vmware.vise.search.impl.TypeRefUtils;
import com.vmware.vise.search.metadata.ChildNodeIndex;
import com.vmware.vise.search.metadata.CodeFlavor;
import com.vmware.vise.search.metadata.Descriptor;
import com.vmware.vise.search.metadata.DescriptorSource;
import com.vmware.vise.search.metadata.DescriptorSourceImpl;
import com.vmware.vise.search.metadata.DirectoryContainer;
import com.vmware.vise.search.metadata.FunctionDescriptor;
import com.vmware.vise.search.metadata.FunctionDescriptorImpl;
import com.vmware.vise.search.metadata.MetadataDirectory;
import com.vmware.vise.search.metadata.MetadataDirectoryImpl;
import com.vmware.vise.search.metadata.PropertyDescriptor;
import com.vmware.vise.search.metadata.PropertyDescriptorDirectory;
import com.vmware.vise.search.metadata.PropertyDescriptorImpl;
import com.vmware.vise.search.metadata.PropertyDescriptorOption;
import com.vmware.vise.search.metadata.RelationDescriptor;
import com.vmware.vise.search.metadata.RelationDescriptorImpl;
import com.vmware.vise.search.metadata.TypeDescriptor;
import com.vmware.vise.search.metadata.TypeDescriptorImpl;
import com.vmware.vise.search.util.Resources;
import com.vmware.vise.util.Predicate;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class MetadataUtil {
    private static final Logger _logger = LoggerFactory.getLogger(MetadataUtil.class);
    static final String TYPE_DOC_NODE = "./TypeDescriptor";
    static final String PROPERTY_DOC_NODE = "./PropertyDescriptor";
    static final String RELATIONSHIP_DOC_NODE = "./RelationDescriptor";
    static final String FUNCTION_DOC_NODE = "./definition";
    private static final String PRODUCT_ATTRIBUE = "productId";
    private static final String RESOURCE_BUNDLE_NAME = "Search";
    private static final String METADATA_RES_NAMESPACE = "/metadata";
    private static final String[] EMBEDDED_METADATA_SOURCES = new String[]{"types", "properties", "relationships", "functions"};
    private static final String EMBEDDED_RESOURCE_BUNDLE_NAME = "SearchInternal";
    public static final String STATUS_UNSUPPORTED = "unsupported";
    public static final String MANAGED_ENTITY = "ManagedEntity";
    public static final String PROPERTY_NAME = "name";
    private static final String[] UNSUPPORTED_PROPERTY_KEYS = new String[]{"@info", "_content", "@propertyInfo", "@typeInfo"};

    public static String getQueryExpression(Descriptor descriptor) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{descriptor});
        String string = MetadataUtil.getQueryExpression(descriptor, QueryContextType.CONTEXT_NONE);
        return string;
    }

    public static String getQueryExpression(Descriptor descriptor, QueryContextType queryContextType) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{descriptor, queryContextType});
        List<QueryExprInfo> list = descriptor.getQueryExpressions();
        for (QueryExprInfo queryExprInfo : list) {
            if (!queryContextType.equals((Object)queryExprInfo.queryType)) continue;
            String string = StringUtil.stripExcessWhitespace((String)queryExprInfo.expression);
            return string;
        }
        for (QueryExprInfo queryExprInfo : list) {
            if (!QueryContextType.CONTEXT_NONE.equals((Object)queryExprInfo.queryType)) continue;
            String string = StringUtil.stripExcessWhitespace((String)queryExprInfo.expression);
            return string;
        }
        return null;
    }

    public static boolean isSupported(Descriptor descriptor) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{descriptor});
        if (STATUS_UNSUPPORTED.equals(descriptor.getStatus())) {
            return false;
        }
        if (descriptor instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
            String string = propertyDescriptor.getName();
            for (String string2 : UNSUPPORTED_PROPERTY_KEYS) {
                if (string == null || !string.contains(string2)) continue;
                return false;
            }
        }
        return true;
    }

    public static RelationDescriptor getRelationFromSpec(MetadataDirectory metadataDirectory, RelationSpec relationSpec) {
        PropertyDescriptor propertyDescriptor = metadataDirectory.getPropertyDescriptor(relationSpec.getRelation(), relationSpec.getSourceType());
        RelationDescriptor relationDescriptor = metadataDirectory.getRelationDescriptor(propertyDescriptor);
        if (relationSpec.isInverse()) {
            String string = relationDescriptor.getInverseId();
            relationDescriptor = metadataDirectory.getRelationDescriptor(string);
        }
        return relationDescriptor;
    }

    public static PropertyDescriptor getProperty(RelationDescriptor relationDescriptor, PropertyDescriptorDirectory propertyDescriptorDirectory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{relationDescriptor, propertyDescriptorDirectory});
        String string = relationDescriptor.getSourceType();
        String string2 = relationDescriptor.getPropertyName();
        PropertyDescriptor propertyDescriptor = propertyDescriptorDirectory.getPropertyDescriptor(string2, string);
        return propertyDescriptor;
    }

    public static String getSourceType(RelationDescriptor relationDescriptor, PropertyDescriptorDirectory propertyDescriptorDirectory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{relationDescriptor, propertyDescriptorDirectory});
        PropertyDescriptor propertyDescriptor = MetadataUtil.getProperty(relationDescriptor, propertyDescriptorDirectory);
        String string = propertyDescriptor.getProvider();
        return string;
    }

    public static String getTargetType(RelationDescriptor relationDescriptor, MetadataDirectory metadataDirectory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{relationDescriptor, metadataDirectory});
        PropertyDescriptor propertyDescriptor = MetadataUtil.getProperty(relationDescriptor, metadataDirectory);
        String string = propertyDescriptor.getType();
        if (string == null) {
            String string2 = relationDescriptor.getInverseId();
            RelationDescriptor relationDescriptor2 = metadataDirectory.getRelationDescriptor(string2);
            string = relationDescriptor2.getSourceType();
        }
        return string;
    }

    public static String getNamespace(PropertyInfo propertyInfo) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyInfo});
        String string = propertyInfo.getType();
        if (string != null && string.indexOf(58) != -1) {
            String string2 = NamespaceUtils.getNamespace(string);
            return string2;
        }
        String string3 = propertyInfo.getName();
        if (string3 != null && string3.indexOf(58) != -1) {
            String string4 = NamespaceUtils.getNamespace(string3);
            return string4;
        }
        String string5 = propertyInfo.getProvider();
        String string6 = NamespaceUtils.getNamespace(string5);
        return string6;
    }

    public static boolean isMultiCardinality(RelationDescriptor relationDescriptor, MetadataDirectory metadataDirectory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{relationDescriptor, metadataDirectory});
        PropertyDescriptor propertyDescriptor = MetadataUtil.getProperty(relationDescriptor, metadataDirectory);
        boolean bl = propertyDescriptor.isMultiCardinality();
        return bl;
    }

    public static Map<CodeFlavor, MetadataDirectory> newMetadataDirectory(TypeRefDirectory typeRefDirectory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{typeRefDirectory});
        Map<CodeFlavor, DirectoryContainer> map = DirectoryContainer.Factory.createContainersPerFlavour(typeRefDirectory);
        EnumMap<CodeFlavor, MetadataDirectory> enumMap = new EnumMap<CodeFlavor, MetadataDirectory>(CodeFlavor.class);
        for (CodeFlavor codeFlavor : CodeFlavor.values()) {
            enumMap.put(codeFlavor, new MetadataDirectoryImpl(typeRefDirectory, map.get((Object)codeFlavor)));
        }
        return enumMap;
    }

    public static DescriptorSource getDescriptorSource(String string, Document document, ClassLoader classLoader) {
        return MetadataUtil.getDescriptorSource(string, document, classLoader, null);
    }

    public static DescriptorSource getDescriptorSource(String string, Document document, ClassLoader classLoader, String string2) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{document});
        List<TypeDescriptor> list = MetadataUtil.loadMetadata(document, TYPE_DOC_NODE, TypeDescriptorImpl.class, classLoader);
        List<PropertyDescriptor> list2 = MetadataUtil.loadMetadata(document, PROPERTY_DOC_NODE, PropertyDescriptorImpl.class, classLoader);
        List<RelationDescriptor> list3 = MetadataUtil.loadMetadata(document, RELATIONSHIP_DOC_NODE, RelationDescriptorImpl.class);
        List<FunctionDescriptor> list4 = MetadataUtil.loadMetadata(document, FUNCTION_DOC_NODE, FunctionDescriptorImpl.class);
        DescriptorSourceImpl descriptorSourceImpl = new DescriptorSourceImpl(string, list, list2, list3, list4, classLoader, string2);
        return descriptorSourceImpl;
    }

    public static DescriptorSource getEmbeddedDescriptorSource(String string) {
        ArrayList<DescriptorSource> arrayList = new ArrayList<DescriptorSource>(EMBEDDED_METADATA_SOURCES.length);
        ClassLoader classLoader = MetadataUtil.class.getClassLoader();
        for (String string2 : EMBEDDED_METADATA_SOURCES) {
            _logger.debug("Start processing embedded metadata from: {}", (Object)string2);
            Document document = MetadataUtil.loadXmlResources(string2);
            DescriptorSource descriptorSource = MetadataUtil.getDescriptorSource(string2, document, classLoader, EMBEDDED_RESOURCE_BUNDLE_NAME);
            arrayList.add(descriptorSource);
            _logger.debug("The embedded metadata have been processed from: {}", (Object)string2);
        }
        DescriptorSource descriptorSource = MetadataUtil.getMergedDescriptorSource(string, arrayList, EMBEDDED_RESOURCE_BUNDLE_NAME);
        return descriptorSource;
    }

    static DescriptorSource loadSearchBundleMetadata(String string) {
        ClassLoader classLoader = MetadataUtil.class.getClassLoader();
        Document document = MetadataUtil.loadXmlResources(string);
        return MetadataUtil.getDescriptorSource(string, document, classLoader);
    }

    static Map<String, String> extractTags(ChildNodeIndex childNodeIndex) {
        assert (childNodeIndex != null);
        Collection<Node> collection = childNodeIndex.getNodes("tags");
        if (collection.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Node node : collection) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (1 != node2.getNodeType()) continue;
                hashMap.put(node2.getNodeName(), node2.getTextContent());
            }
        }
        return Collections.unmodifiableMap(hashMap);
    }

    static List<QueryExprInfo> getDefaultQueryInfo(String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        QueryExprInfo queryExprInfo = new QueryExprInfo();
        queryExprInfo.expression = string;
        queryExprInfo.queryType = QueryContextType.CONTEXT_NONE;
        List<QueryExprInfo> list = Collections.singletonList(queryExprInfo);
        return list;
    }

    static List<QueryExprInfo> extractQueryExpressions(ChildNodeIndex childNodeIndex) {
        assert (childNodeIndex != null);
        Collection<Node> collection = childNodeIndex.getNodes("expr");
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QueryExprInfo> arrayList = new ArrayList<QueryExprInfo>(collection.size());
        String string = XMLUtil.getParentAttribute((Node)childNodeIndex.getRootNode(), (String)PRODUCT_ATTRIBUE);
        for (Node node : collection) {
            String string2;
            Element element = (Element)node;
            QueryContextType queryContextType = QueryContextType.CONTEXT_NONE;
            Attr attr = element.getAttributeNode("context");
            if (attr != null) {
                string2 = attr.getValue();
                if (string2.equals("current")) {
                    queryContextType = QueryContextType.CONTEXT_CURRENT;
                } else if (string2.equals("bounded")) {
                    queryContextType = QueryContextType.CONTEXT_BOUNDED;
                }
            }
            string2 = node.getTextContent();
            if (string != null) {
                string2 = MetadataUtil.getScopedQueryExpr(string2, string);
            }
            QueryExprInfo queryExprInfo = new QueryExprInfo();
            queryExprInfo.queryType = queryContextType;
            queryExprInfo.expression = string2;
            arrayList.add(queryExprInfo);
        }
        return Collections.unmodifiableList(arrayList);
    }

    static String getLocalizedString(String string, ClassLoader classLoader) {
        return MetadataUtil.getLocalizedString(string, classLoader, RESOURCE_BUNDLE_NAME);
    }

    static String getLocalizedString(String string, ClassLoader classLoader, String string2) {
        if (string == null) {
            return null;
        }
        if (classLoader == null) {
            return string;
        }
        String string3 = ResourceUtil.getString((String)string2, (String)string, (ClassLoader)classLoader);
        if (string3 != null) {
            return string3;
        }
        return string;
    }

    static String getLocalizedString(String string, String[] stringArray, ClassLoader classLoader) {
        return MetadataUtil.getLocalizedString(string, stringArray, classLoader, RESOURCE_BUNDLE_NAME);
    }

    static String getLocalizedString(String string, String[] stringArray, ClassLoader classLoader, String string2) {
        if (string == null) {
            return null;
        }
        if (classLoader == null) {
            return string;
        }
        String string3 = ResourceUtil.getString((String)string2, (String)string, (String[])stringArray, (ClassLoader)classLoader);
        if (string3 != null) {
            return string3;
        }
        return string;
    }

    static <T> List<T> loadMetadata(Document document, String string, Class<? extends T> clazz, ClassLoader classLoader) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{document, string, clazz});
        NodeList nodeList = XMLUtil.selectNodes((Element)document.getDocumentElement(), (String)string);
        List<T> list = new ArrayList(nodeList.getLength());
        Constructor<? extends T> constructor = MetadataUtil.getConstructor(clazz, Node.class, ClassLoader.class);
        if (constructor == null) {
            return Collections.emptyList();
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            T t = MetadataUtil.getElement(constructor, node, classLoader);
            list.add(t);
        }
        list = Collections.unmodifiableList(list);
        return list;
    }

    static <T> List<T> loadMetadata(Document document, String string, Class<? extends T> clazz) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{document, string, clazz});
        NodeList nodeList = XMLUtil.selectNodes((Element)document.getDocumentElement(), (String)string);
        List<T> list = new ArrayList(nodeList.getLength());
        Constructor<? extends T> constructor = MetadataUtil.getConstructor(clazz, Node.class);
        if (constructor == null) {
            return Collections.emptyList();
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            T t = MetadataUtil.getElement(constructor, node);
            list.add(t);
        }
        list = Collections.unmodifiableList(list);
        return list;
    }

    static String getQueryExprForPropertyPath(String string, String string2) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        String string3 = string2;
        if (string.indexOf(58) != -1) {
            if (string.indexOf(46) == -1) {
                return string;
            }
            string3 = NamespaceUtils.getNamespace(string);
            string = NamespaceUtils.getSimpleName(string);
        }
        String string4 = string;
        if (string3 != null) {
            String string5 = "([^./]+)";
            String string6 = String.format("%1$s:$1", string3);
            Pattern pattern = Pattern.compile(string5);
            Matcher matcher = pattern.matcher(string);
            string4 = matcher.replaceAll(string6);
        }
        string4 = string4.replace('.', '/');
        return string4;
    }

    private static DescriptorSource getMergedDescriptorSource(String string, Collection<DescriptorSource> collection, String string2) {
        assert (!StringUtil.isNullOrEmpty((String)string));
        assert (collection != null);
        assert (!collection.contains(null));
        ArrayList<TypeDescriptor> arrayList = new ArrayList<TypeDescriptor>();
        ArrayList<PropertyDescriptor> arrayList2 = new ArrayList<PropertyDescriptor>();
        ArrayList<RelationDescriptor> arrayList3 = new ArrayList<RelationDescriptor>();
        ArrayList<FunctionDescriptor> arrayList4 = new ArrayList<FunctionDescriptor>();
        ClassLoader classLoader = null;
        for (DescriptorSource descriptorSource : collection) {
            arrayList.addAll(descriptorSource.getTypes());
            arrayList2.addAll(descriptorSource.getProperties());
            arrayList3.addAll(descriptorSource.getTypeRelationships());
            arrayList4.addAll(descriptorSource.getLocalFunctions());
            ClassLoader classLoader2 = descriptorSource.getResourceClassLoader();
            if (classLoader2 == null) {
                classLoader2 = MetadataUtil.class.getClassLoader();
            }
            if (classLoader != null && !classLoader.equals(classLoader2)) {
                throw new IllegalArgumentException("The descriptor sources that must be merged must have one and the same ClassLoader.");
            }
            classLoader = classLoader2;
        }
        if (classLoader == null) {
            classLoader = MetadataUtil.class.getClassLoader();
        }
        DescriptorSourceImpl descriptorSourceImpl = new DescriptorSourceImpl(string, arrayList, arrayList2, arrayList3, arrayList4, classLoader, string2);
        return descriptorSourceImpl;
    }

    private static Document loadXmlResources(String string) {
        assert (string != null);
        Document document = Resources.loadXmlResource(Resources.class, METADATA_RES_NAMESPACE, string);
        return document;
    }

    private static String getScopedQueryExpr(String string, String string2) {
        assert (string != null);
        assert (string2 != null);
        String string3 = "(^|\\s|,|\\()//";
        String string4 = String.format("$1local:product('%1$s')//", string2);
        Pattern pattern = Pattern.compile(string3);
        Matcher matcher = pattern.matcher(string);
        String string5 = matcher.replaceAll(string4);
        return string5;
    }

    private static <T> Constructor<? extends T> getConstructor(Class<T> clazz, Class<?> ... classArray) {
        assert (clazz != null);
        try {
            Constructor<T> constructor = clazz.getConstructor(classArray);
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            _logger.error("Constructor not found for implClass" + clazz.getName());
            return null;
        }
    }

    private static <T> T getElement(Constructor<? extends T> constructor, Object ... objectArray) {
        assert (constructor != null);
        try {
            T t = constructor.newInstance(objectArray);
            return t;
        }
        catch (Exception exception) {
            _logger.error("Error while reflectively calling constructor", (Throwable)exception);
            return null;
        }
    }

    public static Collection<TypeDescriptor> getSearchableTypes(final MetadataDirectory metadataDirectory) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{metadataDirectory});
        List<TypeDescriptor> list = metadataDirectory.getAllTypeDescriptors();
        Predicate<TypeDescriptor> predicate = new Predicate<TypeDescriptor>(){

            public boolean evaluate(TypeDescriptor typeDescriptor) {
                if (typeDescriptor.getType().equals(TypeRefUtils.ROOT_TYPEREF.getName()) || typeDescriptor.getType().equals(MetadataUtil.MANAGED_ENTITY)) {
                    return false;
                }
                if (!MetadataUtil.isSupported(typeDescriptor)) {
                    return false;
                }
                if (!metadataDirectory.hasPreDefinedDescriptor(typeDescriptor.getType(), MetadataUtil.PROPERTY_NAME)) {
                    return false;
                }
                Map<String, String> map = typeDescriptor.getTags();
                if (map == null) {
                    return false;
                }
                String string = map.get(PropertyDescriptorOption.SEARCHABLE.toString());
                if (StringUtil.isNullOrEmpty((String)string)) {
                    return false;
                }
                return string.equals(Boolean.TRUE.toString());
            }
        };
        Set set = CollectionUtil.filter(list, (Predicate)predicate);
        return set;
    }

    public static RelationDescriptor[] getRelationshipHops(MetadataDirectory metadataDirectory, String string, String string2) {
        String[] stringArray;
        assert (string2 != null);
        assert (string != null);
        ArrayList<RelationDescriptor> arrayList = new ArrayList<RelationDescriptor>();
        String string3 = string;
        for (String string4 : stringArray = StringUtils.split((String)string2, (String)";")) {
            PropertyDescriptor propertyDescriptor = metadataDirectory.getPropertyDescriptor(string4, string3);
            RelationDescriptor relationDescriptor = metadataDirectory.getRelationDescriptor(propertyDescriptor);
            arrayList.add(relationDescriptor);
            string3 = MetadataUtil.getTargetType(relationDescriptor, metadataDirectory);
        }
        return arrayList.toArray(new RelationDescriptor[0]);
    }

    public static boolean isRelationshipSupported(RelationDescriptor[] relationDescriptorArray) {
        assert (relationDescriptorArray != null);
        for (RelationDescriptor relationDescriptor : relationDescriptorArray) {
            if (MetadataUtil.isSupported(relationDescriptor)) continue;
            return false;
        }
        return true;
    }
}

